// ****************************************************************************
//                               EnzoPluginInfo.h
// ****************************************************************************

#ifndef ENZO_PLUGIN_INFO_H
#define ENZO_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: EnzoDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Enzo plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:37:54 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class EnzoGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class EnzoCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual EnzoGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class EnzoMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual EnzoCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class EnzoEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual EnzoCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
