#include <EnzoPluginInfo.h>
#include <avtEnzoFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  EnzoCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Enzo database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:37:54 PST 2005
//
// ****************************************************************************
DatabaseType
EnzoCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  EnzoCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Enzo database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:37:54 PST 2005
//
// ****************************************************************************
std::vector<std::string>
EnzoCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("hierarchy");
    defaultExtensions.push_back("boundary");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: EnzoCommonPluginInfo::SetUpEnzoDatabase
//
//  Purpose:
//      Sets up a Enzo database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Enzo database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:37:54 PST 2005
//
// ****************************************************************************
avtDatabase *
EnzoCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtEnzoFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
