#include <EnSightPluginInfo.h>
#include <avtEnSightFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  EnSightCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a EnSight database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:37:19 PST 2005
//
// ****************************************************************************
DatabaseType
EnSightCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method:  EnSightCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a EnSight database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:37:19 PST 2005
//
// ****************************************************************************
std::vector<std::string>
EnSightCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("case");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: EnSightCommonPluginInfo::SetUpEnSightDatabase
//
//  Purpose:
//      Sets up a EnSight database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A EnSight database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:37:19 PST 2005
//
// ****************************************************************************
avtDatabase *
EnSightCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    return new avtGenericDatabase(
               new avtMTMDFileFormatInterface(
                   new avtEnSightFileFormat(list[0])));
}
