#include <DunePluginInfo.h>
#include <avtDuneFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  DuneCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Dune database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:36:58 PST 2005
//
// ****************************************************************************
DatabaseType
DuneCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method:  DuneCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Dune database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:36:58 PST 2005
//
// ****************************************************************************
std::vector<std::string>
DuneCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("Dat");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: DuneCommonPluginInfo::SetUpDuneDatabase
//
//  Purpose:
//      Sets up a Dune database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Dune database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:36:58 PST 2005
//
// ****************************************************************************
avtDatabase *
DuneCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtMTSDFileFormat **ffl = new avtMTSDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtDuneFileFormat(list[i]);
    }
    avtMTSDFileFormatInterface *inter 
           = new avtMTSDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
