// ****************************************************************************
//                               Curve2DPluginInfo.h
// ****************************************************************************

#ifndef CURVE2D_PLUGIN_INFO_H
#define CURVE2D_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: Curve2DDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Curve2D plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:36:40 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class Curve2DGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class Curve2DCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual Curve2DGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class Curve2DMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual Curve2DCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class Curve2DEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual Curve2DCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
