#include <Curve2DPluginInfo.h>
#include <avtCurve2DFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  Curve2DCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Curve2D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:36:40 PST 2005
//
// ****************************************************************************
DatabaseType
Curve2DCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  Curve2DCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Curve2D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:36:40 PST 2005
//
// ****************************************************************************
std::vector<std::string>
Curve2DCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("curve");
    defaultExtensions.push_back("ultra");
    defaultExtensions.push_back("ult");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: Curve2DCommonPluginInfo::SetUpCurve2DDatabase
//
//  Purpose:
//      Sets up a Curve2D database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Curve2D database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:36:40 PST 2005
//
// ****************************************************************************
avtDatabase *
Curve2DCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtCurve2DFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
