// ****************************************************************************
//                               CosmosPPPluginInfo.h
// ****************************************************************************

#ifndef COSMOSPP_PLUGIN_INFO_H
#define COSMOSPP_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: CosmosPPDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the CosmosPP plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:36:06 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class CosmosPPGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class CosmosPPCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual CosmosPPGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class CosmosPPMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual CosmosPPCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class CosmosPPEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual CosmosPPCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
