#include <CosmosPPPluginInfo.h>
#include <avtCosmosPPFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  CosmosPPCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a CosmosPP database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:36:06 PST 2005
//
// ****************************************************************************
DatabaseType
CosmosPPCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method:  CosmosPPCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a CosmosPP database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:36:06 PST 2005
//
// ****************************************************************************
std::vector<std::string>
CosmosPPCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("cosmospp");
    defaultExtensions.push_back("cosmos++");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: CosmosPPCommonPluginInfo::SetUpCosmosPPDatabase
//
//  Purpose:
//      Sets up a CosmosPP database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A CosmosPP database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:36:06 PST 2005
//
// ****************************************************************************
avtDatabase *
CosmosPPCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    return new avtGenericDatabase(
               new avtMTMDFileFormatInterface(
                   new avtCosmosPPFileFormat(list[0])));
}
