// ****************************************************************************
//                               CosmosPluginInfo.h
// ****************************************************************************

#ifndef COSMOS_PLUGIN_INFO_H
#define COSMOS_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: CosmosDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Cosmos plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:35:19 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class CosmosGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class CosmosCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual CosmosGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class CosmosMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual CosmosCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class CosmosEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual CosmosCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
