#include <CosmosPluginInfo.h>
#include <avtCosmosFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  CosmosCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Cosmos database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:35:19 PST 2005
//
// ****************************************************************************
DatabaseType
CosmosCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method:  CosmosCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Cosmos database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:35:19 PST 2005
//
// ****************************************************************************
std::vector<std::string>
CosmosCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("cosmos");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: CosmosCommonPluginInfo::SetUpCosmosDatabase
//
//  Purpose:
//      Sets up a Cosmos database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Cosmos database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:35:19 PST 2005
//
// ****************************************************************************
avtDatabase *
CosmosCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    return new avtGenericDatabase(
               new avtMTMDFileFormatInterface(
                   new avtCosmosFileFormat(list[0])));
}
