#include <CMATPluginInfo.h>
#include <avtCMATFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  CMATCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a CMAT database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:35:02 PST 2005
//
// ****************************************************************************
DatabaseType
CMATCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  CMATCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a CMAT database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:35:02 PST 2005
//
// ****************************************************************************
std::vector<std::string>
CMATCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("cmat");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: CMATCommonPluginInfo::SetUpCMATDatabase
//
//  Purpose:
//      Sets up a CMAT database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A CMAT database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:35:02 PST 2005
//
// ****************************************************************************
avtDatabase *
CMATCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtCMATFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
