#include <Boxlib3DPluginInfo.h>
#include <avtBoxlib3DFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  Boxlib3DCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Boxlib3D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:34:41 PST 2005
//
// ****************************************************************************
DatabaseType
Boxlib3DCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  Boxlib3DCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Boxlib3D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:34:41 PST 2005
//
// ****************************************************************************
std::vector<std::string>
Boxlib3DCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("boxlib3d");
    defaultExtensions.push_back("boxlib3D");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: Boxlib3DCommonPluginInfo::SetUpBoxlib3DDatabase
//
//  Purpose:
//      Sets up a Boxlib3D database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Boxlib3D database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:34:41 PST 2005
//
// ****************************************************************************
avtDatabase *
Boxlib3DCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtBoxlib3DFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
