#include <Boxlib2DPluginInfo.h>
#include <avtBoxlib2DFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  Boxlib2DCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Boxlib2D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:34:18 PST 2005
//
// ****************************************************************************
DatabaseType
Boxlib2DCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  Boxlib2DCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Boxlib2D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:34:18 PST 2005
//
// ****************************************************************************
std::vector<std::string>
Boxlib2DCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("boxlib2d");
    defaultExtensions.push_back("boxlib2D");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: Boxlib2DCommonPluginInfo::SetUpBoxlib2DDatabase
//
//  Purpose:
//      Sets up a Boxlib2D database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Boxlib2D database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:34:18 PST 2005
//
// ****************************************************************************
avtDatabase *
Boxlib2DCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtBoxlib2DFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
