// ****************************************************************************
//                               BOVPluginInfo.h
// ****************************************************************************

#ifndef BOV_PLUGIN_INFO_H
#define BOV_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: BOVDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the BOV plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:34:01 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class BOVGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class BOVCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual BOVGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class BOVMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual BOVCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class BOVEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual BOVCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
