#include <BOVPluginInfo.h>
#include <avtBOVFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  BOVCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a BOV database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:34:01 PST 2005
//
// ****************************************************************************
DatabaseType
BOVCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  BOVCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a BOV database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:34:01 PST 2005
//
// ****************************************************************************
std::vector<std::string>
BOVCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("bov");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: BOVCommonPluginInfo::SetUpBOVDatabase
//
//  Purpose:
//      Sets up a BOV database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A BOV database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:34:01 PST 2005
//
// ****************************************************************************
avtDatabase *
BOVCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtBOVFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
