// ****************************************************************************
//                               ANALYZEPluginInfo.h
// ****************************************************************************

#ifndef ANALYZE_PLUGIN_INFO_H
#define ANALYZE_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: ANALYZEDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the ANALYZE plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:33:46 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class ANALYZEGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class ANALYZECommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual ANALYZEGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class ANALYZEMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual ANALYZECommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class ANALYZEEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual ANALYZECommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
