#include <ANALYZEPluginInfo.h>
#include <avtANALYZEFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  ANALYZECommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a ANALYZE database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:33:46 PST 2005
//
// ****************************************************************************
DatabaseType
ANALYZECommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  ANALYZECommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a ANALYZE database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:33:46 PST 2005
//
// ****************************************************************************
std::vector<std::string>
ANALYZECommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("img");
    defaultExtensions.push_back("hdr");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: ANALYZECommonPluginInfo::SetUpANALYZEDatabase
//
//  Purpose:
//      Sets up a ANALYZE database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A ANALYZE database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:33:46 PST 2005
//
// ****************************************************************************
avtDatabase *
ANALYZECommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtANALYZEFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
