#include <MinMaxInfo.h>
#include <DataNode.h>
#include <avtVector.h>

// ****************************************************************************
// Method: MinMaxInfo::MinMaxInfo
//
// Purpose: 
//   Constructor for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

MinMaxInfo::MinMaxInfo() : AttributeSubject("iifFss")
{
    elementNum = -1;
    domain = -1;
    value = 0;
}

// ****************************************************************************
// Method: MinMaxInfo::MinMaxInfo
//
// Purpose: 
//   Copy constructor for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

MinMaxInfo::MinMaxInfo(const MinMaxInfo &obj) : AttributeSubject("iifFss")
{
    elementNum = obj.elementNum;
    domain = obj.domain;
    value = obj.value;
    coord[0] = obj.coord[0];
    coord[1] = obj.coord[1];
    coord[2] = obj.coord[2];

    type = obj.type;
    matName = obj.matName;

    SelectAll();
}

// ****************************************************************************
// Method: MinMaxInfo::~MinMaxInfo
//
// Purpose: 
//   Destructor for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

MinMaxInfo::~MinMaxInfo()
{
    // nothing here
}

// ****************************************************************************
// Method: MinMaxInfo::operator = 
//
// Purpose: 
//   Assignment operator for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
MinMaxInfo::operator = (const MinMaxInfo &obj)
{
    elementNum = obj.elementNum;
    domain = obj.domain;
    value = obj.value;
    coord[0] = obj.coord[0];
    coord[1] = obj.coord[1];
    coord[2] = obj.coord[2];

    type = obj.type;
    matName = obj.matName;

    SelectAll();
}

// ****************************************************************************
// Method: MinMaxInfo::operator == 
//
// Purpose: 
//   Comparison operator == for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MinMaxInfo::operator == (const MinMaxInfo &obj) const
{
    int i;

    // Compare the coord arrays.
    bool coord_equal = true;
    for(i = 0; i < 3 && coord_equal; ++i)
        coord_equal = (coord[i] == obj.coord[i]);

    // Create the return value
    return ((elementNum == obj.elementNum) &&
            (domain == obj.domain) &&
            (value == obj.value) &&
            coord_equal &&
            (type == obj.type) &&
            (matName == obj.matName));
}

// ****************************************************************************
// Method: MinMaxInfo::operator != 
//
// Purpose: 
//   Comparison operator != for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MinMaxInfo::operator != (const MinMaxInfo &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MinMaxInfo::TypeName
//
// Purpose: 
//   Type name method for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
MinMaxInfo::TypeName() const
{
    return "MinMaxInfo";
}

// ****************************************************************************
// Method: MinMaxInfo::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MinMaxInfo::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MinMaxInfo *tmp = (const MinMaxInfo *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MinMaxInfo::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MinMaxInfo::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MinMaxInfo(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MinMaxInfo::NewInstance
//
// Purpose: 
//   NewInstance method for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MinMaxInfo::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MinMaxInfo(*this);
    else
        retval = new MinMaxInfo;

    return retval;
}

// ****************************************************************************
// Method: MinMaxInfo::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
MinMaxInfo::SelectAll()
{
    Select(0, (void *)&elementNum);
    Select(1, (void *)&domain);
    Select(2, (void *)&value);
    Select(3, (void *)coord, 3);
    Select(4, (void *)&type);
    Select(5, (void *)&matName);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MinMaxInfo::SetElementNum(int elementNum_)
{
    elementNum = elementNum_;
    Select(0, (void *)&elementNum);
}

void
MinMaxInfo::SetDomain(int domain_)
{
    domain = domain_;
    Select(1, (void *)&domain);
}

void
MinMaxInfo::SetValue(float value_)
{
    value = value_;
    Select(2, (void *)&value);
}

void
MinMaxInfo::SetCoord(const float *coord_)
{
    coord[0] = coord_[0];
    coord[1] = coord_[1];
    coord[2] = coord_[2];
    Select(3, (void *)coord, 3);
}

void
MinMaxInfo::SetType(const std::string &type_)
{
    type = type_;
    Select(4, (void *)&type);
}

void
MinMaxInfo::SetMatName(const std::string &matName_)
{
    matName = matName_;
    Select(5, (void *)&matName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
MinMaxInfo::GetElementNum() const
{
    return elementNum;
}

int
MinMaxInfo::GetDomain() const
{
    return domain;
}

float
MinMaxInfo::GetValue() const
{
    return value;
}

const float *
MinMaxInfo::GetCoord() const
{
    return coord;
}

float *
MinMaxInfo::GetCoord()
{
    return coord;
}

const std::string &
MinMaxInfo::GetType() const
{
    return type;
}

std::string &
MinMaxInfo::GetType()
{
    return type;
}

const std::string &
MinMaxInfo::GetMatName() const
{
    return matName;
}

std::string &
MinMaxInfo::GetMatName()
{
    return matName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
MinMaxInfo::SelectCoord()
{
    Select(3, (void *)coord, 3);
}

void
MinMaxInfo::SelectType()
{
    Select(4, (void *)&type);
}

void
MinMaxInfo::SelectMatName()
{
    Select(5, (void *)&matName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MinMaxInfo::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
MinMaxInfo::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "elementNum";
        case 1:  return "domain";
        case 2:  return "value";
        case 3:  return "coord";
        case 4:  return "type";
        case 5:  return "matName";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MinMaxInfo::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MinMaxInfo::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_int;
        case 1:  return FieldType_int;
        case 2:  return FieldType_float;
        case 3:  return FieldType_floatArray;
        case 4:  return FieldType_string;
        case 5:  return FieldType_string;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MinMaxInfo::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
MinMaxInfo::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "int";
        case 1:  return "int";
        case 2:  return "float";
        case 3:  return "floatArray";
        case 4:  return "string";
        case 5:  return "string";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MinMaxInfo::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 28 08:58:20 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MinMaxInfo::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const MinMaxInfo &obj = *((const MinMaxInfo*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (elementNum == obj.elementNum);
        }
        break;
    case 1:
        {  // new scope
        retval = (domain == obj.domain);
        }
        break;
    case 2:
        {  // new scope
        retval = (value == obj.value);
        }
        break;
    case 3:
        {  // new scope
        // Compare the coord arrays.
        bool coord_equal = true;
        for(i = 0; i < 3 && coord_equal; ++i)
            coord_equal = (coord[i] == obj.coord[i]);

        retval = coord_equal;
        }
        break;
    case 4:
        {  // new scope
        retval = (type == obj.type);
        }
        break;
    case 5:
        {  // new scope
        retval = (matName == obj.matName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: MinMaxInfo::Initialize
//
//  Purpose:
//    Initialize the members.  
//
//  Programmer:   Kathleen Bonnell 
//  Creation:     July 1, 2004 
//
//  Modifications:
//
// ****************************************************************************

void
MinMaxInfo::Initialize(const float val, const std::string &t)
{
    elementNum = -1;
    domain = -1;
    value = val;
    coord[0] = 0.;
    coord[1] = 0.;
    coord[2] = 0.;
    type = t;
    matName = "NO_MAT";
}

// ****************************************************************************
//  Method: MinMaxInfo::TransformCoord
//
//  Purpose:
//    Transform the coord using the given matrix. 
//
//  Programmer:   Kathleen Bonnell 
//  Creation:     July 1, 2004 
//
//  Modifications:
//
// ****************************************************************************

void
MinMaxInfo::TransformCoord(const avtMatrix *trans)
{
    if (trans != NULL)
    {
        avtVector v1(coord[0], coord[1], coord[2]);
        v1 = (*trans) * v1;
        coord[0] = v1.x;
        coord[1] = v1.y;
        coord[2] = v1.z;
    }
}

// ****************************************************************************
//  Method: MinMaxInfo::EquivalentForOutput
//
//  Purpose:
//    Determine equivalency for output purposes (matname not considered). 
//
//  Programmer:   Kathleen Bonnell 
//  Creation:     July 28, 2004 
//
//  Modifications:
//
// ****************************************************************************

bool
MinMaxInfo::EquivalentForOutput(const MinMaxInfo &obj) const
{
    int i;

    // Compare the coord arrays.
    bool coord_equal = true;
    for(i = 0; i < 3 && coord_equal; ++i)
        coord_equal = (coord[i] == obj.coord[i]);

    // Create the return value
    return ((elementNum == obj.elementNum) &&
            (domain == obj.domain) &&
            (value == obj.value) &&
            coord_equal &&
            (type == obj.type));
}

