#include "BitUtils.h"

// ----------------------------------------------------------------------------
//  Programmer: Jeremy Meredith
//  Date:       August 21, 2003
// ----------------------------------------------------------------------------

const unsigned char nBitsSet[256] = {
    0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
    1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
    1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
    2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
    1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
    2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
    2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
    3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8
};

const signed char bitsSet[256][8] = {
    {-1, -1, -1, -1, -1, -1, -1, -1},
    { 0, -1, -1, -1, -1, -1, -1, -1},
    { 1, -1, -1, -1, -1, -1, -1, -1},
    { 0,  1, -1, -1, -1, -1, -1, -1},
    { 2, -1, -1, -1, -1, -1, -1, -1},
    { 0,  2, -1, -1, -1, -1, -1, -1},
    { 1,  2, -1, -1, -1, -1, -1, -1},
    { 0,  1,  2, -1, -1, -1, -1, -1},
    { 3, -1, -1, -1, -1, -1, -1, -1},
    { 0,  3, -1, -1, -1, -1, -1, -1},
    { 1,  3, -1, -1, -1, -1, -1, -1},
    { 0,  1,  3, -1, -1, -1, -1, -1},
    { 2,  3, -1, -1, -1, -1, -1, -1},
    { 0,  2,  3, -1, -1, -1, -1, -1},
    { 1,  2,  3, -1, -1, -1, -1, -1},
    { 0,  1,  2,  3, -1, -1, -1, -1},
    { 4, -1, -1, -1, -1, -1, -1, -1},
    { 0,  4, -1, -1, -1, -1, -1, -1},
    { 1,  4, -1, -1, -1, -1, -1, -1},
    { 0,  1,  4, -1, -1, -1, -1, -1},
    { 2,  4, -1, -1, -1, -1, -1, -1},
    { 0,  2,  4, -1, -1, -1, -1, -1},
    { 1,  2,  4, -1, -1, -1, -1, -1},
    { 0,  1,  2,  4, -1, -1, -1, -1},
    { 3,  4, -1, -1, -1, -1, -1, -1},
    { 0,  3,  4, -1, -1, -1, -1, -1},
    { 1,  3,  4, -1, -1, -1, -1, -1},
    { 0,  1,  3,  4, -1, -1, -1, -1},
    { 2,  3,  4, -1, -1, -1, -1, -1},
    { 0,  2,  3,  4, -1, -1, -1, -1},
    { 1,  2,  3,  4, -1, -1, -1, -1},
    { 0,  1,  2,  3,  4, -1, -1, -1},
    { 5, -1, -1, -1, -1, -1, -1, -1},
    { 0,  5, -1, -1, -1, -1, -1, -1},
    { 1,  5, -1, -1, -1, -1, -1, -1},
    { 0,  1,  5, -1, -1, -1, -1, -1},
    { 2,  5, -1, -1, -1, -1, -1, -1},
    { 0,  2,  5, -1, -1, -1, -1, -1},
    { 1,  2,  5, -1, -1, -1, -1, -1},
    { 0,  1,  2,  5, -1, -1, -1, -1},
    { 3,  5, -1, -1, -1, -1, -1, -1},
    { 0,  3,  5, -1, -1, -1, -1, -1},
    { 1,  3,  5, -1, -1, -1, -1, -1},
    { 0,  1,  3,  5, -1, -1, -1, -1},
    { 2,  3,  5, -1, -1, -1, -1, -1},
    { 0,  2,  3,  5, -1, -1, -1, -1},
    { 1,  2,  3,  5, -1, -1, -1, -1},
    { 0,  1,  2,  3,  5, -1, -1, -1},
    { 4,  5, -1, -1, -1, -1, -1, -1},
    { 0,  4,  5, -1, -1, -1, -1, -1},
    { 1,  4,  5, -1, -1, -1, -1, -1},
    { 0,  1,  4,  5, -1, -1, -1, -1},
    { 2,  4,  5, -1, -1, -1, -1, -1},
    { 0,  2,  4,  5, -1, -1, -1, -1},
    { 1,  2,  4,  5, -1, -1, -1, -1},
    { 0,  1,  2,  4,  5, -1, -1, -1},
    { 3,  4,  5, -1, -1, -1, -1, -1},
    { 0,  3,  4,  5, -1, -1, -1, -1},
    { 1,  3,  4,  5, -1, -1, -1, -1},
    { 0,  1,  3,  4,  5, -1, -1, -1},
    { 2,  3,  4,  5, -1, -1, -1, -1},
    { 0,  2,  3,  4,  5, -1, -1, -1},
    { 1,  2,  3,  4,  5, -1, -1, -1},
    { 0,  1,  2,  3,  4,  5, -1, -1},
    { 6, -1, -1, -1, -1, -1, -1, -1},
    { 0,  6, -1, -1, -1, -1, -1, -1},
    { 1,  6, -1, -1, -1, -1, -1, -1},
    { 0,  1,  6, -1, -1, -1, -1, -1},
    { 2,  6, -1, -1, -1, -1, -1, -1},
    { 0,  2,  6, -1, -1, -1, -1, -1},
    { 1,  2,  6, -1, -1, -1, -1, -1},
    { 0,  1,  2,  6, -1, -1, -1, -1},
    { 3,  6, -1, -1, -1, -1, -1, -1},
    { 0,  3,  6, -1, -1, -1, -1, -1},
    { 1,  3,  6, -1, -1, -1, -1, -1},
    { 0,  1,  3,  6, -1, -1, -1, -1},
    { 2,  3,  6, -1, -1, -1, -1, -1},
    { 0,  2,  3,  6, -1, -1, -1, -1},
    { 1,  2,  3,  6, -1, -1, -1, -1},
    { 0,  1,  2,  3,  6, -1, -1, -1},
    { 4,  6, -1, -1, -1, -1, -1, -1},
    { 0,  4,  6, -1, -1, -1, -1, -1},
    { 1,  4,  6, -1, -1, -1, -1, -1},
    { 0,  1,  4,  6, -1, -1, -1, -1},
    { 2,  4,  6, -1, -1, -1, -1, -1},
    { 0,  2,  4,  6, -1, -1, -1, -1},
    { 1,  2,  4,  6, -1, -1, -1, -1},
    { 0,  1,  2,  4,  6, -1, -1, -1},
    { 3,  4,  6, -1, -1, -1, -1, -1},
    { 0,  3,  4,  6, -1, -1, -1, -1},
    { 1,  3,  4,  6, -1, -1, -1, -1},
    { 0,  1,  3,  4,  6, -1, -1, -1},
    { 2,  3,  4,  6, -1, -1, -1, -1},
    { 0,  2,  3,  4,  6, -1, -1, -1},
    { 1,  2,  3,  4,  6, -1, -1, -1},
    { 0,  1,  2,  3,  4,  6, -1, -1},
    { 5,  6, -1, -1, -1, -1, -1, -1},
    { 0,  5,  6, -1, -1, -1, -1, -1},
    { 1,  5,  6, -1, -1, -1, -1, -1},
    { 0,  1,  5,  6, -1, -1, -1, -1},
    { 2,  5,  6, -1, -1, -1, -1, -1},
    { 0,  2,  5,  6, -1, -1, -1, -1},
    { 1,  2,  5,  6, -1, -1, -1, -1},
    { 0,  1,  2,  5,  6, -1, -1, -1},
    { 3,  5,  6, -1, -1, -1, -1, -1},
    { 0,  3,  5,  6, -1, -1, -1, -1},
    { 1,  3,  5,  6, -1, -1, -1, -1},
    { 0,  1,  3,  5,  6, -1, -1, -1},
    { 2,  3,  5,  6, -1, -1, -1, -1},
    { 0,  2,  3,  5,  6, -1, -1, -1},
    { 1,  2,  3,  5,  6, -1, -1, -1},
    { 0,  1,  2,  3,  5,  6, -1, -1},
    { 4,  5,  6, -1, -1, -1, -1, -1},
    { 0,  4,  5,  6, -1, -1, -1, -1},
    { 1,  4,  5,  6, -1, -1, -1, -1},
    { 0,  1,  4,  5,  6, -1, -1, -1},
    { 2,  4,  5,  6, -1, -1, -1, -1},
    { 0,  2,  4,  5,  6, -1, -1, -1},
    { 1,  2,  4,  5,  6, -1, -1, -1},
    { 0,  1,  2,  4,  5,  6, -1, -1},
    { 3,  4,  5,  6, -1, -1, -1, -1},
    { 0,  3,  4,  5,  6, -1, -1, -1},
    { 1,  3,  4,  5,  6, -1, -1, -1},
    { 0,  1,  3,  4,  5,  6, -1, -1},
    { 2,  3,  4,  5,  6, -1, -1, -1},
    { 0,  2,  3,  4,  5,  6, -1, -1},
    { 1,  2,  3,  4,  5,  6, -1, -1},
    { 0,  1,  2,  3,  4,  5,  6, -1},
    { 7, -1, -1, -1, -1, -1, -1, -1},
    { 0,  7, -1, -1, -1, -1, -1, -1},
    { 1,  7, -1, -1, -1, -1, -1, -1},
    { 0,  1,  7, -1, -1, -1, -1, -1},
    { 2,  7, -1, -1, -1, -1, -1, -1},
    { 0,  2,  7, -1, -1, -1, -1, -1},
    { 1,  2,  7, -1, -1, -1, -1, -1},
    { 0,  1,  2,  7, -1, -1, -1, -1},
    { 3,  7, -1, -1, -1, -1, -1, -1},
    { 0,  3,  7, -1, -1, -1, -1, -1},
    { 1,  3,  7, -1, -1, -1, -1, -1},
    { 0,  1,  3,  7, -1, -1, -1, -1},
    { 2,  3,  7, -1, -1, -1, -1, -1},
    { 0,  2,  3,  7, -1, -1, -1, -1},
    { 1,  2,  3,  7, -1, -1, -1, -1},
    { 0,  1,  2,  3,  7, -1, -1, -1},
    { 4,  7, -1, -1, -1, -1, -1, -1},
    { 0,  4,  7, -1, -1, -1, -1, -1},
    { 1,  4,  7, -1, -1, -1, -1, -1},
    { 0,  1,  4,  7, -1, -1, -1, -1},
    { 2,  4,  7, -1, -1, -1, -1, -1},
    { 0,  2,  4,  7, -1, -1, -1, -1},
    { 1,  2,  4,  7, -1, -1, -1, -1},
    { 0,  1,  2,  4,  7, -1, -1, -1},
    { 3,  4,  7, -1, -1, -1, -1, -1},
    { 0,  3,  4,  7, -1, -1, -1, -1},
    { 1,  3,  4,  7, -1, -1, -1, -1},
    { 0,  1,  3,  4,  7, -1, -1, -1},
    { 2,  3,  4,  7, -1, -1, -1, -1},
    { 0,  2,  3,  4,  7, -1, -1, -1},
    { 1,  2,  3,  4,  7, -1, -1, -1},
    { 0,  1,  2,  3,  4,  7, -1, -1},
    { 5,  7, -1, -1, -1, -1, -1, -1},
    { 0,  5,  7, -1, -1, -1, -1, -1},
    { 1,  5,  7, -1, -1, -1, -1, -1},
    { 0,  1,  5,  7, -1, -1, -1, -1},
    { 2,  5,  7, -1, -1, -1, -1, -1},
    { 0,  2,  5,  7, -1, -1, -1, -1},
    { 1,  2,  5,  7, -1, -1, -1, -1},
    { 0,  1,  2,  5,  7, -1, -1, -1},
    { 3,  5,  7, -1, -1, -1, -1, -1},
    { 0,  3,  5,  7, -1, -1, -1, -1},
    { 1,  3,  5,  7, -1, -1, -1, -1},
    { 0,  1,  3,  5,  7, -1, -1, -1},
    { 2,  3,  5,  7, -1, -1, -1, -1},
    { 0,  2,  3,  5,  7, -1, -1, -1},
    { 1,  2,  3,  5,  7, -1, -1, -1},
    { 0,  1,  2,  3,  5,  7, -1, -1},
    { 4,  5,  7, -1, -1, -1, -1, -1},
    { 0,  4,  5,  7, -1, -1, -1, -1},
    { 1,  4,  5,  7, -1, -1, -1, -1},
    { 0,  1,  4,  5,  7, -1, -1, -1},
    { 2,  4,  5,  7, -1, -1, -1, -1},
    { 0,  2,  4,  5,  7, -1, -1, -1},
    { 1,  2,  4,  5,  7, -1, -1, -1},
    { 0,  1,  2,  4,  5,  7, -1, -1},
    { 3,  4,  5,  7, -1, -1, -1, -1},
    { 0,  3,  4,  5,  7, -1, -1, -1},
    { 1,  3,  4,  5,  7, -1, -1, -1},
    { 0,  1,  3,  4,  5,  7, -1, -1},
    { 2,  3,  4,  5,  7, -1, -1, -1},
    { 0,  2,  3,  4,  5,  7, -1, -1},
    { 1,  2,  3,  4,  5,  7, -1, -1},
    { 0,  1,  2,  3,  4,  5,  7, -1},
    { 6,  7, -1, -1, -1, -1, -1, -1},
    { 0,  6,  7, -1, -1, -1, -1, -1},
    { 1,  6,  7, -1, -1, -1, -1, -1},
    { 0,  1,  6,  7, -1, -1, -1, -1},
    { 2,  6,  7, -1, -1, -1, -1, -1},
    { 0,  2,  6,  7, -1, -1, -1, -1},
    { 1,  2,  6,  7, -1, -1, -1, -1},
    { 0,  1,  2,  6,  7, -1, -1, -1},
    { 3,  6,  7, -1, -1, -1, -1, -1},
    { 0,  3,  6,  7, -1, -1, -1, -1},
    { 1,  3,  6,  7, -1, -1, -1, -1},
    { 0,  1,  3,  6,  7, -1, -1, -1},
    { 2,  3,  6,  7, -1, -1, -1, -1},
    { 0,  2,  3,  6,  7, -1, -1, -1},
    { 1,  2,  3,  6,  7, -1, -1, -1},
    { 0,  1,  2,  3,  6,  7, -1, -1},
    { 4,  6,  7, -1, -1, -1, -1, -1},
    { 0,  4,  6,  7, -1, -1, -1, -1},
    { 1,  4,  6,  7, -1, -1, -1, -1},
    { 0,  1,  4,  6,  7, -1, -1, -1},
    { 2,  4,  6,  7, -1, -1, -1, -1},
    { 0,  2,  4,  6,  7, -1, -1, -1},
    { 1,  2,  4,  6,  7, -1, -1, -1},
    { 0,  1,  2,  4,  6,  7, -1, -1},
    { 3,  4,  6,  7, -1, -1, -1, -1},
    { 0,  3,  4,  6,  7, -1, -1, -1},
    { 1,  3,  4,  6,  7, -1, -1, -1},
    { 0,  1,  3,  4,  6,  7, -1, -1},
    { 2,  3,  4,  6,  7, -1, -1, -1},
    { 0,  2,  3,  4,  6,  7, -1, -1},
    { 1,  2,  3,  4,  6,  7, -1, -1},
    { 0,  1,  2,  3,  4,  6,  7, -1},
    { 5,  6,  7, -1, -1, -1, -1, -1},
    { 0,  5,  6,  7, -1, -1, -1, -1},
    { 1,  5,  6,  7, -1, -1, -1, -1},
    { 0,  1,  5,  6,  7, -1, -1, -1},
    { 2,  5,  6,  7, -1, -1, -1, -1},
    { 0,  2,  5,  6,  7, -1, -1, -1},
    { 1,  2,  5,  6,  7, -1, -1, -1},
    { 0,  1,  2,  5,  6,  7, -1, -1},
    { 3,  5,  6,  7, -1, -1, -1, -1},
    { 0,  3,  5,  6,  7, -1, -1, -1},
    { 1,  3,  5,  6,  7, -1, -1, -1},
    { 0,  1,  3,  5,  6,  7, -1, -1},
    { 2,  3,  5,  6,  7, -1, -1, -1},
    { 0,  2,  3,  5,  6,  7, -1, -1},
    { 1,  2,  3,  5,  6,  7, -1, -1},
    { 0,  1,  2,  3,  5,  6,  7, -1},
    { 4,  5,  6,  7, -1, -1, -1, -1},
    { 0,  4,  5,  6,  7, -1, -1, -1},
    { 1,  4,  5,  6,  7, -1, -1, -1},
    { 0,  1,  4,  5,  6,  7, -1, -1},
    { 2,  4,  5,  6,  7, -1, -1, -1},
    { 0,  2,  4,  5,  6,  7, -1, -1},
    { 1,  2,  4,  5,  6,  7, -1, -1},
    { 0,  1,  2,  4,  5,  6,  7, -1},
    { 3,  4,  5,  6,  7, -1, -1, -1},
    { 0,  3,  4,  5,  6,  7, -1, -1},
    { 1,  3,  4,  5,  6,  7, -1, -1},
    { 0,  1,  3,  4,  5,  6,  7, -1},
    { 2,  3,  4,  5,  6,  7, -1, -1},
    { 0,  2,  3,  4,  5,  6,  7, -1},
    { 1,  2,  3,  4,  5,  6,  7, -1},
    { 0,  1,  2,  3,  4,  5,  6,  7}
};

const signed char bitPos[256][8] = {
    {-1, -1, -1, -1, -1, -1, -1, -1},
    { 0, -1, -1, -1, -1, -1, -1, -1},
    {-1,  0, -1, -1, -1, -1, -1, -1},
    { 0,  1, -1, -1, -1, -1, -1, -1},
    {-1, -1,  0, -1, -1, -1, -1, -1},
    { 0, -1,  1, -1, -1, -1, -1, -1},
    {-1,  0,  1, -1, -1, -1, -1, -1},
    { 0,  1,  2, -1, -1, -1, -1, -1},
    {-1, -1, -1,  0, -1, -1, -1, -1},
    { 0, -1, -1,  1, -1, -1, -1, -1},
    {-1,  0, -1,  1, -1, -1, -1, -1},
    { 0,  1, -1,  2, -1, -1, -1, -1},
    {-1, -1,  0,  1, -1, -1, -1, -1},
    { 0, -1,  1,  2, -1, -1, -1, -1},
    {-1,  0,  1,  2, -1, -1, -1, -1},
    { 0,  1,  2,  3, -1, -1, -1, -1},
    {-1, -1, -1, -1,  0, -1, -1, -1},
    { 0, -1, -1, -1,  1, -1, -1, -1},
    {-1,  0, -1, -1,  1, -1, -1, -1},
    { 0,  1, -1, -1,  2, -1, -1, -1},
    {-1, -1,  0, -1,  1, -1, -1, -1},
    { 0, -1,  1, -1,  2, -1, -1, -1},
    {-1,  0,  1, -1,  2, -1, -1, -1},
    { 0,  1,  2, -1,  3, -1, -1, -1},
    {-1, -1, -1,  0,  1, -1, -1, -1},
    { 0, -1, -1,  1,  2, -1, -1, -1},
    {-1,  0, -1,  1,  2, -1, -1, -1},
    { 0,  1, -1,  2,  3, -1, -1, -1},
    {-1, -1,  0,  1,  2, -1, -1, -1},
    { 0, -1,  1,  2,  3, -1, -1, -1},
    {-1,  0,  1,  2,  3, -1, -1, -1},
    { 0,  1,  2,  3,  4, -1, -1, -1},
    {-1, -1, -1, -1, -1,  0, -1, -1},
    { 0, -1, -1, -1, -1,  1, -1, -1},
    {-1,  0, -1, -1, -1,  1, -1, -1},
    { 0,  1, -1, -1, -1,  2, -1, -1},
    {-1, -1,  0, -1, -1,  1, -1, -1},
    { 0, -1,  1, -1, -1,  2, -1, -1},
    {-1,  0,  1, -1, -1,  2, -1, -1},
    { 0,  1,  2, -1, -1,  3, -1, -1},
    {-1, -1, -1,  0, -1,  1, -1, -1},
    { 0, -1, -1,  1, -1,  2, -1, -1},
    {-1,  0, -1,  1, -1,  2, -1, -1},
    { 0,  1, -1,  2, -1,  3, -1, -1},
    {-1, -1,  0,  1, -1,  2, -1, -1},
    { 0, -1,  1,  2, -1,  3, -1, -1},
    {-1,  0,  1,  2, -1,  3, -1, -1},
    { 0,  1,  2,  3, -1,  4, -1, -1},
    {-1, -1, -1, -1,  0,  1, -1, -1},
    { 0, -1, -1, -1,  1,  2, -1, -1},
    {-1,  0, -1, -1,  1,  2, -1, -1},
    { 0,  1, -1, -1,  2,  3, -1, -1},
    {-1, -1,  0, -1,  1,  2, -1, -1},
    { 0, -1,  1, -1,  2,  3, -1, -1},
    {-1,  0,  1, -1,  2,  3, -1, -1},
    { 0,  1,  2, -1,  3,  4, -1, -1},
    {-1, -1, -1,  0,  1,  2, -1, -1},
    { 0, -1, -1,  1,  2,  3, -1, -1},
    {-1,  0, -1,  1,  2,  3, -1, -1},
    { 0,  1, -1,  2,  3,  4, -1, -1},
    {-1, -1,  0,  1,  2,  3, -1, -1},
    { 0, -1,  1,  2,  3,  4, -1, -1},
    {-1,  0,  1,  2,  3,  4, -1, -1},
    { 0,  1,  2,  3,  4,  5, -1, -1},
    {-1, -1, -1, -1, -1, -1,  0, -1},
    { 0, -1, -1, -1, -1, -1,  1, -1},
    {-1,  0, -1, -1, -1, -1,  1, -1},
    { 0,  1, -1, -1, -1, -1,  2, -1},
    {-1, -1,  0, -1, -1, -1,  1, -1},
    { 0, -1,  1, -1, -1, -1,  2, -1},
    {-1,  0,  1, -1, -1, -1,  2, -1},
    { 0,  1,  2, -1, -1, -1,  3, -1},
    {-1, -1, -1,  0, -1, -1,  1, -1},
    { 0, -1, -1,  1, -1, -1,  2, -1},
    {-1,  0, -1,  1, -1, -1,  2, -1},
    { 0,  1, -1,  2, -1, -1,  3, -1},
    {-1, -1,  0,  1, -1, -1,  2, -1},
    { 0, -1,  1,  2, -1, -1,  3, -1},
    {-1,  0,  1,  2, -1, -1,  3, -1},
    { 0,  1,  2,  3, -1, -1,  4, -1},
    {-1, -1, -1, -1,  0, -1,  1, -1},
    { 0, -1, -1, -1,  1, -1,  2, -1},
    {-1,  0, -1, -1,  1, -1,  2, -1},
    { 0,  1, -1, -1,  2, -1,  3, -1},
    {-1, -1,  0, -1,  1, -1,  2, -1},
    { 0, -1,  1, -1,  2, -1,  3, -1},
    {-1,  0,  1, -1,  2, -1,  3, -1},
    { 0,  1,  2, -1,  3, -1,  4, -1},
    {-1, -1, -1,  0,  1, -1,  2, -1},
    { 0, -1, -1,  1,  2, -1,  3, -1},
    {-1,  0, -1,  1,  2, -1,  3, -1},
    { 0,  1, -1,  2,  3, -1,  4, -1},
    {-1, -1,  0,  1,  2, -1,  3, -1},
    { 0, -1,  1,  2,  3, -1,  4, -1},
    {-1,  0,  1,  2,  3, -1,  4, -1},
    { 0,  1,  2,  3,  4, -1,  5, -1},
    {-1, -1, -1, -1, -1,  0,  1, -1},
    { 0, -1, -1, -1, -1,  1,  2, -1},
    {-1,  0, -1, -1, -1,  1,  2, -1},
    { 0,  1, -1, -1, -1,  2,  3, -1},
    {-1, -1,  0, -1, -1,  1,  2, -1},
    { 0, -1,  1, -1, -1,  2,  3, -1},
    {-1,  0,  1, -1, -1,  2,  3, -1},
    { 0,  1,  2, -1, -1,  3,  4, -1},
    {-1, -1, -1,  0, -1,  1,  2, -1},
    { 0, -1, -1,  1, -1,  2,  3, -1},
    {-1,  0, -1,  1, -1,  2,  3, -1},
    { 0,  1, -1,  2, -1,  3,  4, -1},
    {-1, -1,  0,  1, -1,  2,  3, -1},
    { 0, -1,  1,  2, -1,  3,  4, -1},
    {-1,  0,  1,  2, -1,  3,  4, -1},
    { 0,  1,  2,  3, -1,  4,  5, -1},
    {-1, -1, -1, -1,  0,  1,  2, -1},
    { 0, -1, -1, -1,  1,  2,  3, -1},
    {-1,  0, -1, -1,  1,  2,  3, -1},
    { 0,  1, -1, -1,  2,  3,  4, -1},
    {-1, -1,  0, -1,  1,  2,  3, -1},
    { 0, -1,  1, -1,  2,  3,  4, -1},
    {-1,  0,  1, -1,  2,  3,  4, -1},
    { 0,  1,  2, -1,  3,  4,  5, -1},
    {-1, -1, -1,  0,  1,  2,  3, -1},
    { 0, -1, -1,  1,  2,  3,  4, -1},
    {-1,  0, -1,  1,  2,  3,  4, -1},
    { 0,  1, -1,  2,  3,  4,  5, -1},
    {-1, -1,  0,  1,  2,  3,  4, -1},
    { 0, -1,  1,  2,  3,  4,  5, -1},
    {-1,  0,  1,  2,  3,  4,  5, -1},
    { 0,  1,  2,  3,  4,  5,  6, -1},
    {-1, -1, -1, -1, -1, -1, -1,  0},
    { 0, -1, -1, -1, -1, -1, -1,  1},
    {-1,  0, -1, -1, -1, -1, -1,  1},
    { 0,  1, -1, -1, -1, -1, -1,  2},
    {-1, -1,  0, -1, -1, -1, -1,  1},
    { 0, -1,  1, -1, -1, -1, -1,  2},
    {-1,  0,  1, -1, -1, -1, -1,  2},
    { 0,  1,  2, -1, -1, -1, -1,  3},
    {-1, -1, -1,  0, -1, -1, -1,  1},
    { 0, -1, -1,  1, -1, -1, -1,  2},
    {-1,  0, -1,  1, -1, -1, -1,  2},
    { 0,  1, -1,  2, -1, -1, -1,  3},
    {-1, -1,  0,  1, -1, -1, -1,  2},
    { 0, -1,  1,  2, -1, -1, -1,  3},
    {-1,  0,  1,  2, -1, -1, -1,  3},
    { 0,  1,  2,  3, -1, -1, -1,  4},
    {-1, -1, -1, -1,  0, -1, -1,  1},
    { 0, -1, -1, -1,  1, -1, -1,  2},
    {-1,  0, -1, -1,  1, -1, -1,  2},
    { 0,  1, -1, -1,  2, -1, -1,  3},
    {-1, -1,  0, -1,  1, -1, -1,  2},
    { 0, -1,  1, -1,  2, -1, -1,  3},
    {-1,  0,  1, -1,  2, -1, -1,  3},
    { 0,  1,  2, -1,  3, -1, -1,  4},
    {-1, -1, -1,  0,  1, -1, -1,  2},
    { 0, -1, -1,  1,  2, -1, -1,  3},
    {-1,  0, -1,  1,  2, -1, -1,  3},
    { 0,  1, -1,  2,  3, -1, -1,  4},
    {-1, -1,  0,  1,  2, -1, -1,  3},
    { 0, -1,  1,  2,  3, -1, -1,  4},
    {-1,  0,  1,  2,  3, -1, -1,  4},
    { 0,  1,  2,  3,  4, -1, -1,  5},
    {-1, -1, -1, -1, -1,  0, -1,  1},
    { 0, -1, -1, -1, -1,  1, -1,  2},
    {-1,  0, -1, -1, -1,  1, -1,  2},
    { 0,  1, -1, -1, -1,  2, -1,  3},
    {-1, -1,  0, -1, -1,  1, -1,  2},
    { 0, -1,  1, -1, -1,  2, -1,  3},
    {-1,  0,  1, -1, -1,  2, -1,  3},
    { 0,  1,  2, -1, -1,  3, -1,  4},
    {-1, -1, -1,  0, -1,  1, -1,  2},
    { 0, -1, -1,  1, -1,  2, -1,  3},
    {-1,  0, -1,  1, -1,  2, -1,  3},
    { 0,  1, -1,  2, -1,  3, -1,  4},
    {-1, -1,  0,  1, -1,  2, -1,  3},
    { 0, -1,  1,  2, -1,  3, -1,  4},
    {-1,  0,  1,  2, -1,  3, -1,  4},
    { 0,  1,  2,  3, -1,  4, -1,  5},
    {-1, -1, -1, -1,  0,  1, -1,  2},
    { 0, -1, -1, -1,  1,  2, -1,  3},
    {-1,  0, -1, -1,  1,  2, -1,  3},
    { 0,  1, -1, -1,  2,  3, -1,  4},
    {-1, -1,  0, -1,  1,  2, -1,  3},
    { 0, -1,  1, -1,  2,  3, -1,  4},
    {-1,  0,  1, -1,  2,  3, -1,  4},
    { 0,  1,  2, -1,  3,  4, -1,  5},
    {-1, -1, -1,  0,  1,  2, -1,  3},
    { 0, -1, -1,  1,  2,  3, -1,  4},
    {-1,  0, -1,  1,  2,  3, -1,  4},
    { 0,  1, -1,  2,  3,  4, -1,  5},
    {-1, -1,  0,  1,  2,  3, -1,  4},
    { 0, -1,  1,  2,  3,  4, -1,  5},
    {-1,  0,  1,  2,  3,  4, -1,  5},
    { 0,  1,  2,  3,  4,  5, -1,  6},
    {-1, -1, -1, -1, -1, -1,  0,  1},
    { 0, -1, -1, -1, -1, -1,  1,  2},
    {-1,  0, -1, -1, -1, -1,  1,  2},
    { 0,  1, -1, -1, -1, -1,  2,  3},
    {-1, -1,  0, -1, -1, -1,  1,  2},
    { 0, -1,  1, -1, -1, -1,  2,  3},
    {-1,  0,  1, -1, -1, -1,  2,  3},
    { 0,  1,  2, -1, -1, -1,  3,  4},
    {-1, -1, -1,  0, -1, -1,  1,  2},
    { 0, -1, -1,  1, -1, -1,  2,  3},
    {-1,  0, -1,  1, -1, -1,  2,  3},
    { 0,  1, -1,  2, -1, -1,  3,  4},
    {-1, -1,  0,  1, -1, -1,  2,  3},
    { 0, -1,  1,  2, -1, -1,  3,  4},
    {-1,  0,  1,  2, -1, -1,  3,  4},
    { 0,  1,  2,  3, -1, -1,  4,  5},
    {-1, -1, -1, -1,  0, -1,  1,  2},
    { 0, -1, -1, -1,  1, -1,  2,  3},
    {-1,  0, -1, -1,  1, -1,  2,  3},
    { 0,  1, -1, -1,  2, -1,  3,  4},
    {-1, -1,  0, -1,  1, -1,  2,  3},
    { 0, -1,  1, -1,  2, -1,  3,  4},
    {-1,  0,  1, -1,  2, -1,  3,  4},
    { 0,  1,  2, -1,  3, -1,  4,  5},
    {-1, -1, -1,  0,  1, -1,  2,  3},
    { 0, -1, -1,  1,  2, -1,  3,  4},
    {-1,  0, -1,  1,  2, -1,  3,  4},
    { 0,  1, -1,  2,  3, -1,  4,  5},
    {-1, -1,  0,  1,  2, -1,  3,  4},
    { 0, -1,  1,  2,  3, -1,  4,  5},
    {-1,  0,  1,  2,  3, -1,  4,  5},
    { 0,  1,  2,  3,  4, -1,  5,  6},
    {-1, -1, -1, -1, -1,  0,  1,  2},
    { 0, -1, -1, -1, -1,  1,  2,  3},
    {-1,  0, -1, -1, -1,  1,  2,  3},
    { 0,  1, -1, -1, -1,  2,  3,  4},
    {-1, -1,  0, -1, -1,  1,  2,  3},
    { 0, -1,  1, -1, -1,  2,  3,  4},
    {-1,  0,  1, -1, -1,  2,  3,  4},
    { 0,  1,  2, -1, -1,  3,  4,  5},
    {-1, -1, -1,  0, -1,  1,  2,  3},
    { 0, -1, -1,  1, -1,  2,  3,  4},
    {-1,  0, -1,  1, -1,  2,  3,  4},
    { 0,  1, -1,  2, -1,  3,  4,  5},
    {-1, -1,  0,  1, -1,  2,  3,  4},
    { 0, -1,  1,  2, -1,  3,  4,  5},
    {-1,  0,  1,  2, -1,  3,  4,  5},
    { 0,  1,  2,  3, -1,  4,  5,  6},
    {-1, -1, -1, -1,  0,  1,  2,  3},
    { 0, -1, -1, -1,  1,  2,  3,  4},
    {-1,  0, -1, -1,  1,  2,  3,  4},
    { 0,  1, -1, -1,  2,  3,  4,  5},
    {-1, -1,  0, -1,  1,  2,  3,  4},
    { 0, -1,  1, -1,  2,  3,  4,  5},
    {-1,  0,  1, -1,  2,  3,  4,  5},
    { 0,  1,  2, -1,  3,  4,  5,  6},
    {-1, -1, -1,  0,  1,  2,  3,  4},
    { 0, -1, -1,  1,  2,  3,  4,  5},
    {-1,  0, -1,  1,  2,  3,  4,  5},
    { 0,  1, -1,  2,  3,  4,  5,  6},
    {-1, -1,  0,  1,  2,  3,  4,  5},
    { 0, -1,  1,  2,  3,  4,  5,  6},
    {-1,  0,  1,  2,  3,  4,  5,  6},
    { 0,  1,  2,  3,  4,  5,  6,  7}
};

