// ************************************************************************* //
//  File: avtCoordSystemConvert.h
// ************************************************************************* //

#ifndef AVT_CoordConvert_FILTER_H
#define AVT_CoordConvert_FILTER_H

#include <filters_exports.h>
#include <avtStreamer.h>


typedef enum
{
    CARTESIAN       = 0,
    CYLINDRICAL,   /* 1 */
    SPHERICAL      /* 2 */
} CoordSystem;

 
// ****************************************************************************
//  Class: avtCoordSystemConvert
//
//  Purpose:
//      A plugin operator for CoordConvert.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Jun 27 16:41:32 PST 2003
//
// ****************************************************************************

class AVTFILTERS_API avtCoordSystemConvert : public avtStreamer
{
  public:
                         avtCoordSystemConvert();
    virtual             ~avtCoordSystemConvert();

    virtual const char  *GetType(void)  { return "avtCoordSystemConvert"; };
    virtual const char  *GetDescription(void)
                             { return "Converting Coordinate System"; };

    void                 SetInputCoordSys(CoordSystem a) { inputSys = a; };
    void                 SetOutputCoordSys(CoordSystem a) { outputSys = a; };

  protected:
    CoordSystem           inputSys;
    CoordSystem           outputSys;

    virtual vtkDataSet   *ExecuteData(vtkDataSet *, int, std::string);
    virtual void          PostExecute(void);

    void                  TransformExtents(double *);
};


#endif
