// ************************************************************************* //
//                              avtVMetricAspectGamma.C                      //
// ************************************************************************* //

#include "avtVMetricAspectGamma.h"

#include <vtkCellType.h>
#include <vtkDataSet.h>
#include <vtkFloatArray.h>

#include <verdict.h>

#include <DebugStream.h>

// ****************************************************************************
//  Method: avtVMetricAspectGamma::Metric
//
//  Purpose:
//      Inspect an element and calculate the aspect_gamma.
//
//  Arguments:
//      coords    The set of xyz points for the cell.
//      numPoints The number of xyz points for the cell.
//      type      The vtk type of the cell.
//
//  Returns:      The aspect_gamma of the cell, or defaultValue if not supported.
//
//  Programmer:   Akira Haddox
//  Creation:     June 13, 2002
//
//  Modifications:
//
//    Hank Childs, Thu Oct 17 08:07:53 PDT 2002
//    Update for new verdict interface.
//
// ****************************************************************************

double avtVMetricAspectGamma::Metric (double coords[][3], int type)
{
#ifdef HAVE_VERDICT 
    switch (type)
    {
        case VTK_TETRA:
            return v_tet_aspect_gamma(4,coords);

        case VTK_TRIANGLE:
            return v_tri_aspect(3, coords);
    }
#endif
    return 0;
}
