#ifndef WINDOWINFORMATION_H
#define WINDOWINFORMATION_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: WindowInformation
//
// Purpose:
//    This class contains the attributes that tell the state of a viewer window.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

class STATE_API WindowInformation : public AttributeSubject
{
public:
    WindowInformation();
    WindowInformation(const WindowInformation &obj);
    virtual ~WindowInformation();

    virtual void operator = (const WindowInformation &obj);
    virtual bool operator == (const WindowInformation &obj) const;
    virtual bool operator != (const WindowInformation &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectActiveSource();
    void SelectTimeSliders();
    void SelectTimeSliderCurrentStates();
    void SelectViewKeyframes();
    void SelectExtents();

    // Property setting methods
    void SetActiveSource(const std::string &activeSource_);
    void SetActiveTimeSlider(int activeTimeSlider_);
    void SetTimeSliders(const stringVector &timeSliders_);
    void SetTimeSliderCurrentStates(const intVector &timeSliderCurrentStates_);
    void SetAnimationMode(int animationMode_);
    void SetWindowMode(int windowMode_);
    void SetBoundingBoxNavigate(bool boundingBoxNavigate_);
    void SetSpin(bool spin_);
    void SetFullFrame(bool fullFrame_);
    void SetPerspective(bool perspective_);
    void SetLockView(bool lockView_);
    void SetLockTools(bool lockTools_);
    void SetLockTime(bool lockTime_);
    void SetViewExtentsType(int viewExtentsType_);
    void SetViewDimension(int viewDimension_);
    void SetViewKeyframes(const intVector &viewKeyframes_);
    void SetCameraViewMode(bool cameraViewMode_);
    void SetUsingScalableRendering(bool usingScalableRendering_);
    void SetLastRenderMin(float lastRenderMin_);
    void SetLastRenderAvg(float lastRenderAvg_);
    void SetLastRenderMax(float lastRenderMax_);
    void SetNumTriangles(int numTriangles_);
    void SetExtents(const double *extents_);

    // Property getting methods
    const std::string  &GetActiveSource() const;
          std::string  &GetActiveSource();
    int                GetActiveTimeSlider() const;
    const stringVector &GetTimeSliders() const;
          stringVector &GetTimeSliders();
    const intVector    &GetTimeSliderCurrentStates() const;
          intVector    &GetTimeSliderCurrentStates();
    int                GetAnimationMode() const;
    int                GetWindowMode() const;
    bool               GetBoundingBoxNavigate() const;
    bool               GetSpin() const;
    bool               GetFullFrame() const;
    bool               GetPerspective() const;
    bool               GetLockView() const;
    bool               GetLockTools() const;
    bool               GetLockTime() const;
    int                GetViewExtentsType() const;
    int                GetViewDimension() const;
    const intVector    &GetViewKeyframes() const;
          intVector    &GetViewKeyframes();
    bool               GetCameraViewMode() const;
    bool               GetUsingScalableRendering() const;
    float              GetLastRenderMin() const;
    float              GetLastRenderAvg() const;
    float              GetLastRenderMax() const;
    int                GetNumTriangles() const;
    const double       *GetExtents() const;
          double       *GetExtents();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    std::string  activeSource;
    int          activeTimeSlider;
    stringVector timeSliders;
    intVector    timeSliderCurrentStates;
    int          animationMode;
    int          windowMode;
    bool         boundingBoxNavigate;
    bool         spin;
    bool         fullFrame;
    bool         perspective;
    bool         lockView;
    bool         lockTools;
    bool         lockTime;
    int          viewExtentsType;
    int          viewDimension;
    intVector    viewKeyframes;
    bool         cameraViewMode;
    bool         usingScalableRendering;
    float        lastRenderMin;
    float        lastRenderAvg;
    float        lastRenderMax;
    int          numTriangles;
    double       extents[6];
};

#endif
