#include <WindowInformation.h>
#include <DataNode.h>

// ****************************************************************************
// Method: WindowInformation::WindowInformation
//
// Purpose: 
//   Constructor for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

WindowInformation::WindowInformation() : AttributeSubject("sis*i*iibbbbbbbiii*bbfffiD")
{
    activeTimeSlider = -1;
    animationMode = 2;
    windowMode = 0;
    boundingBoxNavigate = true;
    spin = false;
    fullFrame = false;
    perspective = true;
    lockView = false;
    lockTools = false;
    lockTime = false;
    viewExtentsType = 0;
    viewDimension = 2;
    cameraViewMode = false;
    usingScalableRendering = false;
    lastRenderMin = 0;
    lastRenderAvg = 0;
    lastRenderMax = 0;
    numTriangles = 0;
    extents[0] = 0;
    extents[1] = 0;
    extents[2] = 0;
    extents[3] = 0;
    extents[4] = 0;
    extents[5] = 0;
}

// ****************************************************************************
// Method: WindowInformation::WindowInformation
//
// Purpose: 
//   Copy constructor for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

WindowInformation::WindowInformation(const WindowInformation &obj) : AttributeSubject("sis*i*iibbbbbbbiii*bbfffiD")
{
    int i;

    activeSource = obj.activeSource;
    activeTimeSlider = obj.activeTimeSlider;
    timeSliders = obj.timeSliders;
    timeSliderCurrentStates = obj.timeSliderCurrentStates;
    animationMode = obj.animationMode;
    windowMode = obj.windowMode;
    boundingBoxNavigate = obj.boundingBoxNavigate;
    spin = obj.spin;
    fullFrame = obj.fullFrame;
    perspective = obj.perspective;
    lockView = obj.lockView;
    lockTools = obj.lockTools;
    lockTime = obj.lockTime;
    viewExtentsType = obj.viewExtentsType;
    viewDimension = obj.viewDimension;
    viewKeyframes = obj.viewKeyframes;
    cameraViewMode = obj.cameraViewMode;
    usingScalableRendering = obj.usingScalableRendering;
    lastRenderMin = obj.lastRenderMin;
    lastRenderAvg = obj.lastRenderAvg;
    lastRenderMax = obj.lastRenderMax;
    numTriangles = obj.numTriangles;
    for(i = 0; i < 6; ++i)
        extents[i] = obj.extents[i];


    SelectAll();
}

// ****************************************************************************
// Method: WindowInformation::~WindowInformation
//
// Purpose: 
//   Destructor for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

WindowInformation::~WindowInformation()
{
    // nothing here
}

// ****************************************************************************
// Method: WindowInformation::operator = 
//
// Purpose: 
//   Assignment operator for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
WindowInformation::operator = (const WindowInformation &obj)
{
    int i;

    activeSource = obj.activeSource;
    activeTimeSlider = obj.activeTimeSlider;
    timeSliders = obj.timeSliders;
    timeSliderCurrentStates = obj.timeSliderCurrentStates;
    animationMode = obj.animationMode;
    windowMode = obj.windowMode;
    boundingBoxNavigate = obj.boundingBoxNavigate;
    spin = obj.spin;
    fullFrame = obj.fullFrame;
    perspective = obj.perspective;
    lockView = obj.lockView;
    lockTools = obj.lockTools;
    lockTime = obj.lockTime;
    viewExtentsType = obj.viewExtentsType;
    viewDimension = obj.viewDimension;
    viewKeyframes = obj.viewKeyframes;
    cameraViewMode = obj.cameraViewMode;
    usingScalableRendering = obj.usingScalableRendering;
    lastRenderMin = obj.lastRenderMin;
    lastRenderAvg = obj.lastRenderAvg;
    lastRenderMax = obj.lastRenderMax;
    numTriangles = obj.numTriangles;
    for(i = 0; i < 6; ++i)
        extents[i] = obj.extents[i];


    SelectAll();
}

// ****************************************************************************
// Method: WindowInformation::operator == 
//
// Purpose: 
//   Comparison operator == for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
WindowInformation::operator == (const WindowInformation &obj) const
{
    int i;

    // Compare the extents arrays.
    bool extents_equal = true;
    for(i = 0; i < 6 && extents_equal; ++i)
        extents_equal = (extents[i] == obj.extents[i]);

    // Create the return value
    return ((activeSource == obj.activeSource) &&
            (activeTimeSlider == obj.activeTimeSlider) &&
            (timeSliders == obj.timeSliders) &&
            (timeSliderCurrentStates == obj.timeSliderCurrentStates) &&
            (animationMode == obj.animationMode) &&
            (windowMode == obj.windowMode) &&
            (boundingBoxNavigate == obj.boundingBoxNavigate) &&
            (spin == obj.spin) &&
            (fullFrame == obj.fullFrame) &&
            (perspective == obj.perspective) &&
            (lockView == obj.lockView) &&
            (lockTools == obj.lockTools) &&
            (lockTime == obj.lockTime) &&
            (viewExtentsType == obj.viewExtentsType) &&
            (viewDimension == obj.viewDimension) &&
            (viewKeyframes == obj.viewKeyframes) &&
            (cameraViewMode == obj.cameraViewMode) &&
            (usingScalableRendering == obj.usingScalableRendering) &&
            (lastRenderMin == obj.lastRenderMin) &&
            (lastRenderAvg == obj.lastRenderAvg) &&
            (lastRenderMax == obj.lastRenderMax) &&
            (numTriangles == obj.numTriangles) &&
            extents_equal);
}

// ****************************************************************************
// Method: WindowInformation::operator != 
//
// Purpose: 
//   Comparison operator != for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
WindowInformation::operator != (const WindowInformation &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: WindowInformation::TypeName
//
// Purpose: 
//   Type name method for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
WindowInformation::TypeName() const
{
    return "WindowInformation";
}

// ****************************************************************************
// Method: WindowInformation::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
WindowInformation::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const WindowInformation *tmp = (const WindowInformation *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: WindowInformation::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
WindowInformation::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new WindowInformation(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: WindowInformation::NewInstance
//
// Purpose: 
//   NewInstance method for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
WindowInformation::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new WindowInformation(*this);
    else
        retval = new WindowInformation;

    return retval;
}

// ****************************************************************************
// Method: WindowInformation::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
WindowInformation::SelectAll()
{
    Select(0, (void *)&activeSource);
    Select(1, (void *)&activeTimeSlider);
    Select(2, (void *)&timeSliders);
    Select(3, (void *)&timeSliderCurrentStates);
    Select(4, (void *)&animationMode);
    Select(5, (void *)&windowMode);
    Select(6, (void *)&boundingBoxNavigate);
    Select(7, (void *)&spin);
    Select(8, (void *)&fullFrame);
    Select(9, (void *)&perspective);
    Select(10, (void *)&lockView);
    Select(11, (void *)&lockTools);
    Select(12, (void *)&lockTime);
    Select(13, (void *)&viewExtentsType);
    Select(14, (void *)&viewDimension);
    Select(15, (void *)&viewKeyframes);
    Select(16, (void *)&cameraViewMode);
    Select(17, (void *)&usingScalableRendering);
    Select(18, (void *)&lastRenderMin);
    Select(19, (void *)&lastRenderAvg);
    Select(20, (void *)&lastRenderMax);
    Select(21, (void *)&numTriangles);
    Select(22, (void *)extents, 6);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: WindowInformation::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Sep 16 14:03:15 PST 2002
//
// Modifications:
//   Brad Whitlock, Tue Nov 12 14:53:00 PST 2002
//   I added lockTools and lockTime.
//
//   Eric Brugger, Fri Apr 18 10:42:07 PDT 2003
//   I removed autoCenterView.
//
//   Brad Whitlock, Tue May 20 10:27:57 PDT 2003
//   I made it save only the fields that differ from the defaults. Added
//   fullFrame.
//
//   Brad Whitlock, Wed Dec 17 12:07:27 PDT 2003
//   I added a completeSave argument.
//
//   Brad Whitlock, Fri Jan 23 16:21:10 PST 2004
//   I changed the attribute numbering.
//
// ****************************************************************************

bool
WindowInformation::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    bool              addToParent = false;
    WindowInformation defaultObject;

    // Create a node for WindowInformation.
    DataNode *node = new DataNode("WindowInformation");

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("boundingBoxNavigate", boundingBoxNavigate));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fullFrame", fullFrame));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("perspective", perspective));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lockView", lockView));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lockTools", lockTools));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lockTime", lockTime));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewExtentsType", viewExtentsType));
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}
// ****************************************************************************
// Method: WindowInformation::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Sep 16 14:03:15 PST 2002
//
// Modifications:
//   Brad Whitlock, Tue Nov 12 14:53:00 PST 2002
//   I added lockTools and lockTime.
//
//   Brad Whitlock, Wed May 21 07:30:04 PDT 2003
//   I added fullFrame.
//   
// ****************************************************************************

void
WindowInformation::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("WindowInformation");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("boundingBoxNavigate")) != 0)
        SetBoundingBoxNavigate(node->AsBool());
    if((node = searchNode->GetNode("perspective")) != 0)
        SetPerspective(node->AsBool());
    if((node = searchNode->GetNode("viewExtentsType")) != 0)
        SetViewExtentsType(node->AsInt());
    if((node = searchNode->GetNode("lockView")) != 0)
        SetLockView(node->AsInt());
    if((node = searchNode->GetNode("lockTime")) != 0)
        SetLockTime(node->AsInt());
    if((node = searchNode->GetNode("lockTools")) != 0)
        SetLockTools(node->AsInt());
    if((node = searchNode->GetNode("fullFrame")) != 0)
        SetFullFrame(node->AsBool());
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
WindowInformation::SetActiveSource(const std::string &activeSource_)
{
    activeSource = activeSource_;
    Select(0, (void *)&activeSource);
}

void
WindowInformation::SetActiveTimeSlider(int activeTimeSlider_)
{
    activeTimeSlider = activeTimeSlider_;
    Select(1, (void *)&activeTimeSlider);
}

void
WindowInformation::SetTimeSliders(const stringVector &timeSliders_)
{
    timeSliders = timeSliders_;
    Select(2, (void *)&timeSliders);
}

void
WindowInformation::SetTimeSliderCurrentStates(const intVector &timeSliderCurrentStates_)
{
    timeSliderCurrentStates = timeSliderCurrentStates_;
    Select(3, (void *)&timeSliderCurrentStates);
}

void
WindowInformation::SetAnimationMode(int animationMode_)
{
    animationMode = animationMode_;
    Select(4, (void *)&animationMode);
}

void
WindowInformation::SetWindowMode(int windowMode_)
{
    windowMode = windowMode_;
    Select(5, (void *)&windowMode);
}

void
WindowInformation::SetBoundingBoxNavigate(bool boundingBoxNavigate_)
{
    boundingBoxNavigate = boundingBoxNavigate_;
    Select(6, (void *)&boundingBoxNavigate);
}

void
WindowInformation::SetSpin(bool spin_)
{
    spin = spin_;
    Select(7, (void *)&spin);
}

void
WindowInformation::SetFullFrame(bool fullFrame_)
{
    fullFrame = fullFrame_;
    Select(8, (void *)&fullFrame);
}

void
WindowInformation::SetPerspective(bool perspective_)
{
    perspective = perspective_;
    Select(9, (void *)&perspective);
}

void
WindowInformation::SetLockView(bool lockView_)
{
    lockView = lockView_;
    Select(10, (void *)&lockView);
}

void
WindowInformation::SetLockTools(bool lockTools_)
{
    lockTools = lockTools_;
    Select(11, (void *)&lockTools);
}

void
WindowInformation::SetLockTime(bool lockTime_)
{
    lockTime = lockTime_;
    Select(12, (void *)&lockTime);
}

void
WindowInformation::SetViewExtentsType(int viewExtentsType_)
{
    viewExtentsType = viewExtentsType_;
    Select(13, (void *)&viewExtentsType);
}

void
WindowInformation::SetViewDimension(int viewDimension_)
{
    viewDimension = viewDimension_;
    Select(14, (void *)&viewDimension);
}

void
WindowInformation::SetViewKeyframes(const intVector &viewKeyframes_)
{
    viewKeyframes = viewKeyframes_;
    Select(15, (void *)&viewKeyframes);
}

void
WindowInformation::SetCameraViewMode(bool cameraViewMode_)
{
    cameraViewMode = cameraViewMode_;
    Select(16, (void *)&cameraViewMode);
}

void
WindowInformation::SetUsingScalableRendering(bool usingScalableRendering_)
{
    usingScalableRendering = usingScalableRendering_;
    Select(17, (void *)&usingScalableRendering);
}

void
WindowInformation::SetLastRenderMin(float lastRenderMin_)
{
    lastRenderMin = lastRenderMin_;
    Select(18, (void *)&lastRenderMin);
}

void
WindowInformation::SetLastRenderAvg(float lastRenderAvg_)
{
    lastRenderAvg = lastRenderAvg_;
    Select(19, (void *)&lastRenderAvg);
}

void
WindowInformation::SetLastRenderMax(float lastRenderMax_)
{
    lastRenderMax = lastRenderMax_;
    Select(20, (void *)&lastRenderMax);
}

void
WindowInformation::SetNumTriangles(int numTriangles_)
{
    numTriangles = numTriangles_;
    Select(21, (void *)&numTriangles);
}

void
WindowInformation::SetExtents(const double *extents_)
{
    for(int i = 0; i < 6; ++i)
        extents[i] = extents_[i];
    Select(22, (void *)extents, 6);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
WindowInformation::GetActiveSource() const
{
    return activeSource;
}

std::string &
WindowInformation::GetActiveSource()
{
    return activeSource;
}

int
WindowInformation::GetActiveTimeSlider() const
{
    return activeTimeSlider;
}

const stringVector &
WindowInformation::GetTimeSliders() const
{
    return timeSliders;
}

stringVector &
WindowInformation::GetTimeSliders()
{
    return timeSliders;
}

const intVector &
WindowInformation::GetTimeSliderCurrentStates() const
{
    return timeSliderCurrentStates;
}

intVector &
WindowInformation::GetTimeSliderCurrentStates()
{
    return timeSliderCurrentStates;
}

int
WindowInformation::GetAnimationMode() const
{
    return animationMode;
}

int
WindowInformation::GetWindowMode() const
{
    return windowMode;
}

bool
WindowInformation::GetBoundingBoxNavigate() const
{
    return boundingBoxNavigate;
}

bool
WindowInformation::GetSpin() const
{
    return spin;
}

bool
WindowInformation::GetFullFrame() const
{
    return fullFrame;
}

bool
WindowInformation::GetPerspective() const
{
    return perspective;
}

bool
WindowInformation::GetLockView() const
{
    return lockView;
}

bool
WindowInformation::GetLockTools() const
{
    return lockTools;
}

bool
WindowInformation::GetLockTime() const
{
    return lockTime;
}

int
WindowInformation::GetViewExtentsType() const
{
    return viewExtentsType;
}

int
WindowInformation::GetViewDimension() const
{
    return viewDimension;
}

const intVector &
WindowInformation::GetViewKeyframes() const
{
    return viewKeyframes;
}

intVector &
WindowInformation::GetViewKeyframes()
{
    return viewKeyframes;
}

bool
WindowInformation::GetCameraViewMode() const
{
    return cameraViewMode;
}

bool
WindowInformation::GetUsingScalableRendering() const
{
    return usingScalableRendering;
}

float
WindowInformation::GetLastRenderMin() const
{
    return lastRenderMin;
}

float
WindowInformation::GetLastRenderAvg() const
{
    return lastRenderAvg;
}

float
WindowInformation::GetLastRenderMax() const
{
    return lastRenderMax;
}

int
WindowInformation::GetNumTriangles() const
{
    return numTriangles;
}

const double *
WindowInformation::GetExtents() const
{
    return extents;
}

double *
WindowInformation::GetExtents()
{
    return extents;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
WindowInformation::SelectActiveSource()
{
    Select(0, (void *)&activeSource);
}

void
WindowInformation::SelectTimeSliders()
{
    Select(2, (void *)&timeSliders);
}

void
WindowInformation::SelectTimeSliderCurrentStates()
{
    Select(3, (void *)&timeSliderCurrentStates);
}

void
WindowInformation::SelectViewKeyframes()
{
    Select(15, (void *)&viewKeyframes);
}

void
WindowInformation::SelectExtents()
{
    Select(22, (void *)extents, 6);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: WindowInformation::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
WindowInformation::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Active source";
        case 1:  return "Active time slider";
        case 2:  return "Time sliders";
        case 3:  return "Time for each time slider";
        case 4:  return "Animation mode";
        case 5:  return "windowMode";
        case 6:  return "boundingBoxNavigate";
        case 7:  return "spin";
        case 8:  return "fullFrame";
        case 9:  return "perspective";
        case 10:  return "lockView";
        case 11:  return "lockTools";
        case 12:  return "lockTime";
        case 13:  return "viewExtentsType";
        case 14:  return "viewDimension";
        case 15:  return "View keyframes";
        case 16:  return "cameraViewMode";
        case 17:  return "usingScalableRendering";
        case 18:  return "lastRenderMin";
        case 19:  return "lastRenderAvg";
        case 20:  return "lastRenderMax";
        case 21:  return "numTriangles";
        case 22:  return "extents";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: WindowInformation::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
WindowInformation::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_string;
        case 1:  return FieldType_int;
        case 2:  return FieldType_stringVector;
        case 3:  return FieldType_intVector;
        case 4:  return FieldType_int;
        case 5:  return FieldType_int;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_bool;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_bool;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_bool;
        case 13:  return FieldType_int;
        case 14:  return FieldType_int;
        case 15:  return FieldType_intVector;
        case 16:  return FieldType_bool;
        case 17:  return FieldType_bool;
        case 18:  return FieldType_float;
        case 19:  return FieldType_float;
        case 20:  return FieldType_float;
        case 21:  return FieldType_int;
        case 22:  return FieldType_doubleArray;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: WindowInformation::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
WindowInformation::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "string";
        case 1:  return "int";
        case 2:  return "stringVector";
        case 3:  return "intVector";
        case 4:  return "int";
        case 5:  return "int";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "bool";
        case 9:  return "bool";
        case 10:  return "bool";
        case 11:  return "bool";
        case 12:  return "bool";
        case 13:  return "int";
        case 14:  return "int";
        case 15:  return "intVector";
        case 16:  return "bool";
        case 17:  return "bool";
        case 18:  return "float";
        case 19:  return "float";
        case 20:  return "float";
        case 21:  return "int";
        case 22:  return "doubleArray";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: WindowInformation::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Jan 23 16:22:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
WindowInformation::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const WindowInformation &obj = *((const WindowInformation*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (activeSource == obj.activeSource);
        }
        break;
    case 1:
        {  // new scope
        retval = (activeTimeSlider == obj.activeTimeSlider);
        }
        break;
    case 2:
        {  // new scope
        retval = (timeSliders == obj.timeSliders);
        }
        break;
    case 3:
        {  // new scope
        retval = (timeSliderCurrentStates == obj.timeSliderCurrentStates);
        }
        break;
    case 4:
        {  // new scope
        retval = (animationMode == obj.animationMode);
        }
        break;
    case 5:
        {  // new scope
        retval = (windowMode == obj.windowMode);
        }
        break;
    case 6:
        {  // new scope
        retval = (boundingBoxNavigate == obj.boundingBoxNavigate);
        }
        break;
    case 7:
        {  // new scope
        retval = (spin == obj.spin);
        }
        break;
    case 8:
        {  // new scope
        retval = (fullFrame == obj.fullFrame);
        }
        break;
    case 9:
        {  // new scope
        retval = (perspective == obj.perspective);
        }
        break;
    case 10:
        {  // new scope
        retval = (lockView == obj.lockView);
        }
        break;
    case 11:
        {  // new scope
        retval = (lockTools == obj.lockTools);
        }
        break;
    case 12:
        {  // new scope
        retval = (lockTime == obj.lockTime);
        }
        break;
    case 13:
        {  // new scope
        retval = (viewExtentsType == obj.viewExtentsType);
        }
        break;
    case 14:
        {  // new scope
        retval = (viewDimension == obj.viewDimension);
        }
        break;
    case 15:
        {  // new scope
        retval = (viewKeyframes == obj.viewKeyframes);
        }
        break;
    case 16:
        {  // new scope
        retval = (cameraViewMode == obj.cameraViewMode);
        }
        break;
    case 17:
        {  // new scope
        retval = (usingScalableRendering == obj.usingScalableRendering);
        }
        break;
    case 18:
        {  // new scope
        retval = (lastRenderMin == obj.lastRenderMin);
        }
        break;
    case 19:
        {  // new scope
        retval = (lastRenderAvg == obj.lastRenderAvg);
        }
        break;
    case 20:
        {  // new scope
        retval = (lastRenderMax == obj.lastRenderMax);
        }
        break;
    case 21:
        {  // new scope
        retval = (numTriangles == obj.numTriangles);
        }
        break;
    case 22:
        {  // new scope
        // Compare the extents arrays.
        bool extents_equal = true;
        for(i = 0; i < 6 && extents_equal; ++i)
            extents_equal = (extents[i] == obj.extents[i]);

        retval = extents_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

