#include <WindowAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: WindowAttributes::WindowAttributes
//
// Purpose: 
//   Constructor for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes::WindowAttributes() : AttributeSubject("aaaaaaIUUiFF")
{
    size[0] = 300;
    size[1] = 300;
    background[0] = 255;
    background[1] = 255;
    background[2] = 255;
    foreground[0] = 0;
    foreground[1] = 0;
    foreground[2] = 0;
    backgroundMode = 0;
    gradBG1[0] = 0;
    gradBG1[1] = 0;
    gradBG1[2] = 1;
    gradBG2[0] = 0;
    gradBG2[1] = 0;
    gradBG2[2] = 0;
}

// ****************************************************************************
// Method: WindowAttributes::WindowAttributes
//
// Purpose: 
//   Copy constructor for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes::WindowAttributes(const WindowAttributes &obj) : AttributeSubject("aaaaaaIUUiFF")
{
    viewCurve = obj.viewCurve;
    view2D = obj.view2D;
    view3D = obj.view3D;
    lights = obj.lights;
    renderAtts = obj.renderAtts;
    colorTables = obj.colorTables;
    size[0] = obj.size[0];
    size[1] = obj.size[1];

    background[0] = obj.background[0];
    background[1] = obj.background[1];
    background[2] = obj.background[2];

    foreground[0] = obj.foreground[0];
    foreground[1] = obj.foreground[1];
    foreground[2] = obj.foreground[2];

    backgroundMode = obj.backgroundMode;
    gradBG1[0] = obj.gradBG1[0];
    gradBG1[1] = obj.gradBG1[1];
    gradBG1[2] = obj.gradBG1[2];

    gradBG2[0] = obj.gradBG2[0];
    gradBG2[1] = obj.gradBG2[1];
    gradBG2[2] = obj.gradBG2[2];


    SelectAll();
}

// ****************************************************************************
// Method: WindowAttributes::~WindowAttributes
//
// Purpose: 
//   Destructor for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes::~WindowAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: WindowAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
WindowAttributes::operator = (const WindowAttributes &obj)
{
    viewCurve = obj.viewCurve;
    view2D = obj.view2D;
    view3D = obj.view3D;
    lights = obj.lights;
    renderAtts = obj.renderAtts;
    colorTables = obj.colorTables;
    size[0] = obj.size[0];
    size[1] = obj.size[1];

    background[0] = obj.background[0];
    background[1] = obj.background[1];
    background[2] = obj.background[2];

    foreground[0] = obj.foreground[0];
    foreground[1] = obj.foreground[1];
    foreground[2] = obj.foreground[2];

    backgroundMode = obj.backgroundMode;
    gradBG1[0] = obj.gradBG1[0];
    gradBG1[1] = obj.gradBG1[1];
    gradBG1[2] = obj.gradBG1[2];

    gradBG2[0] = obj.gradBG2[0];
    gradBG2[1] = obj.gradBG2[1];
    gradBG2[2] = obj.gradBG2[2];


    SelectAll();
}

// ****************************************************************************
// Method: WindowAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::operator == (const WindowAttributes &obj) const
{
    int i;

    // Compare the size arrays.
    bool size_equal = true;
    for(i = 0; i < 2 && size_equal; ++i)
        size_equal = (size[i] == obj.size[i]);

    // Compare the background arrays.
    bool background_equal = true;
    for(i = 0; i < 3 && background_equal; ++i)
        background_equal = (background[i] == obj.background[i]);

    // Compare the foreground arrays.
    bool foreground_equal = true;
    for(i = 0; i < 3 && foreground_equal; ++i)
        foreground_equal = (foreground[i] == obj.foreground[i]);

    // Compare the gradBG1 arrays.
    bool gradBG1_equal = true;
    for(i = 0; i < 3 && gradBG1_equal; ++i)
        gradBG1_equal = (gradBG1[i] == obj.gradBG1[i]);

    // Compare the gradBG2 arrays.
    bool gradBG2_equal = true;
    for(i = 0; i < 3 && gradBG2_equal; ++i)
        gradBG2_equal = (gradBG2[i] == obj.gradBG2[i]);

    // Create the return value
    return ((viewCurve == obj.viewCurve) &&
            (view2D == obj.view2D) &&
            (view3D == obj.view3D) &&
            (lights == obj.lights) &&
            (renderAtts == obj.renderAtts) &&
            (colorTables == obj.colorTables) &&
            size_equal &&
            background_equal &&
            foreground_equal &&
            (backgroundMode == obj.backgroundMode) &&
            gradBG1_equal &&
            gradBG2_equal);
}

// ****************************************************************************
// Method: WindowAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::operator != (const WindowAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: WindowAttributes::TypeName
//
// Purpose: 
//   Type name method for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
WindowAttributes::TypeName() const
{
    return "WindowAttributes";
}

// ****************************************************************************
// Method: WindowAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const WindowAttributes *tmp = (const WindowAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: WindowAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
WindowAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new WindowAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: WindowAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
WindowAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new WindowAttributes(*this);
    else
        retval = new WindowAttributes;

    return retval;
}

// ****************************************************************************
// Method: WindowAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
WindowAttributes::SelectAll()
{
    Select(0, (void *)&viewCurve);
    Select(1, (void *)&view2D);
    Select(2, (void *)&view3D);
    Select(3, (void *)&lights);
    Select(4, (void *)&renderAtts);
    Select(5, (void *)&colorTables);
    Select(6, (void *)size, 2);
    Select(7, (void *)background, 3);
    Select(8, (void *)foreground, 3);
    Select(9, (void *)&backgroundMode);
    Select(10, (void *)gradBG1, 3);
    Select(11, (void *)gradBG2, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: WindowAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    WindowAttributes defaultObject;
    bool addToParent = false;
    // Create a node for WindowAttributes.
    DataNode *node = new DataNode("WindowAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        DataNode *viewCurveNode = new DataNode("viewCurve");
        if(viewCurve.CreateNode(viewCurveNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(viewCurveNode);
        }
        else
            delete viewCurveNode;
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        DataNode *view2DNode = new DataNode("view2D");
        if(view2D.CreateNode(view2DNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(view2DNode);
        }
        else
            delete view2DNode;
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        DataNode *view3DNode = new DataNode("view3D");
        if(view3D.CreateNode(view3DNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(view3DNode);
        }
        else
            delete view3DNode;
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        DataNode *lightsNode = new DataNode("lights");
        if(lights.CreateNode(lightsNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(lightsNode);
        }
        else
            delete lightsNode;
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        DataNode *renderAttsNode = new DataNode("renderAtts");
        if(renderAtts.CreateNode(renderAttsNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(renderAttsNode);
        }
        else
            delete renderAttsNode;
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        DataNode *colorTablesNode = new DataNode("colorTables");
        if(colorTables.CreateNode(colorTablesNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(colorTablesNode);
        }
        else
            delete colorTablesNode;
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("size", size, 2));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("background", background, 3));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("foreground", foreground, 3));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("backgroundMode", backgroundMode));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("gradBG1", gradBG1, 3));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("gradBG2", gradBG2, 3));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: WindowAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
WindowAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("WindowAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("viewCurve")) != 0)
        viewCurve.SetFromNode(node);
    if((node = searchNode->GetNode("view2D")) != 0)
        view2D.SetFromNode(node);
    if((node = searchNode->GetNode("view3D")) != 0)
        view3D.SetFromNode(node);
    if((node = searchNode->GetNode("lights")) != 0)
        lights.SetFromNode(node);
    if((node = searchNode->GetNode("renderAtts")) != 0)
        renderAtts.SetFromNode(node);
    if((node = searchNode->GetNode("colorTables")) != 0)
        colorTables.SetFromNode(node);
    if((node = searchNode->GetNode("size")) != 0)
        SetSize(node->AsIntArray());
    if((node = searchNode->GetNode("background")) != 0)
        SetBackground(node->AsUnsignedCharArray());
    if((node = searchNode->GetNode("foreground")) != 0)
        SetForeground(node->AsUnsignedCharArray());
    if((node = searchNode->GetNode("backgroundMode")) != 0)
        SetBackgroundMode(node->AsInt());
    if((node = searchNode->GetNode("gradBG1")) != 0)
        SetGradBG1(node->AsFloatArray());
    if((node = searchNode->GetNode("gradBG2")) != 0)
        SetGradBG2(node->AsFloatArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
WindowAttributes::SetViewCurve(const ViewCurveAttributes &viewCurve_)
{
    viewCurve = viewCurve_;
    Select(0, (void *)&viewCurve);
}

void
WindowAttributes::SetView2D(const View2DAttributes &view2D_)
{
    view2D = view2D_;
    Select(1, (void *)&view2D);
}

void
WindowAttributes::SetView3D(const View3DAttributes &view3D_)
{
    view3D = view3D_;
    Select(2, (void *)&view3D);
}

void
WindowAttributes::SetLights(const LightList &lights_)
{
    lights = lights_;
    Select(3, (void *)&lights);
}

void
WindowAttributes::SetRenderAtts(const RenderingAttributes &renderAtts_)
{
    renderAtts = renderAtts_;
    Select(4, (void *)&renderAtts);
}

void
WindowAttributes::SetColorTables(const ColorTableAttributes &colorTables_)
{
    colorTables = colorTables_;
    Select(5, (void *)&colorTables);
}

void
WindowAttributes::SetSize(const int *size_)
{
    size[0] = size_[0];
    size[1] = size_[1];
    Select(6, (void *)size, 2);
}

void
WindowAttributes::SetBackground(const unsigned char *background_)
{
    background[0] = background_[0];
    background[1] = background_[1];
    background[2] = background_[2];
    Select(7, (void *)background, 3);
}

void
WindowAttributes::SetForeground(const unsigned char *foreground_)
{
    foreground[0] = foreground_[0];
    foreground[1] = foreground_[1];
    foreground[2] = foreground_[2];
    Select(8, (void *)foreground, 3);
}

void
WindowAttributes::SetBackgroundMode(int backgroundMode_)
{
    backgroundMode = backgroundMode_;
    Select(9, (void *)&backgroundMode);
}

void
WindowAttributes::SetGradBG1(const float *gradBG1_)
{
    gradBG1[0] = gradBG1_[0];
    gradBG1[1] = gradBG1_[1];
    gradBG1[2] = gradBG1_[2];
    Select(10, (void *)gradBG1, 3);
}

void
WindowAttributes::SetGradBG2(const float *gradBG2_)
{
    gradBG2[0] = gradBG2_[0];
    gradBG2[1] = gradBG2_[1];
    gradBG2[2] = gradBG2_[2];
    Select(11, (void *)gradBG2, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const ViewCurveAttributes &
WindowAttributes::GetViewCurve() const
{
    return viewCurve;
}

ViewCurveAttributes &
WindowAttributes::GetViewCurve()
{
    return viewCurve;
}

const View2DAttributes &
WindowAttributes::GetView2D() const
{
    return view2D;
}

View2DAttributes &
WindowAttributes::GetView2D()
{
    return view2D;
}

const View3DAttributes &
WindowAttributes::GetView3D() const
{
    return view3D;
}

View3DAttributes &
WindowAttributes::GetView3D()
{
    return view3D;
}

const LightList &
WindowAttributes::GetLights() const
{
    return lights;
}

LightList &
WindowAttributes::GetLights()
{
    return lights;
}

const RenderingAttributes &
WindowAttributes::GetRenderAtts() const
{
    return renderAtts;
}

RenderingAttributes &
WindowAttributes::GetRenderAtts()
{
    return renderAtts;
}

const ColorTableAttributes &
WindowAttributes::GetColorTables() const
{
    return colorTables;
}

ColorTableAttributes &
WindowAttributes::GetColorTables()
{
    return colorTables;
}

const int *
WindowAttributes::GetSize() const
{
    return size;
}

int *
WindowAttributes::GetSize()
{
    return size;
}

const unsigned char *
WindowAttributes::GetBackground() const
{
    return background;
}

unsigned char *
WindowAttributes::GetBackground()
{
    return background;
}

const unsigned char *
WindowAttributes::GetForeground() const
{
    return foreground;
}

unsigned char *
WindowAttributes::GetForeground()
{
    return foreground;
}

int
WindowAttributes::GetBackgroundMode() const
{
    return backgroundMode;
}

const float *
WindowAttributes::GetGradBG1() const
{
    return gradBG1;
}

float *
WindowAttributes::GetGradBG1()
{
    return gradBG1;
}

const float *
WindowAttributes::GetGradBG2() const
{
    return gradBG2;
}

float *
WindowAttributes::GetGradBG2()
{
    return gradBG2;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
WindowAttributes::SelectViewCurve()
{
    Select(0, (void *)&viewCurve);
}

void
WindowAttributes::SelectView2D()
{
    Select(1, (void *)&view2D);
}

void
WindowAttributes::SelectView3D()
{
    Select(2, (void *)&view3D);
}

void
WindowAttributes::SelectLights()
{
    Select(3, (void *)&lights);
}

void
WindowAttributes::SelectRenderAtts()
{
    Select(4, (void *)&renderAtts);
}

void
WindowAttributes::SelectColorTables()
{
    Select(5, (void *)&colorTables);
}

void
WindowAttributes::SelectSize()
{
    Select(6, (void *)size, 2);
}

void
WindowAttributes::SelectBackground()
{
    Select(7, (void *)background, 3);
}

void
WindowAttributes::SelectForeground()
{
    Select(8, (void *)foreground, 3);
}

void
WindowAttributes::SelectGradBG1()
{
    Select(10, (void *)gradBG1, 3);
}

void
WindowAttributes::SelectGradBG2()
{
    Select(11, (void *)gradBG2, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: WindowAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
WindowAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "viewCurve";
        case 1:  return "view2D";
        case 2:  return "view3D";
        case 3:  return "lights";
        case 4:  return "renderAtts";
        case 5:  return "colorTables";
        case 6:  return "size";
        case 7:  return "background";
        case 8:  return "foreground";
        case 9:  return "backgroundMode";
        case 10:  return "gradBG1";
        case 11:  return "gradBG2";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: WindowAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
WindowAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_att;
        case 1:  return FieldType_att;
        case 2:  return FieldType_att;
        case 3:  return FieldType_att;
        case 4:  return FieldType_att;
        case 5:  return FieldType_att;
        case 6:  return FieldType_intArray;
        case 7:  return FieldType_ucharArray;
        case 8:  return FieldType_ucharArray;
        case 9:  return FieldType_int;
        case 10:  return FieldType_floatArray;
        case 11:  return FieldType_floatArray;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: WindowAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
WindowAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "att";
        case 1:  return "att";
        case 2:  return "att";
        case 3:  return "att";
        case 4:  return "att";
        case 5:  return "att";
        case 6:  return "intArray";
        case 7:  return "ucharArray";
        case 8:  return "ucharArray";
        case 9:  return "int";
        case 10:  return "floatArray";
        case 11:  return "floatArray";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: WindowAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const WindowAttributes &obj = *((const WindowAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (viewCurve == obj.viewCurve);
        }
        break;
    case 1:
        {  // new scope
        retval = (view2D == obj.view2D);
        }
        break;
    case 2:
        {  // new scope
        retval = (view3D == obj.view3D);
        }
        break;
    case 3:
        {  // new scope
        retval = (lights == obj.lights);
        }
        break;
    case 4:
        {  // new scope
        retval = (renderAtts == obj.renderAtts);
        }
        break;
    case 5:
        {  // new scope
        retval = (colorTables == obj.colorTables);
        }
        break;
    case 6:
        {  // new scope
        // Compare the size arrays.
        bool size_equal = true;
        for(i = 0; i < 2 && size_equal; ++i)
            size_equal = (size[i] == obj.size[i]);

        retval = size_equal;
        }
        break;
    case 7:
        {  // new scope
        // Compare the background arrays.
        bool background_equal = true;
        for(i = 0; i < 3 && background_equal; ++i)
            background_equal = (background[i] == obj.background[i]);

        retval = background_equal;
        }
        break;
    case 8:
        {  // new scope
        // Compare the foreground arrays.
        bool foreground_equal = true;
        for(i = 0; i < 3 && foreground_equal; ++i)
            foreground_equal = (foreground[i] == obj.foreground[i]);

        retval = foreground_equal;
        }
        break;
    case 9:
        {  // new scope
        retval = (backgroundMode == obj.backgroundMode);
        }
        break;
    case 10:
        {  // new scope
        // Compare the gradBG1 arrays.
        bool gradBG1_equal = true;
        for(i = 0; i < 3 && gradBG1_equal; ++i)
            gradBG1_equal = (gradBG1[i] == obj.gradBG1[i]);

        retval = gradBG1_equal;
        }
        break;
    case 11:
        {  // new scope
        // Compare the gradBG2 arrays.
        bool gradBG2_equal = true;
        for(i = 0; i < 3 && gradBG2_equal; ++i)
            gradBG2_equal = (gradBG2[i] == obj.gradBG2[i]);

        retval = gradBG2_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

