#ifndef VISUALCUEINFO_H
#define VISUALCUEINFO_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>
#include <ColorAttribute.h>
#include <PickAttributes.h>
#include <Line.h>

// ****************************************************************************
// Class: VisualCueInfo
//
// Purpose:
//    attributes necessary to describe a visual cue in a VisWindow (e.g. pick point or refline)
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

class STATE_API VisualCueInfo : public AttributeSubject
{
public:
    enum CueType
    {
        PickPoint,
        RefLine,
        Unknown
    };

    VisualCueInfo();
    VisualCueInfo(const VisualCueInfo &obj);
    virtual ~VisualCueInfo();

    virtual void operator = (const VisualCueInfo &obj);
    virtual bool operator == (const VisualCueInfo &obj) const;
    virtual bool operator != (const VisualCueInfo &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPoints();
    void SelectColor();
    void SelectGlyphType();
    void SelectLabel();

    // Property setting methods
    void SetPoints(const doubleVector &points_);
    void SetCueType(CueType cueType_);
    void SetColor(const ColorAttribute &color_);
    void SetGlyphType(const std::string &glyphType_);
    void SetLabel(const std::string &label_);
    void SetShowLabel(bool showLabel_);
    void SetLineStyle(int lineStyle_);
    void SetLineWidth(int lineWidth_);
    void SetOpacity(double opacity_);

    // Property getting methods
    const doubleVector   &GetPoints() const;
          doubleVector   &GetPoints();
    CueType              GetCueType() const;
    const ColorAttribute &GetColor() const;
          ColorAttribute &GetColor();
    const std::string    &GetGlyphType() const;
          std::string    &GetGlyphType();
    const std::string    &GetLabel() const;
          std::string    &GetLabel();
    bool                 GetShowLabel() const;
    int                  GetLineStyle() const;
    int                  GetLineWidth() const;
    double               GetOpacity() const;

    // Enum conversion functions
    static std::string CueType_ToString(CueType);
    static bool CueType_FromString(const std::string &, CueType &);
protected:
    static std::string CueType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void SetPointF(int i, const float *pt);
    bool GetPointF(int i, float *pt) const;
    void SetFromP(const PickAttributes *pa);
    void SetFromL(const Line *line);
    void SetPointD(int i, const double *pt);
    bool GetPointD(int i, double *pt) const;
private:
    doubleVector   points;
    int            cueType;
    ColorAttribute color;
    std::string    glyphType;
    std::string    label;
    bool           showLabel;
    int            lineStyle;
    int            lineWidth;
    double         opacity;
};

#endif
