#include <VisualCueInfo.h>
#include <DataNode.h>

//
// Enum conversion methods for VisualCueInfo::CueType
//

static const char *CueType_strings[] = {
"PickPoint", "RefLine", "Unknown"
};

std::string
VisualCueInfo::CueType_ToString(VisualCueInfo::CueType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return CueType_strings[index];
}

std::string
VisualCueInfo::CueType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return CueType_strings[index];
}

bool
VisualCueInfo::CueType_FromString(const std::string &s, VisualCueInfo::CueType &val)
{
    val = VisualCueInfo::PickPoint;
    for(int i = 0; i < 3; ++i)
    {
        if(s == CueType_strings[i])
        {
            val = (CueType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: VisualCueInfo::VisualCueInfo
//
// Purpose: 
//   Constructor for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

VisualCueInfo::VisualCueInfo() : AttributeSubject("d*iassbiid"),
    color(0, 0, 0)
{
    cueType = Unknown;
    showLabel = false;
    lineStyle = 0;
    lineWidth = 0;
    opacity = 1;
}

// ****************************************************************************
// Method: VisualCueInfo::VisualCueInfo
//
// Purpose: 
//   Copy constructor for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

VisualCueInfo::VisualCueInfo(const VisualCueInfo &obj) : AttributeSubject("d*iassbiid")
{
    points = obj.points;
    cueType = obj.cueType;
    color = obj.color;
    glyphType = obj.glyphType;
    label = obj.label;
    showLabel = obj.showLabel;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    opacity = obj.opacity;

    SelectAll();
}

// ****************************************************************************
// Method: VisualCueInfo::~VisualCueInfo
//
// Purpose: 
//   Destructor for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

VisualCueInfo::~VisualCueInfo()
{
    // nothing here
}

// ****************************************************************************
// Method: VisualCueInfo::operator = 
//
// Purpose: 
//   Assignment operator for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
VisualCueInfo::operator = (const VisualCueInfo &obj)
{
    points = obj.points;
    cueType = obj.cueType;
    color = obj.color;
    glyphType = obj.glyphType;
    label = obj.label;
    showLabel = obj.showLabel;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    opacity = obj.opacity;

    SelectAll();
}

// ****************************************************************************
// Method: VisualCueInfo::operator == 
//
// Purpose: 
//   Comparison operator == for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VisualCueInfo::operator == (const VisualCueInfo &obj) const
{
    // Create the return value
    return ((points == obj.points) &&
            (cueType == obj.cueType) &&
            (color == obj.color) &&
            (glyphType == obj.glyphType) &&
            (label == obj.label) &&
            (showLabel == obj.showLabel) &&
            (lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (opacity == obj.opacity));
}

// ****************************************************************************
// Method: VisualCueInfo::operator != 
//
// Purpose: 
//   Comparison operator != for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VisualCueInfo::operator != (const VisualCueInfo &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: VisualCueInfo::TypeName
//
// Purpose: 
//   Type name method for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
VisualCueInfo::TypeName() const
{
    return "VisualCueInfo";
}

// ****************************************************************************
// Method: VisualCueInfo::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VisualCueInfo::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const VisualCueInfo *tmp = (const VisualCueInfo *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: VisualCueInfo::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
VisualCueInfo::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new VisualCueInfo(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: VisualCueInfo::NewInstance
//
// Purpose: 
//   NewInstance method for the VisualCueInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
VisualCueInfo::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new VisualCueInfo(*this);
    else
        retval = new VisualCueInfo;

    return retval;
}

// ****************************************************************************
// Method: VisualCueInfo::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
VisualCueInfo::SelectAll()
{
    Select(0, (void *)&points);
    Select(1, (void *)&cueType);
    Select(2, (void *)&color);
    Select(3, (void *)&glyphType);
    Select(4, (void *)&label);
    Select(5, (void *)&showLabel);
    Select(6, (void *)&lineStyle);
    Select(7, (void *)&lineWidth);
    Select(8, (void *)&opacity);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
VisualCueInfo::SetPoints(const doubleVector &points_)
{
    points = points_;
    Select(0, (void *)&points);
}

void
VisualCueInfo::SetCueType(VisualCueInfo::CueType cueType_)
{
    cueType = cueType_;
    Select(1, (void *)&cueType);
}

void
VisualCueInfo::SetColor(const ColorAttribute &color_)
{
    color = color_;
    Select(2, (void *)&color);
}

void
VisualCueInfo::SetGlyphType(const std::string &glyphType_)
{
    glyphType = glyphType_;
    Select(3, (void *)&glyphType);
}

void
VisualCueInfo::SetLabel(const std::string &label_)
{
    label = label_;
    Select(4, (void *)&label);
}

void
VisualCueInfo::SetShowLabel(bool showLabel_)
{
    showLabel = showLabel_;
    Select(5, (void *)&showLabel);
}

void
VisualCueInfo::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(6, (void *)&lineStyle);
}

void
VisualCueInfo::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(7, (void *)&lineWidth);
}

void
VisualCueInfo::SetOpacity(double opacity_)
{
    opacity = opacity_;
    Select(8, (void *)&opacity);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const doubleVector &
VisualCueInfo::GetPoints() const
{
    return points;
}

doubleVector &
VisualCueInfo::GetPoints()
{
    return points;
}

VisualCueInfo::CueType
VisualCueInfo::GetCueType() const
{
    return CueType(cueType);
}

const ColorAttribute &
VisualCueInfo::GetColor() const
{
    return color;
}

ColorAttribute &
VisualCueInfo::GetColor()
{
    return color;
}

const std::string &
VisualCueInfo::GetGlyphType() const
{
    return glyphType;
}

std::string &
VisualCueInfo::GetGlyphType()
{
    return glyphType;
}

const std::string &
VisualCueInfo::GetLabel() const
{
    return label;
}

std::string &
VisualCueInfo::GetLabel()
{
    return label;
}

bool
VisualCueInfo::GetShowLabel() const
{
    return showLabel;
}

int
VisualCueInfo::GetLineStyle() const
{
    return lineStyle;
}

int
VisualCueInfo::GetLineWidth() const
{
    return lineWidth;
}

double
VisualCueInfo::GetOpacity() const
{
    return opacity;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
VisualCueInfo::SelectPoints()
{
    Select(0, (void *)&points);
}

void
VisualCueInfo::SelectColor()
{
    Select(2, (void *)&color);
}

void
VisualCueInfo::SelectGlyphType()
{
    Select(3, (void *)&glyphType);
}

void
VisualCueInfo::SelectLabel()
{
    Select(4, (void *)&label);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VisualCueInfo::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
VisualCueInfo::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "points";
        case 1:  return "cueType";
        case 2:  return "color";
        case 3:  return "glyphType";
        case 4:  return "label";
        case 5:  return "showLabel";
        case 6:  return "lineStyle";
        case 7:  return "lineWidth";
        case 8:  return "opacity";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: VisualCueInfo::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
VisualCueInfo::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_doubleVector;
        case 1:  return FieldType_enum;
        case 2:  return FieldType_color;
        case 3:  return FieldType_string;
        case 4:  return FieldType_string;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_linestyle;
        case 7:  return FieldType_linewidth;
        case 8:  return FieldType_opacity;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: VisualCueInfo::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
VisualCueInfo::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "doubleVector";
        case 1:  return "enum";
        case 2:  return "color";
        case 3:  return "string";
        case 4:  return "string";
        case 5:  return "bool";
        case 6:  return "linestyle";
        case 7:  return "linewidth";
        case 8:  return "opacity";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: VisualCueInfo::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jun 8 20:03:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VisualCueInfo::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const VisualCueInfo &obj = *((const VisualCueInfo*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (points == obj.points);
        }
        break;
    case 1:
        {  // new scope
        retval = (cueType == obj.cueType);
        }
        break;
    case 2:
        {  // new scope
        retval = (color == obj.color);
        }
        break;
    case 3:
        {  // new scope
        retval = (glyphType == obj.glyphType);
        }
        break;
    case 4:
        {  // new scope
        retval = (label == obj.label);
        }
        break;
    case 5:
        {  // new scope
        retval = (showLabel == obj.showLabel);
        }
        break;
    case 6:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 7:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 8:
        {  // new scope
        retval = (opacity == obj.opacity);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VisualCueInfo::SetPointF
//
// Purpose: Set a specific entry (the ith point) in the vector of
//          points for this VisualCueInfo.
//
//          Points are stored in a double vector. Each successive group
//          of 3 entries in the vector is a single point.
//
// Programmer: Mark C. Miller
// Creation:   June 3, 2004
// 
// ****************************************************************************
void
VisualCueInfo::SetPointF(int i, const float *pt)
{
    // extend vector of points as necessary
    while (points.size() < 3*(i+1))
        points.push_back(0.0);

    points[3*i+0] = pt[0];
    points[3*i+1] = pt[1];
    points[3*i+2] = pt[2];

    Select(0,(void*)&points);
}

// ****************************************************************************
// Method: VisualCueInfo::GetPointF
//
// Purpose: Get a specific entry (the ith point) in the vector of
//          points for this VisualCueInfo.
//
//          Return false if an ith entry does not exist
///
// Programmer: Mark C. Miller
// Creation:   June 3, 2004
// 
// ****************************************************************************
bool
VisualCueInfo::GetPointF(int i, float *pt) const
{
    if (points.size() < 3*i)
        return false;

    pt[0] = (float) points[3*i+0];
    pt[1] = (float) points[3*i+1];
    pt[2] = (float) points[3*i+2];

    return true;
}

void
VisualCueInfo::SetFromP(const PickAttributes *pa)
{
    if (pa == 0)
        return;

    SetCueType(PickPoint);
    SetPointF(0,pa->GetPickPoint());
    SetLabel(pa->GetPickLetter());
    if ((pa->GetPickType() != PickAttributes::Zone) &&
        (pa->GetPickType() != PickAttributes::DomainZone))
        SetGlyphType("Square");
}

void
VisualCueInfo::SetFromL(const Line *line)
{
    if (line == 0)
        return;

    SetCueType(RefLine);
    SetPointD(0,line->GetPoint1());
    SetPointD(1,line->GetPoint2());
    SetLabel(line->GetDesignator());
    SetShowLabel(line->GetReflineLabels());
    SetLineWidth(line->GetLineWidth());
    SetLineStyle(line->GetLineStyle());
    SetColor(line->GetColor());
}

// ****************************************************************************
// Method: VisualCueInfo::SetPointD
//
// Purpose: Set a specific entry (the ith point) in the vector of
//          points for this VisualCueInfo.
//
//          Points are stored in a double vector. Each successive group
//          of 3 entries in the vector is a single point.
//
// Programmer: Mark C. Miller
// Creation:   June 3, 2004
// 
// ****************************************************************************
void
VisualCueInfo::SetPointD(int i, const double *pt)
{
    // extend vector of points as necessary
    while (points.size() < 3*(i+1))
        points.push_back(0.0);

    points[3*i+0] = pt[0];
    points[3*i+1] = pt[1];
    points[3*i+2] = pt[2];

    Select(0,(void*)&points);
}

// ****************************************************************************
// Method: VisualCueInfo::GetPointD
//
// Purpose: Get a specific entry (the ith point) in the vector of
//          points for this VisualCueInfo.
//
//          Return false if an ith entry does not exist
///
// Programmer: Mark C. Miller
// Creation:   June 3, 2004
// 
// ****************************************************************************
bool
VisualCueInfo::GetPointD(int i, double *pt) const
{
    if (points.size() < 3*i)
        return false;

    pt[0] = points[3*i+0];
    pt[1] = points[3*i+1];
    pt[2] = points[3*i+2];

    return true;
}

