#include <ViewCurveAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ViewCurveAttributes::ViewCurveAttributes
//
// Purpose: 
//   Constructor for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ViewCurveAttributes::ViewCurveAttributes() : AttributeSubject("DDD")
{
    domainCoords[0] = 0;
    domainCoords[1] = 1;
    rangeCoords[0] = 0;
    rangeCoords[1] = 1;
    viewportCoords[0] = 0.1;
    viewportCoords[1] = 0.1;
    viewportCoords[2] = 0.9;
    viewportCoords[3] = 0.9;
}

// ****************************************************************************
// Method: ViewCurveAttributes::ViewCurveAttributes
//
// Purpose: 
//   Copy constructor for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ViewCurveAttributes::ViewCurveAttributes(const ViewCurveAttributes &obj) : AttributeSubject("DDD")
{
    int i;

    domainCoords[0] = obj.domainCoords[0];
    domainCoords[1] = obj.domainCoords[1];

    rangeCoords[0] = obj.rangeCoords[0];
    rangeCoords[1] = obj.rangeCoords[1];

    for(i = 0; i < 4; ++i)
        viewportCoords[i] = obj.viewportCoords[i];


    SelectAll();
}

// ****************************************************************************
// Method: ViewCurveAttributes::~ViewCurveAttributes
//
// Purpose: 
//   Destructor for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ViewCurveAttributes::~ViewCurveAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ViewCurveAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ViewCurveAttributes::operator = (const ViewCurveAttributes &obj)
{
    int i;

    domainCoords[0] = obj.domainCoords[0];
    domainCoords[1] = obj.domainCoords[1];

    rangeCoords[0] = obj.rangeCoords[0];
    rangeCoords[1] = obj.rangeCoords[1];

    for(i = 0; i < 4; ++i)
        viewportCoords[i] = obj.viewportCoords[i];


    SelectAll();
}

// ****************************************************************************
// Method: ViewCurveAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ViewCurveAttributes::operator == (const ViewCurveAttributes &obj) const
{
    int i;

    // Compare the domainCoords arrays.
    bool domainCoords_equal = true;
    for(i = 0; i < 2 && domainCoords_equal; ++i)
        domainCoords_equal = (domainCoords[i] == obj.domainCoords[i]);

    // Compare the rangeCoords arrays.
    bool rangeCoords_equal = true;
    for(i = 0; i < 2 && rangeCoords_equal; ++i)
        rangeCoords_equal = (rangeCoords[i] == obj.rangeCoords[i]);

    // Compare the viewportCoords arrays.
    bool viewportCoords_equal = true;
    for(i = 0; i < 4 && viewportCoords_equal; ++i)
        viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

    // Create the return value
    return (domainCoords_equal &&
            rangeCoords_equal &&
            viewportCoords_equal);
}

// ****************************************************************************
// Method: ViewCurveAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ViewCurveAttributes::operator != (const ViewCurveAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ViewCurveAttributes::TypeName
//
// Purpose: 
//   Type name method for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
ViewCurveAttributes::TypeName() const
{
    return "ViewCurveAttributes";
}

// ****************************************************************************
// Method: ViewCurveAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ViewCurveAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ViewCurveAttributes *tmp = (const ViewCurveAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ViewCurveAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewCurveAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ViewCurveAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ViewCurveAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ViewCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewCurveAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ViewCurveAttributes(*this);
    else
        retval = new ViewCurveAttributes;

    return retval;
}

// ****************************************************************************
// Method: ViewCurveAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ViewCurveAttributes::SelectAll()
{
    Select(0, (void *)domainCoords, 2);
    Select(1, (void *)rangeCoords, 2);
    Select(2, (void *)viewportCoords, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewCurveAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ViewCurveAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ViewCurveAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ViewCurveAttributes.
    DataNode *node = new DataNode("ViewCurveAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("domainCoords", domainCoords, 2));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("rangeCoords", rangeCoords, 2));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewportCoords", viewportCoords, 4));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ViewCurveAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ViewCurveAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ViewCurveAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("domainCoords")) != 0)
        SetDomainCoords(node->AsDoubleArray());
    if((node = searchNode->GetNode("rangeCoords")) != 0)
        SetRangeCoords(node->AsDoubleArray());
    if((node = searchNode->GetNode("viewportCoords")) != 0)
        SetViewportCoords(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewCurveAttributes::SetDomainCoords(const double *domainCoords_)
{
    domainCoords[0] = domainCoords_[0];
    domainCoords[1] = domainCoords_[1];
    Select(0, (void *)domainCoords, 2);
}

void
ViewCurveAttributes::SetRangeCoords(const double *rangeCoords_)
{
    rangeCoords[0] = rangeCoords_[0];
    rangeCoords[1] = rangeCoords_[1];
    Select(1, (void *)rangeCoords, 2);
}

void
ViewCurveAttributes::SetViewportCoords(const double *viewportCoords_)
{
    viewportCoords[0] = viewportCoords_[0];
    viewportCoords[1] = viewportCoords_[1];
    viewportCoords[2] = viewportCoords_[2];
    viewportCoords[3] = viewportCoords_[3];
    Select(2, (void *)viewportCoords, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
ViewCurveAttributes::GetDomainCoords() const
{
    return domainCoords;
}

double *
ViewCurveAttributes::GetDomainCoords()
{
    return domainCoords;
}

const double *
ViewCurveAttributes::GetRangeCoords() const
{
    return rangeCoords;
}

double *
ViewCurveAttributes::GetRangeCoords()
{
    return rangeCoords;
}

const double *
ViewCurveAttributes::GetViewportCoords() const
{
    return viewportCoords;
}

double *
ViewCurveAttributes::GetViewportCoords()
{
    return viewportCoords;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewCurveAttributes::SelectDomainCoords()
{
    Select(0, (void *)domainCoords, 2);
}

void
ViewCurveAttributes::SelectRangeCoords()
{
    Select(1, (void *)rangeCoords, 2);
}

void
ViewCurveAttributes::SelectViewportCoords()
{
    Select(2, (void *)viewportCoords, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewCurveAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewCurveAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "domainCoords";
        case 1:  return "rangeCoords";
        case 2:  return "viewportCoords";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewCurveAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ViewCurveAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_doubleArray;
        case 1:  return FieldType_doubleArray;
        case 2:  return FieldType_doubleArray;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ViewCurveAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewCurveAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "doubleArray";
        case 1:  return "doubleArray";
        case 2:  return "doubleArray";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewCurveAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ViewCurveAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const ViewCurveAttributes &obj = *((const ViewCurveAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        // Compare the domainCoords arrays.
        bool domainCoords_equal = true;
        for(i = 0; i < 2 && domainCoords_equal; ++i)
            domainCoords_equal = (domainCoords[i] == obj.domainCoords[i]);

        retval = domainCoords_equal;
        }
        break;
    case 1:
        {  // new scope
        // Compare the rangeCoords arrays.
        bool rangeCoords_equal = true;
        for(i = 0; i < 2 && rangeCoords_equal; ++i)
            rangeCoords_equal = (rangeCoords[i] == obj.rangeCoords[i]);

        retval = rangeCoords_equal;
        }
        break;
    case 2:
        {  // new scope
        // Compare the viewportCoords arrays.
        bool viewportCoords_equal = true;
        for(i = 0; i < 4 && viewportCoords_equal; ++i)
            viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

        retval = viewportCoords_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

