#ifndef VIEW3DATTRIBUTES_H
#define VIEW3DATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: View3DAttributes
//
// Purpose:
//    This class contains the 3d view attributes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

class STATE_API View3DAttributes : public AttributeSubject
{
public:
    View3DAttributes();
    View3DAttributes(const View3DAttributes &obj);
    virtual ~View3DAttributes();

    virtual void operator = (const View3DAttributes &obj);
    virtual bool operator == (const View3DAttributes &obj) const;
    virtual bool operator != (const View3DAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectViewNormal();
    void SelectFocus();
    void SelectViewUp();
    void SelectImagePan();
    void SelectCenterOfRotation();

    // Property setting methods
    void SetViewNormal(const double *viewNormal_);
    void SetFocus(const double *focus_);
    void SetViewUp(const double *viewUp_);
    void SetViewAngle(double viewAngle_);
    void SetParallelScale(double parallelScale_);
    void SetNearPlane(double nearPlane_);
    void SetFarPlane(double farPlane_);
    void SetImagePan(const double *imagePan_);
    void SetImageZoom(double imageZoom_);
    void SetPerspective(bool perspective_);
    void SetEyeAngle(double eyeAngle_);
    void SetCenterOfRotationSet(bool centerOfRotationSet_);
    void SetCenterOfRotation(const double *centerOfRotation_);

    // Property getting methods
    const double *GetViewNormal() const;
          double *GetViewNormal();
    const double *GetFocus() const;
          double *GetFocus();
    const double *GetViewUp() const;
          double *GetViewUp();
    double       GetViewAngle() const;
    double       GetParallelScale() const;
    double       GetNearPlane() const;
    double       GetFarPlane() const;
    const double *GetImagePan() const;
          double *GetImagePan();
    double       GetImageZoom() const;
    bool         GetPerspective() const;
    double       GetEyeAngle() const;
    bool         GetCenterOfRotationSet() const;
    const double *GetCenterOfRotation() const;
          double *GetCenterOfRotation();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    double viewNormal[3];
    double focus[3];
    double viewUp[3];
    double viewAngle;
    double parallelScale;
    double nearPlane;
    double farPlane;
    double imagePan[2];
    double imageZoom;
    bool   perspective;
    double eyeAngle;
    bool   centerOfRotationSet;
    double centerOfRotation[3];
};

#endif
