#include <View3DAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: View3DAttributes::View3DAttributes
//
// Purpose: 
//   Constructor for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

View3DAttributes::View3DAttributes() : AttributeSubject("DDDddddDdbdbD")
{
    viewNormal[0] = 0;
    viewNormal[1] = 0;
    viewNormal[2] = 1;
    focus[0] = 0;
    focus[1] = 0;
    focus[2] = 0;
    viewUp[0] = 0;
    viewUp[1] = 1;
    viewUp[2] = 0;
    viewAngle = 30;
    parallelScale = 1;
    nearPlane = 0.001;
    farPlane = 100;
    imagePan[0] = 0;
    imagePan[1] = 0;
    imageZoom = 1;
    perspective = true;
    eyeAngle = 2;
    centerOfRotationSet = false;
    centerOfRotation[0] = 0;
    centerOfRotation[1] = 0;
    centerOfRotation[2] = 0;
}

// ****************************************************************************
// Method: View3DAttributes::View3DAttributes
//
// Purpose: 
//   Copy constructor for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

View3DAttributes::View3DAttributes(const View3DAttributes &obj) : AttributeSubject("DDDddddDdbdbD")
{
    viewNormal[0] = obj.viewNormal[0];
    viewNormal[1] = obj.viewNormal[1];
    viewNormal[2] = obj.viewNormal[2];

    focus[0] = obj.focus[0];
    focus[1] = obj.focus[1];
    focus[2] = obj.focus[2];

    viewUp[0] = obj.viewUp[0];
    viewUp[1] = obj.viewUp[1];
    viewUp[2] = obj.viewUp[2];

    viewAngle = obj.viewAngle;
    parallelScale = obj.parallelScale;
    nearPlane = obj.nearPlane;
    farPlane = obj.farPlane;
    imagePan[0] = obj.imagePan[0];
    imagePan[1] = obj.imagePan[1];

    imageZoom = obj.imageZoom;
    perspective = obj.perspective;
    eyeAngle = obj.eyeAngle;
    centerOfRotationSet = obj.centerOfRotationSet;
    centerOfRotation[0] = obj.centerOfRotation[0];
    centerOfRotation[1] = obj.centerOfRotation[1];
    centerOfRotation[2] = obj.centerOfRotation[2];


    SelectAll();
}

// ****************************************************************************
// Method: View3DAttributes::~View3DAttributes
//
// Purpose: 
//   Destructor for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

View3DAttributes::~View3DAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: View3DAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
View3DAttributes::operator = (const View3DAttributes &obj)
{
    viewNormal[0] = obj.viewNormal[0];
    viewNormal[1] = obj.viewNormal[1];
    viewNormal[2] = obj.viewNormal[2];

    focus[0] = obj.focus[0];
    focus[1] = obj.focus[1];
    focus[2] = obj.focus[2];

    viewUp[0] = obj.viewUp[0];
    viewUp[1] = obj.viewUp[1];
    viewUp[2] = obj.viewUp[2];

    viewAngle = obj.viewAngle;
    parallelScale = obj.parallelScale;
    nearPlane = obj.nearPlane;
    farPlane = obj.farPlane;
    imagePan[0] = obj.imagePan[0];
    imagePan[1] = obj.imagePan[1];

    imageZoom = obj.imageZoom;
    perspective = obj.perspective;
    eyeAngle = obj.eyeAngle;
    centerOfRotationSet = obj.centerOfRotationSet;
    centerOfRotation[0] = obj.centerOfRotation[0];
    centerOfRotation[1] = obj.centerOfRotation[1];
    centerOfRotation[2] = obj.centerOfRotation[2];


    SelectAll();
}

// ****************************************************************************
// Method: View3DAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
View3DAttributes::operator == (const View3DAttributes &obj) const
{
    int i;

    // Compare the viewNormal arrays.
    bool viewNormal_equal = true;
    for(i = 0; i < 3 && viewNormal_equal; ++i)
        viewNormal_equal = (viewNormal[i] == obj.viewNormal[i]);

    // Compare the focus arrays.
    bool focus_equal = true;
    for(i = 0; i < 3 && focus_equal; ++i)
        focus_equal = (focus[i] == obj.focus[i]);

    // Compare the viewUp arrays.
    bool viewUp_equal = true;
    for(i = 0; i < 3 && viewUp_equal; ++i)
        viewUp_equal = (viewUp[i] == obj.viewUp[i]);

    // Compare the imagePan arrays.
    bool imagePan_equal = true;
    for(i = 0; i < 2 && imagePan_equal; ++i)
        imagePan_equal = (imagePan[i] == obj.imagePan[i]);

    // Compare the centerOfRotation arrays.
    bool centerOfRotation_equal = true;
    for(i = 0; i < 3 && centerOfRotation_equal; ++i)
        centerOfRotation_equal = (centerOfRotation[i] == obj.centerOfRotation[i]);

    // Create the return value
    return (viewNormal_equal &&
            focus_equal &&
            viewUp_equal &&
            (viewAngle == obj.viewAngle) &&
            (parallelScale == obj.parallelScale) &&
            (nearPlane == obj.nearPlane) &&
            (farPlane == obj.farPlane) &&
            imagePan_equal &&
            (imageZoom == obj.imageZoom) &&
            (perspective == obj.perspective) &&
            (eyeAngle == obj.eyeAngle) &&
            (centerOfRotationSet == obj.centerOfRotationSet) &&
            centerOfRotation_equal);
}

// ****************************************************************************
// Method: View3DAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
View3DAttributes::operator != (const View3DAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: View3DAttributes::TypeName
//
// Purpose: 
//   Type name method for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
View3DAttributes::TypeName() const
{
    return "View3DAttributes";
}

// ****************************************************************************
// Method: View3DAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
View3DAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const View3DAttributes *tmp = (const View3DAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: View3DAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
View3DAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new View3DAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: View3DAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the View3DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
View3DAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new View3DAttributes(*this);
    else
        retval = new View3DAttributes;

    return retval;
}

// ****************************************************************************
// Method: View3DAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
View3DAttributes::SelectAll()
{
    Select(0, (void *)viewNormal, 3);
    Select(1, (void *)focus, 3);
    Select(2, (void *)viewUp, 3);
    Select(3, (void *)&viewAngle);
    Select(4, (void *)&parallelScale);
    Select(5, (void *)&nearPlane);
    Select(6, (void *)&farPlane);
    Select(7, (void *)imagePan, 2);
    Select(8, (void *)&imageZoom);
    Select(9, (void *)&perspective);
    Select(10, (void *)&eyeAngle);
    Select(11, (void *)&centerOfRotationSet);
    Select(12, (void *)centerOfRotation, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: View3DAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
View3DAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    View3DAttributes defaultObject;
    bool addToParent = false;
    // Create a node for View3DAttributes.
    DataNode *node = new DataNode("View3DAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewNormal", viewNormal, 3));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("focus", focus, 3));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewUp", viewUp, 3));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewAngle", viewAngle));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("parallelScale", parallelScale));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nearPlane", nearPlane));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("farPlane", farPlane));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imagePan", imagePan, 2));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imageZoom", imageZoom));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("perspective", perspective));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("eyeAngle", eyeAngle));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("centerOfRotationSet", centerOfRotationSet));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("centerOfRotation", centerOfRotation, 3));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: View3DAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
View3DAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("View3DAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("viewNormal")) != 0)
        SetViewNormal(node->AsDoubleArray());
    if((node = searchNode->GetNode("focus")) != 0)
        SetFocus(node->AsDoubleArray());
    if((node = searchNode->GetNode("viewUp")) != 0)
        SetViewUp(node->AsDoubleArray());
    if((node = searchNode->GetNode("viewAngle")) != 0)
        SetViewAngle(node->AsDouble());
    if((node = searchNode->GetNode("parallelScale")) != 0)
        SetParallelScale(node->AsDouble());
    if((node = searchNode->GetNode("nearPlane")) != 0)
        SetNearPlane(node->AsDouble());
    if((node = searchNode->GetNode("farPlane")) != 0)
        SetFarPlane(node->AsDouble());
    if((node = searchNode->GetNode("imagePan")) != 0)
        SetImagePan(node->AsDoubleArray());
    if((node = searchNode->GetNode("imageZoom")) != 0)
        SetImageZoom(node->AsDouble());
    if((node = searchNode->GetNode("perspective")) != 0)
        SetPerspective(node->AsBool());
    if((node = searchNode->GetNode("eyeAngle")) != 0)
        SetEyeAngle(node->AsDouble());
    if((node = searchNode->GetNode("centerOfRotationSet")) != 0)
        SetCenterOfRotationSet(node->AsBool());
    if((node = searchNode->GetNode("centerOfRotation")) != 0)
        SetCenterOfRotation(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
View3DAttributes::SetViewNormal(const double *viewNormal_)
{
    viewNormal[0] = viewNormal_[0];
    viewNormal[1] = viewNormal_[1];
    viewNormal[2] = viewNormal_[2];
    Select(0, (void *)viewNormal, 3);
}

void
View3DAttributes::SetFocus(const double *focus_)
{
    focus[0] = focus_[0];
    focus[1] = focus_[1];
    focus[2] = focus_[2];
    Select(1, (void *)focus, 3);
}

void
View3DAttributes::SetViewUp(const double *viewUp_)
{
    viewUp[0] = viewUp_[0];
    viewUp[1] = viewUp_[1];
    viewUp[2] = viewUp_[2];
    Select(2, (void *)viewUp, 3);
}

void
View3DAttributes::SetViewAngle(double viewAngle_)
{
    viewAngle = viewAngle_;
    Select(3, (void *)&viewAngle);
}

void
View3DAttributes::SetParallelScale(double parallelScale_)
{
    parallelScale = parallelScale_;
    Select(4, (void *)&parallelScale);
}

void
View3DAttributes::SetNearPlane(double nearPlane_)
{
    nearPlane = nearPlane_;
    Select(5, (void *)&nearPlane);
}

void
View3DAttributes::SetFarPlane(double farPlane_)
{
    farPlane = farPlane_;
    Select(6, (void *)&farPlane);
}

void
View3DAttributes::SetImagePan(const double *imagePan_)
{
    imagePan[0] = imagePan_[0];
    imagePan[1] = imagePan_[1];
    Select(7, (void *)imagePan, 2);
}

void
View3DAttributes::SetImageZoom(double imageZoom_)
{
    imageZoom = imageZoom_;
    Select(8, (void *)&imageZoom);
}

void
View3DAttributes::SetPerspective(bool perspective_)
{
    perspective = perspective_;
    Select(9, (void *)&perspective);
}

void
View3DAttributes::SetEyeAngle(double eyeAngle_)
{
    eyeAngle = eyeAngle_;
    Select(10, (void *)&eyeAngle);
}

void
View3DAttributes::SetCenterOfRotationSet(bool centerOfRotationSet_)
{
    centerOfRotationSet = centerOfRotationSet_;
    Select(11, (void *)&centerOfRotationSet);
}

void
View3DAttributes::SetCenterOfRotation(const double *centerOfRotation_)
{
    centerOfRotation[0] = centerOfRotation_[0];
    centerOfRotation[1] = centerOfRotation_[1];
    centerOfRotation[2] = centerOfRotation_[2];
    Select(12, (void *)centerOfRotation, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
View3DAttributes::GetViewNormal() const
{
    return viewNormal;
}

double *
View3DAttributes::GetViewNormal()
{
    return viewNormal;
}

const double *
View3DAttributes::GetFocus() const
{
    return focus;
}

double *
View3DAttributes::GetFocus()
{
    return focus;
}

const double *
View3DAttributes::GetViewUp() const
{
    return viewUp;
}

double *
View3DAttributes::GetViewUp()
{
    return viewUp;
}

double
View3DAttributes::GetViewAngle() const
{
    return viewAngle;
}

double
View3DAttributes::GetParallelScale() const
{
    return parallelScale;
}

double
View3DAttributes::GetNearPlane() const
{
    return nearPlane;
}

double
View3DAttributes::GetFarPlane() const
{
    return farPlane;
}

const double *
View3DAttributes::GetImagePan() const
{
    return imagePan;
}

double *
View3DAttributes::GetImagePan()
{
    return imagePan;
}

double
View3DAttributes::GetImageZoom() const
{
    return imageZoom;
}

bool
View3DAttributes::GetPerspective() const
{
    return perspective;
}

double
View3DAttributes::GetEyeAngle() const
{
    return eyeAngle;
}

bool
View3DAttributes::GetCenterOfRotationSet() const
{
    return centerOfRotationSet;
}

const double *
View3DAttributes::GetCenterOfRotation() const
{
    return centerOfRotation;
}

double *
View3DAttributes::GetCenterOfRotation()
{
    return centerOfRotation;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
View3DAttributes::SelectViewNormal()
{
    Select(0, (void *)viewNormal, 3);
}

void
View3DAttributes::SelectFocus()
{
    Select(1, (void *)focus, 3);
}

void
View3DAttributes::SelectViewUp()
{
    Select(2, (void *)viewUp, 3);
}

void
View3DAttributes::SelectImagePan()
{
    Select(7, (void *)imagePan, 2);
}

void
View3DAttributes::SelectCenterOfRotation()
{
    Select(12, (void *)centerOfRotation, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: View3DAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
View3DAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "viewNormal";
        case 1:  return "focus";
        case 2:  return "viewUp";
        case 3:  return "viewAngle";
        case 4:  return "parallelScale";
        case 5:  return "nearPlane";
        case 6:  return "farPlane";
        case 7:  return "imagePan";
        case 8:  return "imageZoom";
        case 9:  return "perspective";
        case 10:  return "eyeAngle";
        case 11:  return "centerOfRotationSet";
        case 12:  return "centerOfRotation";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: View3DAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
View3DAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_doubleArray;
        case 1:  return FieldType_doubleArray;
        case 2:  return FieldType_doubleArray;
        case 3:  return FieldType_double;
        case 4:  return FieldType_double;
        case 5:  return FieldType_double;
        case 6:  return FieldType_double;
        case 7:  return FieldType_doubleArray;
        case 8:  return FieldType_double;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_double;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_doubleArray;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: View3DAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
View3DAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "doubleArray";
        case 1:  return "doubleArray";
        case 2:  return "doubleArray";
        case 3:  return "double";
        case 4:  return "double";
        case 5:  return "double";
        case 6:  return "double";
        case 7:  return "doubleArray";
        case 8:  return "double";
        case 9:  return "bool";
        case 10:  return "double";
        case 11:  return "bool";
        case 12:  return "doubleArray";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: View3DAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Feb 9 14:49:10 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
View3DAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const View3DAttributes &obj = *((const View3DAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        // Compare the viewNormal arrays.
        bool viewNormal_equal = true;
        for(i = 0; i < 3 && viewNormal_equal; ++i)
            viewNormal_equal = (viewNormal[i] == obj.viewNormal[i]);

        retval = viewNormal_equal;
        }
        break;
    case 1:
        {  // new scope
        // Compare the focus arrays.
        bool focus_equal = true;
        for(i = 0; i < 3 && focus_equal; ++i)
            focus_equal = (focus[i] == obj.focus[i]);

        retval = focus_equal;
        }
        break;
    case 2:
        {  // new scope
        // Compare the viewUp arrays.
        bool viewUp_equal = true;
        for(i = 0; i < 3 && viewUp_equal; ++i)
            viewUp_equal = (viewUp[i] == obj.viewUp[i]);

        retval = viewUp_equal;
        }
        break;
    case 3:
        {  // new scope
        retval = (viewAngle == obj.viewAngle);
        }
        break;
    case 4:
        {  // new scope
        retval = (parallelScale == obj.parallelScale);
        }
        break;
    case 5:
        {  // new scope
        retval = (nearPlane == obj.nearPlane);
        }
        break;
    case 6:
        {  // new scope
        retval = (farPlane == obj.farPlane);
        }
        break;
    case 7:
        {  // new scope
        // Compare the imagePan arrays.
        bool imagePan_equal = true;
        for(i = 0; i < 2 && imagePan_equal; ++i)
            imagePan_equal = (imagePan[i] == obj.imagePan[i]);

        retval = imagePan_equal;
        }
        break;
    case 8:
        {  // new scope
        retval = (imageZoom == obj.imageZoom);
        }
        break;
    case 9:
        {  // new scope
        retval = (perspective == obj.perspective);
        }
        break;
    case 10:
        {  // new scope
        retval = (eyeAngle == obj.eyeAngle);
        }
        break;
    case 11:
        {  // new scope
        retval = (centerOfRotationSet == obj.centerOfRotationSet);
        }
        break;
    case 12:
        {  // new scope
        // Compare the centerOfRotation arrays.
        bool centerOfRotation_equal = true;
        for(i = 0; i < 3 && centerOfRotation_equal; ++i)
            centerOfRotation_equal = (centerOfRotation[i] == obj.centerOfRotation[i]);

        retval = centerOfRotation_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

