#ifndef VIEW2DATTRIBUTES_H
#define VIEW2DATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: View2DAttributes
//
// Purpose:
//    This class contains the 2d view attributes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API View2DAttributes : public AttributeSubject
{
public:
    View2DAttributes();
    View2DAttributes(const View2DAttributes &obj);
    virtual ~View2DAttributes();

    virtual void operator = (const View2DAttributes &obj);
    virtual bool operator == (const View2DAttributes &obj) const;
    virtual bool operator != (const View2DAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectWindowCoords();
    void SelectViewportCoords();

    // Property setting methods
    void SetWindowCoords(const double *windowCoords_);
    void SetViewportCoords(const double *viewportCoords_);
    void SetFullFrame(bool fullFrame_);

    // Property getting methods
    const double *GetWindowCoords() const;
          double *GetWindowCoords();
    const double *GetViewportCoords() const;
          double *GetViewportCoords();
    bool         GetFullFrame() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    double windowCoords[4];
    double viewportCoords[4];
    bool   fullFrame;
};

#endif
