#include <View2DAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: View2DAttributes::View2DAttributes
//
// Purpose: 
//   Constructor for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

View2DAttributes::View2DAttributes() : AttributeSubject("DDb")
{
    windowCoords[0] = 0;
    windowCoords[1] = 0;
    windowCoords[2] = 1;
    windowCoords[3] = 1;
    viewportCoords[0] = 0.1;
    viewportCoords[1] = 0.1;
    viewportCoords[2] = 0.9;
    viewportCoords[3] = 0.9;
    fullFrame = false;
}

// ****************************************************************************
// Method: View2DAttributes::View2DAttributes
//
// Purpose: 
//   Copy constructor for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

View2DAttributes::View2DAttributes(const View2DAttributes &obj) : AttributeSubject("DDb")
{
    int i;

    for(i = 0; i < 4; ++i)
        windowCoords[i] = obj.windowCoords[i];

    for(i = 0; i < 4; ++i)
        viewportCoords[i] = obj.viewportCoords[i];

    fullFrame = obj.fullFrame;

    SelectAll();
}

// ****************************************************************************
// Method: View2DAttributes::~View2DAttributes
//
// Purpose: 
//   Destructor for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

View2DAttributes::~View2DAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: View2DAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
View2DAttributes::operator = (const View2DAttributes &obj)
{
    int i;

    for(i = 0; i < 4; ++i)
        windowCoords[i] = obj.windowCoords[i];

    for(i = 0; i < 4; ++i)
        viewportCoords[i] = obj.viewportCoords[i];

    fullFrame = obj.fullFrame;

    SelectAll();
}

// ****************************************************************************
// Method: View2DAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
View2DAttributes::operator == (const View2DAttributes &obj) const
{
    int i;

    // Compare the windowCoords arrays.
    bool windowCoords_equal = true;
    for(i = 0; i < 4 && windowCoords_equal; ++i)
        windowCoords_equal = (windowCoords[i] == obj.windowCoords[i]);

    // Compare the viewportCoords arrays.
    bool viewportCoords_equal = true;
    for(i = 0; i < 4 && viewportCoords_equal; ++i)
        viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

    // Create the return value
    return (windowCoords_equal &&
            viewportCoords_equal &&
            (fullFrame == obj.fullFrame));
}

// ****************************************************************************
// Method: View2DAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
View2DAttributes::operator != (const View2DAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: View2DAttributes::TypeName
//
// Purpose: 
//   Type name method for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
View2DAttributes::TypeName() const
{
    return "View2DAttributes";
}

// ****************************************************************************
// Method: View2DAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
View2DAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const View2DAttributes *tmp = (const View2DAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: View2DAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
View2DAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new View2DAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: View2DAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the View2DAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
View2DAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new View2DAttributes(*this);
    else
        retval = new View2DAttributes;

    return retval;
}

// ****************************************************************************
// Method: View2DAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
View2DAttributes::SelectAll()
{
    Select(0, (void *)windowCoords, 4);
    Select(1, (void *)viewportCoords, 4);
    Select(2, (void *)&fullFrame);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: View2DAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
View2DAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    View2DAttributes defaultObject;
    bool addToParent = false;
    // Create a node for View2DAttributes.
    DataNode *node = new DataNode("View2DAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("windowCoords", windowCoords, 4));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewportCoords", viewportCoords, 4));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fullFrame", fullFrame));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: View2DAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
View2DAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("View2DAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("windowCoords")) != 0)
        SetWindowCoords(node->AsDoubleArray());
    if((node = searchNode->GetNode("viewportCoords")) != 0)
        SetViewportCoords(node->AsDoubleArray());
    if((node = searchNode->GetNode("fullFrame")) != 0)
        SetFullFrame(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
View2DAttributes::SetWindowCoords(const double *windowCoords_)
{
    windowCoords[0] = windowCoords_[0];
    windowCoords[1] = windowCoords_[1];
    windowCoords[2] = windowCoords_[2];
    windowCoords[3] = windowCoords_[3];
    Select(0, (void *)windowCoords, 4);
}

void
View2DAttributes::SetViewportCoords(const double *viewportCoords_)
{
    viewportCoords[0] = viewportCoords_[0];
    viewportCoords[1] = viewportCoords_[1];
    viewportCoords[2] = viewportCoords_[2];
    viewportCoords[3] = viewportCoords_[3];
    Select(1, (void *)viewportCoords, 4);
}

void
View2DAttributes::SetFullFrame(bool fullFrame_)
{
    fullFrame = fullFrame_;
    Select(2, (void *)&fullFrame);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
View2DAttributes::GetWindowCoords() const
{
    return windowCoords;
}

double *
View2DAttributes::GetWindowCoords()
{
    return windowCoords;
}

const double *
View2DAttributes::GetViewportCoords() const
{
    return viewportCoords;
}

double *
View2DAttributes::GetViewportCoords()
{
    return viewportCoords;
}

bool
View2DAttributes::GetFullFrame() const
{
    return fullFrame;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
View2DAttributes::SelectWindowCoords()
{
    Select(0, (void *)windowCoords, 4);
}

void
View2DAttributes::SelectViewportCoords()
{
    Select(1, (void *)viewportCoords, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: View2DAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
View2DAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "windowCoords";
        case 1:  return "viewportCoords";
        case 2:  return "fullFrame";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: View2DAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
View2DAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_doubleArray;
        case 1:  return FieldType_doubleArray;
        case 2:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: View2DAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
View2DAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "doubleArray";
        case 1:  return "doubleArray";
        case 2:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: View2DAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:35 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
View2DAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const View2DAttributes &obj = *((const View2DAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        // Compare the windowCoords arrays.
        bool windowCoords_equal = true;
        for(i = 0; i < 4 && windowCoords_equal; ++i)
            windowCoords_equal = (windowCoords[i] == obj.windowCoords[i]);

        retval = windowCoords_equal;
        }
        break;
    case 1:
        {  // new scope
        // Compare the viewportCoords arrays.
        bool viewportCoords_equal = true;
        for(i = 0; i < 4 && viewportCoords_equal; ++i)
            viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

        retval = viewportCoords_equal;
        }
        break;
    case 2:
        {  // new scope
        retval = (fullFrame == obj.fullFrame);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

