#ifndef TIMEFORMAT_H
#define TIMEFORMAT_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: TimeFormat
//
// Purpose:
//    This class encapsulates the attributes needed to format time.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API TimeFormat : public AttributeSubject
{
public:
    enum DisplayMode
    {
        Cycles,
        Times,
        CyclesAndTimes
    };

    TimeFormat();
    TimeFormat(const TimeFormat &obj);
    virtual ~TimeFormat();

    virtual void operator = (const TimeFormat &obj);
    virtual bool operator == (const TimeFormat &obj) const;
    virtual bool operator != (const TimeFormat &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetDisplayMode(DisplayMode displayMode_);
    void SetPrecision(int precision_);

    // Property getting methods
    DisplayMode GetDisplayMode() const;
    int GetPrecision() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string DisplayMode_ToString(DisplayMode);
    static bool DisplayMode_FromString(const std::string &, DisplayMode &);
protected:
    static std::string DisplayMode_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    int displayMode;
    int precision;
};

#endif
