#include <TimeFormat.h>
#include <DataNode.h>

//
// Enum conversion methods for TimeFormat::DisplayMode
//

static const char *DisplayMode_strings[] = {
"Cycles", "Times", "CyclesAndTimes"
};

std::string
TimeFormat::DisplayMode_ToString(TimeFormat::DisplayMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return DisplayMode_strings[index];
}

std::string
TimeFormat::DisplayMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return DisplayMode_strings[index];
}

bool
TimeFormat::DisplayMode_FromString(const std::string &s, TimeFormat::DisplayMode &val)
{
    val = TimeFormat::Cycles;
    for(int i = 0; i < 3; ++i)
    {
        if(s == DisplayMode_strings[i])
        {
            val = (DisplayMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: TimeFormat::TimeFormat
//
// Purpose: 
//   Constructor for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

TimeFormat::TimeFormat() : AttributeSubject("ii")
{
    displayMode = Cycles;
    precision = 5;
}

// ****************************************************************************
// Method: TimeFormat::TimeFormat
//
// Purpose: 
//   Copy constructor for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

TimeFormat::TimeFormat(const TimeFormat &obj) : AttributeSubject("ii")
{
    displayMode = obj.displayMode;
    precision = obj.precision;

    SelectAll();
}

// ****************************************************************************
// Method: TimeFormat::~TimeFormat
//
// Purpose: 
//   Destructor for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

TimeFormat::~TimeFormat()
{
    // nothing here
}

// ****************************************************************************
// Method: TimeFormat::operator = 
//
// Purpose: 
//   Assignment operator for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
TimeFormat::operator = (const TimeFormat &obj)
{
    displayMode = obj.displayMode;
    precision = obj.precision;

    SelectAll();
}

// ****************************************************************************
// Method: TimeFormat::operator == 
//
// Purpose: 
//   Comparison operator == for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::operator == (const TimeFormat &obj) const
{
    // Create the return value
    return ((displayMode == obj.displayMode) &&
            (precision == obj.precision));
}

// ****************************************************************************
// Method: TimeFormat::operator != 
//
// Purpose: 
//   Comparison operator != for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::operator != (const TimeFormat &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TimeFormat::TypeName
//
// Purpose: 
//   Type name method for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
TimeFormat::TypeName() const
{
    return "TimeFormat";
}

// ****************************************************************************
// Method: TimeFormat::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TimeFormat *tmp = (const TimeFormat *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TimeFormat::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TimeFormat::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TimeFormat(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TimeFormat::NewInstance
//
// Purpose: 
//   NewInstance method for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TimeFormat::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TimeFormat(*this);
    else
        retval = new TimeFormat;

    return retval;
}

// ****************************************************************************
// Method: TimeFormat::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
TimeFormat::SelectAll()
{
    Select(0, (void *)&displayMode);
    Select(1, (void *)&precision);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TimeFormat::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TimeFormat defaultObject;
    bool addToParent = false;
    // Create a node for TimeFormat.
    DataNode *node = new DataNode("TimeFormat");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displayMode", DisplayMode_ToString(displayMode)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("precision", precision));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TimeFormat::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
TimeFormat::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TimeFormat");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("displayMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetDisplayMode(DisplayMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            DisplayMode value;
            if(DisplayMode_FromString(node->AsString(), value))
                SetDisplayMode(value);
        }
    }
    if((node = searchNode->GetNode("precision")) != 0)
        SetPrecision(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TimeFormat::SetDisplayMode(TimeFormat::DisplayMode displayMode_)
{
    displayMode = displayMode_;
    Select(0, (void *)&displayMode);
}

void
TimeFormat::SetPrecision(int precision_)
{
    precision = precision_;
    Select(1, (void *)&precision);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

TimeFormat::DisplayMode
TimeFormat::GetDisplayMode() const
{
    return DisplayMode(displayMode);
}

int
TimeFormat::GetPrecision() const
{
    return precision;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TimeFormat::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
TimeFormat::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Display mode";
        case 1:  return "Precision";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TimeFormat::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TimeFormat::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_int;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TimeFormat::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
TimeFormat::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "int";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TimeFormat::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 14:48:44 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TimeFormat &obj = *((const TimeFormat*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (displayMode == obj.displayMode);
        }
        break;
    case 1:
        {  // new scope
        retval = (precision == obj.precision);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

