#ifndef SURFACEFILTERATTRIBUTES_H
#define SURFACEFILTERATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: SurfaceFilterAttributes
//
// Purpose:
//    Attributes for the surface filter
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

class SurfaceFilterAttributes : public AttributeSubject
{
public:
    enum Scaling
    {
        Linear,
        Log,
        Skew
    };
    enum LimitsMode
    {
        OriginalData,
        CurrentPlot
    };

    SurfaceFilterAttributes();
    SurfaceFilterAttributes(const SurfaceFilterAttributes &obj);
    virtual ~SurfaceFilterAttributes();

    virtual SurfaceFilterAttributes& operator = (const SurfaceFilterAttributes &obj);
    virtual bool operator == (const SurfaceFilterAttributes &obj) const;
    virtual bool operator != (const SurfaceFilterAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectVariable();

    // Property setting methods
    void SetLimitsMode(LimitsMode limitsMode_);
    void SetMinFlag(bool minFlag_);
    void SetMaxFlag(bool maxFlag_);
    void SetScaling(Scaling scaling_);
    void SetSkewFactor(double skewFactor_);
    void SetMin(double min_);
    void SetMax(double max_);
    void SetVariable(const std::string &variable_);
    void SetUseXYLimits(bool useXYLimits_);
    void SetGenerateNodalOutput(bool generateNodalOutput_);

    // Property getting methods
    LimitsMode        GetLimitsMode() const;
    bool              GetMinFlag() const;
    bool              GetMaxFlag() const;
    Scaling           GetScaling() const;
    double            GetSkewFactor() const;
    double            GetMin() const;
    double            GetMax() const;
    const std::string &GetVariable() const;
          std::string &GetVariable();
    bool              GetUseXYLimits() const;
    bool              GetGenerateNodalOutput() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Scaling_ToString(Scaling);
    static bool Scaling_FromString(const std::string &, Scaling &);
protected:
    static std::string Scaling_ToString(int);
public:
    static std::string LimitsMode_ToString(LimitsMode);
    static bool LimitsMode_FromString(const std::string &, LimitsMode &);
protected:
    static std::string LimitsMode_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    int         limitsMode;
    bool        minFlag;
    bool        maxFlag;
    int         scaling;
    double      skewFactor;
    double      min;
    double      max;
    std::string variable;
    bool        useXYLimits;
    bool        generateNodalOutput;
};

#endif
