#include <SurfaceFilterAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for SurfaceFilterAttributes::Scaling
//

static const char *Scaling_strings[] = {
"Linear", "Log", "Skew"
};

std::string
SurfaceFilterAttributes::Scaling_ToString(SurfaceFilterAttributes::Scaling t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Scaling_strings[index];
}

std::string
SurfaceFilterAttributes::Scaling_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Scaling_strings[index];
}

bool
SurfaceFilterAttributes::Scaling_FromString(const std::string &s, SurfaceFilterAttributes::Scaling &val)
{
    val = SurfaceFilterAttributes::Linear;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Scaling_strings[i])
        {
            val = (Scaling)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SurfaceFilterAttributes::LimitsMode
//

static const char *LimitsMode_strings[] = {
"OriginalData", "CurrentPlot"};

std::string
SurfaceFilterAttributes::LimitsMode_ToString(SurfaceFilterAttributes::LimitsMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return LimitsMode_strings[index];
}

std::string
SurfaceFilterAttributes::LimitsMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return LimitsMode_strings[index];
}

bool
SurfaceFilterAttributes::LimitsMode_FromString(const std::string &s, SurfaceFilterAttributes::LimitsMode &val)
{
    val = SurfaceFilterAttributes::OriginalData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == LimitsMode_strings[i])
        {
            val = (LimitsMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SurfaceFilterAttributes
//
// Purpose: 
//   Constructor for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

SurfaceFilterAttributes::SurfaceFilterAttributes() : AttributeSubject("ibbidddsbb"),
    variable("default")
{
    limitsMode = OriginalData;
    minFlag = false;
    maxFlag = false;
    scaling = Linear;
    skewFactor = 1;
    min = 0;
    max = 1;
    useXYLimits = true;
    generateNodalOutput = true;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SurfaceFilterAttributes
//
// Purpose: 
//   Copy constructor for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

SurfaceFilterAttributes::SurfaceFilterAttributes(const SurfaceFilterAttributes &obj) : AttributeSubject("ibbidddsbb")
{
    limitsMode = obj.limitsMode;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    scaling = obj.scaling;
    skewFactor = obj.skewFactor;
    min = obj.min;
    max = obj.max;
    variable = obj.variable;
    useXYLimits = obj.useXYLimits;
    generateNodalOutput = obj.generateNodalOutput;

    SelectAll();
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::~SurfaceFilterAttributes
//
// Purpose: 
//   Destructor for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

SurfaceFilterAttributes::~SurfaceFilterAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

SurfaceFilterAttributes& 
SurfaceFilterAttributes::operator = (const SurfaceFilterAttributes &obj)
{
    if (this == &obj) return *this;
    limitsMode = obj.limitsMode;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    scaling = obj.scaling;
    skewFactor = obj.skewFactor;
    min = obj.min;
    max = obj.max;
    variable = obj.variable;
    useXYLimits = obj.useXYLimits;
    generateNodalOutput = obj.generateNodalOutput;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceFilterAttributes::operator == (const SurfaceFilterAttributes &obj) const
{
    // Create the return value
    return ((limitsMode == obj.limitsMode) &&
            (minFlag == obj.minFlag) &&
            (maxFlag == obj.maxFlag) &&
            (scaling == obj.scaling) &&
            (skewFactor == obj.skewFactor) &&
            (min == obj.min) &&
            (max == obj.max) &&
            (variable == obj.variable) &&
            (useXYLimits == obj.useXYLimits) &&
            (generateNodalOutput == obj.generateNodalOutput));
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceFilterAttributes::operator != (const SurfaceFilterAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::TypeName
//
// Purpose: 
//   Type name method for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
SurfaceFilterAttributes::TypeName() const
{
    return "SurfaceFilterAttributes";
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceFilterAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SurfaceFilterAttributes *tmp = (const SurfaceFilterAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfaceFilterAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SurfaceFilterAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfaceFilterAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SurfaceFilterAttributes(*this);
    else
        retval = new SurfaceFilterAttributes;

    return retval;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceFilterAttributes::SelectAll()
{
    Select(0, (void *)&limitsMode);
    Select(1, (void *)&minFlag);
    Select(2, (void *)&maxFlag);
    Select(3, (void *)&scaling);
    Select(4, (void *)&skewFactor);
    Select(5, (void *)&min);
    Select(6, (void *)&max);
    Select(7, (void *)&variable);
    Select(8, (void *)&useXYLimits);
    Select(9, (void *)&generateNodalOutput);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfaceFilterAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceFilterAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SurfaceFilterAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SurfaceFilterAttributes.
    DataNode *node = new DataNode("SurfaceFilterAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("limitsMode", LimitsMode_ToString(limitsMode)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaling", Scaling_ToString(scaling)));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("skewFactor", skewFactor));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useXYLimits", useXYLimits));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("generateNodalOutput", generateNodalOutput));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceFilterAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SurfaceFilterAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("limitsMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetLimitsMode(LimitsMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LimitsMode value;
            if(LimitsMode_FromString(node->AsString(), value))
                SetLimitsMode(value);
        }
    }
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetScaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetScaling(value);
        }
    }
    if((node = searchNode->GetNode("skewFactor")) != 0)
        SetSkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
    if((node = searchNode->GetNode("useXYLimits")) != 0)
        SetUseXYLimits(node->AsBool());
    if((node = searchNode->GetNode("generateNodalOutput")) != 0)
        SetGenerateNodalOutput(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfaceFilterAttributes::SetLimitsMode(SurfaceFilterAttributes::LimitsMode limitsMode_)
{
    limitsMode = limitsMode_;
    Select(0, (void *)&limitsMode);
}

void
SurfaceFilterAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(1, (void *)&minFlag);
}

void
SurfaceFilterAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(2, (void *)&maxFlag);
}

void
SurfaceFilterAttributes::SetScaling(SurfaceFilterAttributes::Scaling scaling_)
{
    scaling = scaling_;
    Select(3, (void *)&scaling);
}

void
SurfaceFilterAttributes::SetSkewFactor(double skewFactor_)
{
    skewFactor = skewFactor_;
    Select(4, (void *)&skewFactor);
}

void
SurfaceFilterAttributes::SetMin(double min_)
{
    min = min_;
    Select(5, (void *)&min);
}

void
SurfaceFilterAttributes::SetMax(double max_)
{
    max = max_;
    Select(6, (void *)&max);
}

void
SurfaceFilterAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(7, (void *)&variable);
}

void
SurfaceFilterAttributes::SetUseXYLimits(bool useXYLimits_)
{
    useXYLimits = useXYLimits_;
    Select(8, (void *)&useXYLimits);
}

void
SurfaceFilterAttributes::SetGenerateNodalOutput(bool generateNodalOutput_)
{
    generateNodalOutput = generateNodalOutput_;
    Select(9, (void *)&generateNodalOutput);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

SurfaceFilterAttributes::LimitsMode
SurfaceFilterAttributes::GetLimitsMode() const
{
    return LimitsMode(limitsMode);
}

bool
SurfaceFilterAttributes::GetMinFlag() const
{
    return minFlag;
}

bool
SurfaceFilterAttributes::GetMaxFlag() const
{
    return maxFlag;
}

SurfaceFilterAttributes::Scaling
SurfaceFilterAttributes::GetScaling() const
{
    return Scaling(scaling);
}

double
SurfaceFilterAttributes::GetSkewFactor() const
{
    return skewFactor;
}

double
SurfaceFilterAttributes::GetMin() const
{
    return min;
}

double
SurfaceFilterAttributes::GetMax() const
{
    return max;
}

const std::string &
SurfaceFilterAttributes::GetVariable() const
{
    return variable;
}

std::string &
SurfaceFilterAttributes::GetVariable()
{
    return variable;
}

bool
SurfaceFilterAttributes::GetUseXYLimits() const
{
    return useXYLimits;
}

bool
SurfaceFilterAttributes::GetGenerateNodalOutput() const
{
    return generateNodalOutput;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfaceFilterAttributes::SelectVariable()
{
    Select(7, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfaceFilterAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfaceFilterAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "LimitsMode";
        case 1:  return "Use min";
        case 2:  return "Use max";
        case 3:  return "Scale";
        case 4:  return "Skew factor";
        case 5:  return "Min";
        case 6:  return "Max";
        case 7:  return "Elevate by Variable";
        case 8:  return "Use XY Limits";
        case 9:  return "Generate Nodal Output";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SurfaceFilterAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_enum;
        case 4:  return FieldType_double;
        case 5:  return FieldType_double;
        case 6:  return FieldType_double;
        case 7:  return FieldType_variablename;
        case 8:  return FieldType_bool;
        case 9:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfaceFilterAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "enum";
        case 4:  return "double";
        case 5:  return "double";
        case 6:  return "double";
        case 7:  return "variablename";
        case 8:  return "bool";
        case 9:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:14:58 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceFilterAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SurfaceFilterAttributes &obj = *((const SurfaceFilterAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (limitsMode == obj.limitsMode);
        }
        break;
    case 1:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case 2:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case 3:
        {  // new scope
        retval = (scaling == obj.scaling);
        }
        break;
    case 4:
        {  // new scope
        retval = (skewFactor == obj.skewFactor);
        }
        break;
    case 5:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case 6:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case 7:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    case 8:
        {  // new scope
        retval = (useXYLimits == obj.useXYLimits);
        }
        break;
    case 9:
        {  // new scope
        retval = (generateNodalOutput == obj.generateNodalOutput);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

