#include <StatusAttributes.h>
#include <DataNode.h>

const int StatusAttributes::DEFAULT_DURATION = 5000;

// ****************************************************************************
// Method: StatusAttributes::StatusAttributes
//
// Purpose: 
//   Constructor for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes::StatusAttributes() : AttributeSubject("sbsiisiii")
{
    sender = "viewer";
    clearStatus = false;
    percent = 0;
    currentStage = 1;
    currentStageName = "stage1";
    maxStage = 1;
    messageType = 0;
    duration = 5000;
}

// ****************************************************************************
// Method: StatusAttributes::StatusAttributes
//
// Purpose: 
//   Copy constructor for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes::StatusAttributes(const StatusAttributes &obj) : AttributeSubject("sbsiisiii")
{
    sender = obj.sender;
    clearStatus = obj.clearStatus;
    statusMessage = obj.statusMessage;
    percent = obj.percent;
    currentStage = obj.currentStage;
    currentStageName = obj.currentStageName;
    maxStage = obj.maxStage;
    messageType = obj.messageType;
    duration = obj.duration;

    SelectAll();
}

// ****************************************************************************
// Method: StatusAttributes::~StatusAttributes
//
// Purpose: 
//   Destructor for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes::~StatusAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: StatusAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
StatusAttributes::operator = (const StatusAttributes &obj)
{
    sender = obj.sender;
    clearStatus = obj.clearStatus;
    statusMessage = obj.statusMessage;
    percent = obj.percent;
    currentStage = obj.currentStage;
    currentStageName = obj.currentStageName;
    maxStage = obj.maxStage;
    messageType = obj.messageType;
    duration = obj.duration;

    SelectAll();
}

// ****************************************************************************
// Method: StatusAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::operator == (const StatusAttributes &obj) const
{
    // Create the return value
    return ((sender == obj.sender) &&
            (clearStatus == obj.clearStatus) &&
            (statusMessage == obj.statusMessage) &&
            (percent == obj.percent) &&
            (currentStage == obj.currentStage) &&
            (currentStageName == obj.currentStageName) &&
            (maxStage == obj.maxStage) &&
            (messageType == obj.messageType) &&
            (duration == obj.duration));
}

// ****************************************************************************
// Method: StatusAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::operator != (const StatusAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: StatusAttributes::TypeName
//
// Purpose: 
//   Type name method for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
StatusAttributes::TypeName() const
{
    return "StatusAttributes";
}

// ****************************************************************************
// Method: StatusAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const StatusAttributes *tmp = (const StatusAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: StatusAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
StatusAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new StatusAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: StatusAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
StatusAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new StatusAttributes(*this);
    else
        retval = new StatusAttributes;

    return retval;
}

// ****************************************************************************
// Method: StatusAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
StatusAttributes::SelectAll()
{
    Select(0, (void *)&sender);
    Select(1, (void *)&clearStatus);
    Select(2, (void *)&statusMessage);
    Select(3, (void *)&percent);
    Select(4, (void *)&currentStage);
    Select(5, (void *)&currentStageName);
    Select(6, (void *)&maxStage);
    Select(7, (void *)&messageType);
    Select(8, (void *)&duration);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: StatusAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    StatusAttributes defaultObject;
    bool addToParent = false;
    // Create a node for StatusAttributes.
    DataNode *node = new DataNode("StatusAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("sender", sender));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("clearStatus", clearStatus));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("statusMessage", statusMessage));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("percent", percent));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("currentStage", currentStage));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("currentStageName", currentStageName));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxStage", maxStage));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("messageType", messageType));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("duration", duration));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: StatusAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
StatusAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("StatusAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("sender")) != 0)
        SetSender(node->AsString());
    if((node = searchNode->GetNode("clearStatus")) != 0)
        SetClearStatus(node->AsBool());
    if((node = searchNode->GetNode("statusMessage")) != 0)
        SetStatusMessage(node->AsString());
    if((node = searchNode->GetNode("percent")) != 0)
        SetPercent(node->AsInt());
    if((node = searchNode->GetNode("currentStage")) != 0)
        SetCurrentStage(node->AsInt());
    if((node = searchNode->GetNode("currentStageName")) != 0)
        SetCurrentStageName(node->AsString());
    if((node = searchNode->GetNode("maxStage")) != 0)
        SetMaxStage(node->AsInt());
    if((node = searchNode->GetNode("messageType")) != 0)
        SetMessageType(node->AsInt());
    if((node = searchNode->GetNode("duration")) != 0)
        SetDuration(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
StatusAttributes::SetSender(const std::string &sender_)
{
    sender = sender_;
    Select(0, (void *)&sender);
}

void
StatusAttributes::SetClearStatus(bool clearStatus_)
{
    clearStatus = clearStatus_;
    Select(1, (void *)&clearStatus);
}

void
StatusAttributes::SetStatusMessage(const std::string &statusMessage_)
{
    statusMessage = statusMessage_;
    Select(2, (void *)&statusMessage);
}

void
StatusAttributes::SetPercent(int percent_)
{
    percent = percent_;
    Select(3, (void *)&percent);
}

void
StatusAttributes::SetCurrentStage(int currentStage_)
{
    currentStage = currentStage_;
    Select(4, (void *)&currentStage);
}

void
StatusAttributes::SetCurrentStageName(const std::string &currentStageName_)
{
    currentStageName = currentStageName_;
    Select(5, (void *)&currentStageName);
}

void
StatusAttributes::SetMaxStage(int maxStage_)
{
    maxStage = maxStage_;
    Select(6, (void *)&maxStage);
}

void
StatusAttributes::SetMessageType(int messageType_)
{
    messageType = messageType_;
    Select(7, (void *)&messageType);
}

void
StatusAttributes::SetDuration(int duration_)
{
    duration = duration_;
    Select(8, (void *)&duration);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
StatusAttributes::GetSender() const
{
    return sender;
}

std::string &
StatusAttributes::GetSender()
{
    return sender;
}

bool
StatusAttributes::GetClearStatus() const
{
    return clearStatus;
}

const std::string &
StatusAttributes::GetStatusMessage() const
{
    return statusMessage;
}

std::string &
StatusAttributes::GetStatusMessage()
{
    return statusMessage;
}

int
StatusAttributes::GetPercent() const
{
    return percent;
}

int
StatusAttributes::GetCurrentStage() const
{
    return currentStage;
}

const std::string &
StatusAttributes::GetCurrentStageName() const
{
    return currentStageName;
}

std::string &
StatusAttributes::GetCurrentStageName()
{
    return currentStageName;
}

int
StatusAttributes::GetMaxStage() const
{
    return maxStage;
}

int
StatusAttributes::GetMessageType() const
{
    return messageType;
}

int
StatusAttributes::GetDuration() const
{
    return duration;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
StatusAttributes::SelectSender()
{
    Select(0, (void *)&sender);
}

void
StatusAttributes::SelectStatusMessage()
{
    Select(2, (void *)&statusMessage);
}

void
StatusAttributes::SelectCurrentStageName()
{
    Select(5, (void *)&currentStageName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: StatusAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
StatusAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "sender";
        case 1:  return "clearStatus";
        case 2:  return "statusMessage";
        case 3:  return "percent";
        case 4:  return "currentStage";
        case 5:  return "currentStageName";
        case 6:  return "maxStage";
        case 7:  return "messageType";
        case 8:  return "duration";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: StatusAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
StatusAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_string;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_string;
        case 3:  return FieldType_int;
        case 4:  return FieldType_int;
        case 5:  return FieldType_string;
        case 6:  return FieldType_int;
        case 7:  return FieldType_int;
        case 8:  return FieldType_int;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: StatusAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
StatusAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "string";
        case 1:  return "bool";
        case 2:  return "string";
        case 3:  return "int";
        case 4:  return "int";
        case 5:  return "string";
        case 6:  return "int";
        case 7:  return "int";
        case 8:  return "int";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: StatusAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Nov 1 17:08:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const StatusAttributes &obj = *((const StatusAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (sender == obj.sender);
        }
        break;
    case 1:
        {  // new scope
        retval = (clearStatus == obj.clearStatus);
        }
        break;
    case 2:
        {  // new scope
        retval = (statusMessage == obj.statusMessage);
        }
        break;
    case 3:
        {  // new scope
        retval = (percent == obj.percent);
        }
        break;
    case 4:
        {  // new scope
        retval = (currentStage == obj.currentStage);
        }
        break;
    case 5:
        {  // new scope
        retval = (currentStageName == obj.currentStageName);
        }
        break;
    case 6:
        {  // new scope
        retval = (maxStage == obj.maxStage);
        }
        break;
    case 7:
        {  // new scope
        retval = (messageType == obj.messageType);
        }
        break;
    case 8:
        {  // new scope
        retval = (duration == obj.duration);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

