#include <SphereAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SphereAttributes::SphereAttributes
//
// Purpose: 
//   Constructor for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes::SphereAttributes() : AttributeSubject("Dd")
{
    origin[0] = 0;
    origin[1] = 0;
    origin[2] = 0;
    radius = 1;
}

// ****************************************************************************
// Method: SphereAttributes::SphereAttributes
//
// Purpose: 
//   Copy constructor for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes::SphereAttributes(const SphereAttributes &obj) : AttributeSubject("Dd")
{
    origin[0] = obj.origin[0];
    origin[1] = obj.origin[1];
    origin[2] = obj.origin[2];

    radius = obj.radius;

    SelectAll();
}

// ****************************************************************************
// Method: SphereAttributes::~SphereAttributes
//
// Purpose: 
//   Destructor for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes::~SphereAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SphereAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SphereAttributes::operator = (const SphereAttributes &obj)
{
    origin[0] = obj.origin[0];
    origin[1] = obj.origin[1];
    origin[2] = obj.origin[2];

    radius = obj.radius;

    SelectAll();
}

// ****************************************************************************
// Method: SphereAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::operator == (const SphereAttributes &obj) const
{
    int i;

    // Compare the origin arrays.
    bool origin_equal = true;
    for(i = 0; i < 3 && origin_equal; ++i)
        origin_equal = (origin[i] == obj.origin[i]);

    // Create the return value
    return (origin_equal &&
            (radius == obj.radius));
}

// ****************************************************************************
// Method: SphereAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::operator != (const SphereAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SphereAttributes::TypeName
//
// Purpose: 
//   Type name method for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
SphereAttributes::TypeName() const
{
    return "SphereAttributes";
}

// ****************************************************************************
// Method: SphereAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SphereAttributes *tmp = (const SphereAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SphereAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SphereAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SphereAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SphereAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SphereAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SphereAttributes(*this);
    else
        retval = new SphereAttributes;

    return retval;
}

// ****************************************************************************
// Method: SphereAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SphereAttributes::SelectAll()
{
    Select(0, (void *)origin, 3);
    Select(1, (void *)&radius);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SphereAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SphereAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SphereAttributes.
    DataNode *node = new DataNode("SphereAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("origin", origin, 3));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radius", radius));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SphereAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SphereAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SphereAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("origin")) != 0)
        SetOrigin(node->AsDoubleArray());
    if((node = searchNode->GetNode("radius")) != 0)
        SetRadius(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SphereAttributes::SetOrigin(const double *origin_)
{
    origin[0] = origin_[0];
    origin[1] = origin_[1];
    origin[2] = origin_[2];
    Select(0, (void *)origin, 3);
}

void
SphereAttributes::SetRadius(double radius_)
{
    radius = radius_;
    Select(1, (void *)&radius);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
SphereAttributes::GetOrigin() const
{
    return origin;
}

double *
SphereAttributes::GetOrigin()
{
    return origin;
}

double
SphereAttributes::GetRadius() const
{
    return radius;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SphereAttributes::SelectOrigin()
{
    Select(0, (void *)origin, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SphereAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
SphereAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "origin";
        case 1:  return "radius";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SphereAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SphereAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_doubleArray;
        case 1:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SphereAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
SphereAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "doubleArray";
        case 1:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SphereAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:33 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const SphereAttributes &obj = *((const SphereAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        // Compare the origin arrays.
        bool origin_equal = true;
        for(i = 0; i < 3 && origin_equal; ++i)
            origin_equal = (origin[i] == obj.origin[i]);

        retval = origin_equal;
        }
        break;
    case 1:
        {  // new scope
        retval = (radius == obj.radius);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

