#include <SimulationCommand.h>
#include <DataNode.h>

//
// Enum conversion methods for SimulationCommand::Command
//

static const char *Command_strings[] = {
"NoCommand", "Pause", "Step", 
"Run"};

std::string
SimulationCommand::Command_ToString(SimulationCommand::Command t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return Command_strings[index];
}

std::string
SimulationCommand::Command_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return Command_strings[index];
}

bool
SimulationCommand::Command_FromString(const std::string &s, SimulationCommand::Command &val)
{
    val = SimulationCommand::NoCommand;
    for(int i = 0; i < 4; ++i)
    {
        if(s == Command_strings[i])
        {
            val = (Command)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: SimulationCommand::SimulationCommand
//
// Purpose: 
//   Constructor for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand::SimulationCommand() : AttributeSubject("i")
{
    commandType = NoCommand;
}

// ****************************************************************************
// Method: SimulationCommand::SimulationCommand
//
// Purpose: 
//   Copy constructor for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand::SimulationCommand(const SimulationCommand &obj) : AttributeSubject("i")
{
    commandType = obj.commandType;

    SelectAll();
}

// ****************************************************************************
// Method: SimulationCommand::~SimulationCommand
//
// Purpose: 
//   Destructor for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand::~SimulationCommand()
{
    // nothing here
}

// ****************************************************************************
// Method: SimulationCommand::operator = 
//
// Purpose: 
//   Assignment operator for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand& 
SimulationCommand::operator = (const SimulationCommand &obj)
{
    if (this == &obj) return *this;
    commandType = obj.commandType;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: SimulationCommand::operator == 
//
// Purpose: 
//   Comparison operator == for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationCommand::operator == (const SimulationCommand &obj) const
{
    // Create the return value
    return ((commandType == obj.commandType));
}

// ****************************************************************************
// Method: SimulationCommand::operator != 
//
// Purpose: 
//   Comparison operator != for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationCommand::operator != (const SimulationCommand &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SimulationCommand::TypeName
//
// Purpose: 
//   Type name method for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
SimulationCommand::TypeName() const
{
    return "SimulationCommand";
}

// ****************************************************************************
// Method: SimulationCommand::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationCommand::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SimulationCommand *tmp = (const SimulationCommand *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SimulationCommand::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SimulationCommand::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SimulationCommand(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SimulationCommand::NewInstance
//
// Purpose: 
//   NewInstance method for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SimulationCommand::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SimulationCommand(*this);
    else
        retval = new SimulationCommand;

    return retval;
}

// ****************************************************************************
// Method: SimulationCommand::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
SimulationCommand::SelectAll()
{
    Select(0, (void *)&commandType);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SimulationCommand::SetCommandType(SimulationCommand::Command commandType_)
{
    commandType = commandType_;
    Select(0, (void *)&commandType);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

SimulationCommand::Command
SimulationCommand::GetCommandType() const
{
    return Command(commandType);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SimulationCommand::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
SimulationCommand::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Command Type";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SimulationCommand::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SimulationCommand::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SimulationCommand::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
SimulationCommand::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SimulationCommand::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 11:32:19 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationCommand::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SimulationCommand &obj = *((const SimulationCommand*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (commandType == obj.commandType);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

