#ifndef SAVEWINDOWATTRIBUTES_H
#define SAVEWINDOWATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: SaveWindowAttributes
//
// Purpose:
//    This class contains the attributes used for saving windows.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 12 11:41:11 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

class STATE_API SaveWindowAttributes : public AttributeSubject
{
public:
    enum FileFormat
    {
        BMP,
        CURVE,
        JPEG,
        OBJ,
        PNG,
        POSTSCRIPT,
        PPM,
        RGB,
        STL,
        TIFF,
        ULTRA,
        VTK
    };
    enum CompressionType
    {
        None,
        PackBits,
        Jpeg,
        Deflate
    };

    SaveWindowAttributes();
    SaveWindowAttributes(const SaveWindowAttributes &obj);
    virtual ~SaveWindowAttributes();

    virtual void operator = (const SaveWindowAttributes &obj);
    virtual bool operator == (const SaveWindowAttributes &obj) const;
    virtual bool operator != (const SaveWindowAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectOutputDirectory();
    void SelectFileName();
    void SelectLastRealFilename();

    // Property setting methods
    void SetOutputToCurrentDirectory(bool outputToCurrentDirectory_);
    void SetOutputDirectory(const std::string &outputDirectory_);
    void SetFileName(const std::string &fileName_);
    void SetFamily(bool family_);
    void SetFormat(FileFormat format_);
    void SetMaintainAspect(bool maintainAspect_);
    void SetWidth(int width_);
    void SetHeight(int height_);
    void SetScreenCapture(bool screenCapture_);
    void SetSaveTiled(bool saveTiled_);
    void SetQuality(int quality_);
    void SetProgressive(bool progressive_);
    void SetBinary(bool binary_);
    void SetLastRealFilename(const std::string &lastRealFilename_);
    void SetStereo(bool stereo_);
    void SetCompression(CompressionType compression_);

    // Property getting methods
    bool              GetOutputToCurrentDirectory() const;
    const std::string &GetOutputDirectory() const;
          std::string &GetOutputDirectory();
    const std::string &GetFileName() const;
          std::string &GetFileName();
    bool              GetFamily() const;
    FileFormat        GetFormat() const;
    bool              GetMaintainAspect() const;
    int               GetWidth() const;
    int               GetHeight() const;
    bool              GetScreenCapture() const;
    bool              GetSaveTiled() const;
    int               GetQuality() const;
    bool              GetProgressive() const;
    bool              GetBinary() const;
    const std::string &GetLastRealFilename() const;
          std::string &GetLastRealFilename();
    bool              GetStereo() const;
    CompressionType   GetCompression() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string FileFormat_ToString(FileFormat);
    static bool FileFormat_FromString(const std::string &, FileFormat &);
protected:
    static std::string FileFormat_ToString(int);
public:
    static std::string CompressionType_ToString(CompressionType);
    static bool CompressionType_FromString(const std::string &, CompressionType &);
protected:
    static std::string CompressionType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    bool CurrentFormatIsImageFormat(void);
private:
    bool        outputToCurrentDirectory;
    std::string outputDirectory;
    std::string fileName;
    bool        family;
    int         format;
    bool        maintainAspect;
    int         width;
    int         height;
    bool        screenCapture;
    bool        saveTiled;
    int         quality;
    bool        progressive;
    bool        binary;
    std::string lastRealFilename;
    bool        stereo;
    int         compression;
};

#endif
