#ifndef SILATTRIBUTES_H
#define SILATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>
class NamespaceAttributes;
class SILMatrixAttributes;

// ****************************************************************************
// Class: SILAttributes
//
// Purpose:
//    This class contains the information needed to represent a SIL.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API SILAttributes : public AttributeSubject
{
public:
    SILAttributes();
    SILAttributes(const SILAttributes &obj);
    virtual ~SILAttributes();

    virtual void operator = (const SILAttributes &obj);
    virtual bool operator == (const SILAttributes &obj) const;
    virtual bool operator != (const SILAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectSetNames();
    void SelectSetIds();
    void SelectIsWhole();
    void SelectCategory();
    void SelectRole();
    void SelectSuperset();
    void SelectNspace();
    void SelectMatrices();

    // Property setting methods
    void SetNSets(int nSets_);
    void SetSetNames(const stringVector &setNames_);
    void SetSetIds(const intVector &setIds_);
    void SetIsWhole(const intVector &isWhole_);
    void SetNCollections(int nCollections_);
    void SetCategory(const stringVector &category_);
    void SetRole(const intVector &role_);
    void SetSuperset(const intVector &superset_);
    void SetNspace(const AttributeGroupVector &nspace_);
    void SetMatrices(const AttributeGroupVector &matrices_);

    // Property getting methods
    int                GetNSets() const;
    const stringVector &GetSetNames() const;
          stringVector &GetSetNames();
    const intVector    &GetSetIds() const;
          intVector    &GetSetIds();
    const intVector    &GetIsWhole() const;
          intVector    &GetIsWhole();
    int                GetNCollections() const;
    const stringVector &GetCategory() const;
          stringVector &GetCategory();
    const intVector    &GetRole() const;
          intVector    &GetRole();
    const intVector    &GetSuperset() const;
          intVector    &GetSuperset();
    const AttributeGroupVector &GetNspace() const;
          AttributeGroupVector &GetNspace();
    const AttributeGroupVector &GetMatrices() const;
          AttributeGroupVector &GetMatrices();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddNamespaceAttributes(const NamespaceAttributes &);
    void ClearNamespaceAttributess();
    void RemoveNamespaceAttributes(int i);
    int  GetNumNamespaceAttributess() const;
    NamespaceAttributes &GetNamespaceAttributes(int i);
    const NamespaceAttributes &GetNamespaceAttributes(int i) const;

    void AddSILMatrixAttributes(const SILMatrixAttributes &);
    void ClearSILMatrixAttributess();
    void RemoveSILMatrixAttributes(int i);
    int  GetNumSILMatrixAttributess() const;
    SILMatrixAttributes &GetSILMatrixAttributes(int i);
    const SILMatrixAttributes &GetSILMatrixAttributes(int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    int                  nSets;
    stringVector         setNames;
    intVector            setIds;
    intVector            isWhole;
    int                  nCollections;
    stringVector         category;
    intVector            role;
    intVector            superset;
    AttributeGroupVector nspace;
    AttributeGroupVector matrices;
};

#endif
