#include <SILAttributes.h>
#include <DataNode.h>
#include <NamespaceAttributes.h>
#include <SILMatrixAttributes.h>

// ****************************************************************************
// Method: SILAttributes::SILAttributes
//
// Purpose: 
//   Constructor for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SILAttributes::SILAttributes() : AttributeSubject("is*i*i*is*i*i*a*a*")
{
    nSets = 0;
    nCollections = 0;
}

// ****************************************************************************
// Method: SILAttributes::SILAttributes
//
// Purpose: 
//   Copy constructor for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SILAttributes::SILAttributes(const SILAttributes &obj) : AttributeSubject("is*i*i*is*i*i*a*a*")
{
    AttributeGroupVector::const_iterator pos;

    nSets = obj.nSets;
    setNames = obj.setNames;
    setIds = obj.setIds;
    isWhole = obj.isWhole;
    nCollections = obj.nCollections;
    category = obj.category;
    role = obj.role;
    superset = obj.superset;
    // *** Copy the nspace field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = nspace.begin(); pos != nspace.end(); ++pos)
        delete *pos;
    nspace.clear();
    if(obj.nspace.size() > 0)
        nspace.reserve(obj.nspace.size());
    // Duplicate the nspace from obj.
    for(pos = obj.nspace.begin(); pos != obj.nspace.end(); ++pos)
    {
        NamespaceAttributes *oldNamespaceAttributes = (NamespaceAttributes *)(*pos);
        NamespaceAttributes *newNamespaceAttributes = new NamespaceAttributes(*oldNamespaceAttributes);
        nspace.push_back(newNamespaceAttributes);
    }

    // *** Copy the matrices field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = matrices.begin(); pos != matrices.end(); ++pos)
        delete *pos;
    matrices.clear();
    if(obj.matrices.size() > 0)
        matrices.reserve(obj.matrices.size());
    // Duplicate the matrices from obj.
    for(pos = obj.matrices.begin(); pos != obj.matrices.end(); ++pos)
    {
        SILMatrixAttributes *oldSILMatrixAttributes = (SILMatrixAttributes *)(*pos);
        SILMatrixAttributes *newSILMatrixAttributes = new SILMatrixAttributes(*oldSILMatrixAttributes);
        matrices.push_back(newSILMatrixAttributes);
    }


    SelectAll();
}

// ****************************************************************************
// Method: SILAttributes::~SILAttributes
//
// Purpose: 
//   Destructor for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SILAttributes::~SILAttributes()
{
    AttributeGroupVector::iterator pos;

    // Destroy the nspace field.
    for(pos = nspace.begin(); pos != nspace.end(); ++pos)
        delete *pos;
    // Destroy the matrices field.
    for(pos = matrices.begin(); pos != matrices.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: SILAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::operator = (const SILAttributes &obj)
{
    AttributeGroupVector::const_iterator pos;

    nSets = obj.nSets;
    setNames = obj.setNames;
    setIds = obj.setIds;
    isWhole = obj.isWhole;
    nCollections = obj.nCollections;
    category = obj.category;
    role = obj.role;
    superset = obj.superset;
    // *** Copy the nspace field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = nspace.begin(); pos != nspace.end(); ++pos)
        delete *pos;
    nspace.clear();
    if(obj.nspace.size() > 0)
        nspace.reserve(obj.nspace.size());
    // Duplicate the nspace from obj.
    for(pos = obj.nspace.begin(); pos != obj.nspace.end(); ++pos)
    {
        NamespaceAttributes *oldNamespaceAttributes = (NamespaceAttributes *)(*pos);
        NamespaceAttributes *newNamespaceAttributes = new NamespaceAttributes(*oldNamespaceAttributes);
        nspace.push_back(newNamespaceAttributes);
    }

    // *** Copy the matrices field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = matrices.begin(); pos != matrices.end(); ++pos)
        delete *pos;
    matrices.clear();
    if(obj.matrices.size() > 0)
        matrices.reserve(obj.matrices.size());
    // Duplicate the matrices from obj.
    for(pos = obj.matrices.begin(); pos != obj.matrices.end(); ++pos)
    {
        SILMatrixAttributes *oldSILMatrixAttributes = (SILMatrixAttributes *)(*pos);
        SILMatrixAttributes *newSILMatrixAttributes = new SILMatrixAttributes(*oldSILMatrixAttributes);
        matrices.push_back(newSILMatrixAttributes);
    }


    SelectAll();
}

// ****************************************************************************
// Method: SILAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::operator == (const SILAttributes &obj) const
{
    int i;

    bool nspace_equal = (obj.nspace.size() == nspace.size());
    for(i = 0; (i < nspace.size()) && nspace_equal; ++i)
    {
        // Make references to NamespaceAttributes from AttributeGroup *.
        const NamespaceAttributes &nspace1 = *((const NamespaceAttributes *)(nspace[i]));
        const NamespaceAttributes &nspace2 = *((const NamespaceAttributes *)(obj.nspace[i]));
        nspace_equal = (nspace1 == nspace2);
    }

    bool matrices_equal = (obj.matrices.size() == matrices.size());
    for(i = 0; (i < matrices.size()) && matrices_equal; ++i)
    {
        // Make references to SILMatrixAttributes from AttributeGroup *.
        const SILMatrixAttributes &matrices1 = *((const SILMatrixAttributes *)(matrices[i]));
        const SILMatrixAttributes &matrices2 = *((const SILMatrixAttributes *)(obj.matrices[i]));
        matrices_equal = (matrices1 == matrices2);
    }

    // Create the return value
    return ((nSets == obj.nSets) &&
            (setNames == obj.setNames) &&
            (setIds == obj.setIds) &&
            (isWhole == obj.isWhole) &&
            (nCollections == obj.nCollections) &&
            (category == obj.category) &&
            (role == obj.role) &&
            (superset == obj.superset) &&
            nspace_equal &&
            matrices_equal);
}

// ****************************************************************************
// Method: SILAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::operator != (const SILAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SILAttributes::TypeName
//
// Purpose: 
//   Type name method for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
SILAttributes::TypeName() const
{
    return "SILAttributes";
}

// ****************************************************************************
// Method: SILAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SILAttributes *tmp = (const SILAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SILAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SILAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SILAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SILAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SILAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SILAttributes(*this);
    else
        retval = new SILAttributes;

    return retval;
}

// ****************************************************************************
// Method: SILAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::SelectAll()
{
    Select(0, (void *)&nSets);
    Select(1, (void *)&setNames);
    Select(2, (void *)&setIds);
    Select(3, (void *)&isWhole);
    Select(4, (void *)&nCollections);
    Select(5, (void *)&category);
    Select(6, (void *)&role);
    Select(7, (void *)&superset);
    Select(8, (void *)&nspace);
    Select(9, (void *)&matrices);
}

// ****************************************************************************
// Method: SILAttributes::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
SILAttributes::CreateSubAttributeGroup(int attr_id)
{
    AttributeGroup *retval = 0;
    switch(attr_id)
    {
    case 8:
        retval = new NamespaceAttributes;
        break;
    case 9:
        retval = new SILMatrixAttributes;
        break;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SILAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SILAttributes.
    DataNode *node = new DataNode("SILAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nSets", nSets));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("setNames", setNames));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("setIds", setIds));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("isWhole", isWhole));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nCollections", nCollections));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("category", category));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("role", role));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("superset", superset));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        for(int i = 0; i < nspace.size(); ++i)
            nspace[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        for(int i = 0; i < matrices.size(); ++i)
            matrices[i]->CreateNode(node, completeSave, true);
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SILAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SILAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    if((node = searchNode->GetNode("nSets")) != 0)
        SetNSets(node->AsInt());
    if((node = searchNode->GetNode("setNames")) != 0)
        SetSetNames(node->AsStringVector());
    if((node = searchNode->GetNode("setIds")) != 0)
        SetSetIds(node->AsIntVector());
    if((node = searchNode->GetNode("isWhole")) != 0)
        SetIsWhole(node->AsIntVector());
    if((node = searchNode->GetNode("nCollections")) != 0)
        SetNCollections(node->AsInt());
    if((node = searchNode->GetNode("category")) != 0)
        SetCategory(node->AsStringVector());
    if((node = searchNode->GetNode("role")) != 0)
        SetRole(node->AsIntVector());
    if((node = searchNode->GetNode("superset")) != 0)
        SetSuperset(node->AsIntVector());
    // Clear all the NamespaceAttributess.
    ClearNamespaceAttributess();

    // Go through all of the children and construct a new
    // NamespaceAttributes for each one of them.
    children = searchNode->GetChildren();
    for(i = 0; i < searchNode->GetNumChildren(); ++i)
    {
        if(children[i]->GetKey() == std::string("NamespaceAttributes"))
        {
            NamespaceAttributes temp;
            temp.SetFromNode(children[i]);
            AddNamespaceAttributes(temp);
        }
    }

    // Clear all the SILMatrixAttributess.
    ClearSILMatrixAttributess();

    // Go through all of the children and construct a new
    // SILMatrixAttributes for each one of them.
    children = searchNode->GetChildren();
    for(i = 0; i < searchNode->GetNumChildren(); ++i)
    {
        if(children[i]->GetKey() == std::string("SILMatrixAttributes"))
        {
            SILMatrixAttributes temp;
            temp.SetFromNode(children[i]);
            AddSILMatrixAttributes(temp);
        }
    }

}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SILAttributes::SetNSets(int nSets_)
{
    nSets = nSets_;
    Select(0, (void *)&nSets);
}

void
SILAttributes::SetSetNames(const stringVector &setNames_)
{
    setNames = setNames_;
    Select(1, (void *)&setNames);
}

void
SILAttributes::SetSetIds(const intVector &setIds_)
{
    setIds = setIds_;
    Select(2, (void *)&setIds);
}

void
SILAttributes::SetIsWhole(const intVector &isWhole_)
{
    isWhole = isWhole_;
    Select(3, (void *)&isWhole);
}

void
SILAttributes::SetNCollections(int nCollections_)
{
    nCollections = nCollections_;
    Select(4, (void *)&nCollections);
}

void
SILAttributes::SetCategory(const stringVector &category_)
{
    category = category_;
    Select(5, (void *)&category);
}

void
SILAttributes::SetRole(const intVector &role_)
{
    role = role_;
    Select(6, (void *)&role);
}

void
SILAttributes::SetSuperset(const intVector &superset_)
{
    superset = superset_;
    Select(7, (void *)&superset);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
SILAttributes::GetNSets() const
{
    return nSets;
}

const stringVector &
SILAttributes::GetSetNames() const
{
    return setNames;
}

stringVector &
SILAttributes::GetSetNames()
{
    return setNames;
}

const intVector &
SILAttributes::GetSetIds() const
{
    return setIds;
}

intVector &
SILAttributes::GetSetIds()
{
    return setIds;
}

const intVector &
SILAttributes::GetIsWhole() const
{
    return isWhole;
}

intVector &
SILAttributes::GetIsWhole()
{
    return isWhole;
}

int
SILAttributes::GetNCollections() const
{
    return nCollections;
}

const stringVector &
SILAttributes::GetCategory() const
{
    return category;
}

stringVector &
SILAttributes::GetCategory()
{
    return category;
}

const intVector &
SILAttributes::GetRole() const
{
    return role;
}

intVector &
SILAttributes::GetRole()
{
    return role;
}

const intVector &
SILAttributes::GetSuperset() const
{
    return superset;
}

intVector &
SILAttributes::GetSuperset()
{
    return superset;
}

const AttributeGroupVector &
SILAttributes::GetNspace() const
{
    return nspace;
}

AttributeGroupVector &
SILAttributes::GetNspace()
{
    return nspace;
}

const AttributeGroupVector &
SILAttributes::GetMatrices() const
{
    return matrices;
}

AttributeGroupVector &
SILAttributes::GetMatrices()
{
    return matrices;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SILAttributes::SelectSetNames()
{
    Select(1, (void *)&setNames);
}

void
SILAttributes::SelectSetIds()
{
    Select(2, (void *)&setIds);
}

void
SILAttributes::SelectIsWhole()
{
    Select(3, (void *)&isWhole);
}

void
SILAttributes::SelectCategory()
{
    Select(5, (void *)&category);
}

void
SILAttributes::SelectRole()
{
    Select(6, (void *)&role);
}

void
SILAttributes::SelectSuperset()
{
    Select(7, (void *)&superset);
}

void
SILAttributes::SelectNspace()
{
    Select(8, (void *)&nspace);
}

void
SILAttributes::SelectMatrices()
{
    Select(9, (void *)&matrices);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILAttributes::AddNamespaceAttributes
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::AddNamespaceAttributes(const NamespaceAttributes &obj)
{
    NamespaceAttributes *newNamespaceAttributes = new NamespaceAttributes(obj);
    nspace.push_back(newNamespaceAttributes);

    // Indicate that things have changed by selecting it.
    Select(8, (void *)&nspace);
}

// ****************************************************************************
// Method: SILAttributes::ClearNamespaceAttributess
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::ClearNamespaceAttributess()
{
    AttributeGroupVector::iterator pos;

    for(pos = nspace.begin(); pos != nspace.end(); ++pos)
        delete *pos;
    nspace.clear();

    // Indicate that things have changed by selecting the list.
    Select(8, (void *)&nspace);
}

// ****************************************************************************
// Method: SILAttributes::RemoveNamespaceAttributes
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::RemoveNamespaceAttributes(int index)
{
    AttributeGroupVector::iterator pos = nspace.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != nspace.end())
    {
        delete *pos;
        nspace.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(8, (void *)&nspace);
}

// ****************************************************************************
// Method: SILAttributes::GetNumNamespaceAttributess
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
SILAttributes::GetNumNamespaceAttributess() const
{
    return nspace.size();
}

// ****************************************************************************
// Method: SILAttributes::GetNamespaceAttributes
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

NamespaceAttributes &
SILAttributes::GetNamespaceAttributes(int i)
{
    return *((NamespaceAttributes *)nspace[i]);
}

// ****************************************************************************
// Method: SILAttributes::GetNamespaceAttributes
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const NamespaceAttributes &
SILAttributes::GetNamespaceAttributes(int i) const
{
    return *((NamespaceAttributes *)nspace[i]);
}

// ****************************************************************************
// Method: SILAttributes::AddSILMatrixAttributes
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::AddSILMatrixAttributes(const SILMatrixAttributes &obj)
{
    SILMatrixAttributes *newSILMatrixAttributes = new SILMatrixAttributes(obj);
    matrices.push_back(newSILMatrixAttributes);

    // Indicate that things have changed by selecting it.
    Select(9, (void *)&matrices);
}

// ****************************************************************************
// Method: SILAttributes::ClearSILMatrixAttributess
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::ClearSILMatrixAttributess()
{
    AttributeGroupVector::iterator pos;

    for(pos = matrices.begin(); pos != matrices.end(); ++pos)
        delete *pos;
    matrices.clear();

    // Indicate that things have changed by selecting the list.
    Select(9, (void *)&matrices);
}

// ****************************************************************************
// Method: SILAttributes::RemoveSILMatrixAttributes
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::RemoveSILMatrixAttributes(int index)
{
    AttributeGroupVector::iterator pos = matrices.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != matrices.end())
    {
        delete *pos;
        matrices.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(9, (void *)&matrices);
}

// ****************************************************************************
// Method: SILAttributes::GetNumSILMatrixAttributess
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
SILAttributes::GetNumSILMatrixAttributess() const
{
    return matrices.size();
}

// ****************************************************************************
// Method: SILAttributes::GetSILMatrixAttributes
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SILMatrixAttributes &
SILAttributes::GetSILMatrixAttributes(int i)
{
    return *((SILMatrixAttributes *)matrices[i]);
}

// ****************************************************************************
// Method: SILAttributes::GetSILMatrixAttributes
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const SILMatrixAttributes &
SILAttributes::GetSILMatrixAttributes(int i) const
{
    return *((SILMatrixAttributes *)matrices[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
SILAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "nSets";
        case 1:  return "setNames";
        case 2:  return "setIds";
        case 3:  return "isWhole";
        case 4:  return "nCollections";
        case 5:  return "category";
        case 6:  return "role";
        case 7:  return "superset";
        case 8:  return "nspace";
        case 9:  return "matrices";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SILAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SILAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_int;
        case 1:  return FieldType_stringVector;
        case 2:  return FieldType_intVector;
        case 3:  return FieldType_intVector;
        case 4:  return FieldType_int;
        case 5:  return FieldType_stringVector;
        case 6:  return FieldType_intVector;
        case 7:  return FieldType_intVector;
        case 8:  return FieldType_attVector;
        case 9:  return FieldType_attVector;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SILAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
SILAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "int";
        case 1:  return "stringVector";
        case 2:  return "intVector";
        case 3:  return "intVector";
        case 4:  return "int";
        case 5:  return "stringVector";
        case 6:  return "intVector";
        case 7:  return "intVector";
        case 8:  return "attVector";
        case 9:  return "attVector";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SILAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const SILAttributes &obj = *((const SILAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (nSets == obj.nSets);
        }
        break;
    case 1:
        {  // new scope
        retval = (setNames == obj.setNames);
        }
        break;
    case 2:
        {  // new scope
        retval = (setIds == obj.setIds);
        }
        break;
    case 3:
        {  // new scope
        retval = (isWhole == obj.isWhole);
        }
        break;
    case 4:
        {  // new scope
        retval = (nCollections == obj.nCollections);
        }
        break;
    case 5:
        {  // new scope
        retval = (category == obj.category);
        }
        break;
    case 6:
        {  // new scope
        retval = (role == obj.role);
        }
        break;
    case 7:
        {  // new scope
        retval = (superset == obj.superset);
        }
        break;
    case 8:
        {  // new scope
        bool nspace_equal = (obj.nspace.size() == nspace.size());
        for(i = 0; (i < nspace.size()) && nspace_equal; ++i)
        {
            // Make references to NamespaceAttributes from AttributeGroup *.
            const NamespaceAttributes &nspace1 = *((const NamespaceAttributes *)(nspace[i]));
            const NamespaceAttributes &nspace2 = *((const NamespaceAttributes *)(obj.nspace[i]));
            nspace_equal = (nspace1 == nspace2);
        }

        retval = nspace_equal;
        }
        break;
    case 9:
        {  // new scope
        bool matrices_equal = (obj.matrices.size() == matrices.size());
        for(i = 0; (i < matrices.size()) && matrices_equal; ++i)
        {
            // Make references to SILMatrixAttributes from AttributeGroup *.
            const SILMatrixAttributes &matrices1 = *((const SILMatrixAttributes *)(matrices[i]));
            const SILMatrixAttributes &matrices2 = *((const SILMatrixAttributes *)(obj.matrices[i]));
            matrices_equal = (matrices1 == matrices2);
        }

        retval = matrices_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

