#ifndef RESAMPLEATTRIBUTES_H
#define RESAMPLEATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: ResampleAttributes
//
// Purpose:
//    This class contains attributes for the resample operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sat Jan 29 10:54:44 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

class STATE_API ResampleAttributes : public AttributeSubject
{
public:
    ResampleAttributes();
    ResampleAttributes(const ResampleAttributes &obj);
    virtual ~ResampleAttributes();

    virtual ResampleAttributes& operator = (const ResampleAttributes &obj);
    virtual bool operator == (const ResampleAttributes &obj) const;
    virtual bool operator != (const ResampleAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectArbitratorVarName();

    // Property setting methods
    void SetUseTargetVal(bool useTargetVal_);
    void SetTargetVal(int targetVal_);
    void SetWidth(int width_);
    void SetHeight(int height_);
    void SetDepth(int depth_);
    void SetPrefersPowersOfTwo(bool prefersPowersOfTwo_);
    void SetDefaultVal(float defaultVal_);
    void SetUseBounds(bool useBounds_);
    void SetMinX(double minX_);
    void SetMinY(double minY_);
    void SetMinZ(double minZ_);
    void SetMaxX(double maxX_);
    void SetMaxY(double maxY_);
    void SetMaxZ(double maxZ_);
    void SetUseArbitrator(bool useArbitrator_);
    void SetArbitratorLessThan(bool arbitratorLessThan_);
    void SetArbitratorVarName(const std::string &arbitratorVarName_);

    // Property getting methods
    bool              GetUseTargetVal() const;
    int               GetTargetVal() const;
    int               GetWidth() const;
    int               GetHeight() const;
    int               GetDepth() const;
    bool              GetPrefersPowersOfTwo() const;
    float             GetDefaultVal() const;
    bool              GetUseBounds() const;
    double            GetMinX() const;
    double            GetMinY() const;
    double            GetMinZ() const;
    double            GetMaxX() const;
    double            GetMaxY() const;
    double            GetMaxZ() const;
    bool              GetUseArbitrator() const;
    bool              GetArbitratorLessThan() const;
    const std::string &GetArbitratorVarName() const;
          std::string &GetArbitratorVarName();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    bool        useTargetVal;
    int         targetVal;
    int         width;
    int         height;
    int         depth;
    bool        prefersPowersOfTwo;
    float       defaultVal;
    bool        useBounds;
    double      minX;
    double      minY;
    double      minZ;
    double      maxX;
    double      maxY;
    double      maxZ;
    bool        useArbitrator;
    bool        arbitratorLessThan;
    std::string arbitratorVarName;
};

#endif
