#include <RenderingAttributes.h>
#include <DataNode.h>

const int RenderingAttributes::DEFAULT_SCALABLE_AUTO_THRESHOLD = 2000000;

const int RenderingAttributes::DEFAULT_SCALABLE_ACTIVATION_MODE = Auto;

//
// Enum conversion methods for RenderingAttributes::GeometryRepresentation
//

static const char *GeometryRepresentation_strings[] = {
"Surfaces", "Wireframe", "Points"
};

std::string
RenderingAttributes::GeometryRepresentation_ToString(RenderingAttributes::GeometryRepresentation t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return GeometryRepresentation_strings[index];
}

std::string
RenderingAttributes::GeometryRepresentation_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return GeometryRepresentation_strings[index];
}

bool
RenderingAttributes::GeometryRepresentation_FromString(const std::string &s, RenderingAttributes::GeometryRepresentation &val)
{
    val = RenderingAttributes::Surfaces;
    for(int i = 0; i < 3; ++i)
    {
        if(s == GeometryRepresentation_strings[i])
        {
            val = (GeometryRepresentation)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for RenderingAttributes::StereoTypes
//

static const char *StereoTypes_strings[] = {
"RedBlue", "Interlaced", "CrystalEyes"
};

std::string
RenderingAttributes::StereoTypes_ToString(RenderingAttributes::StereoTypes t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return StereoTypes_strings[index];
}

std::string
RenderingAttributes::StereoTypes_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return StereoTypes_strings[index];
}

bool
RenderingAttributes::StereoTypes_FromString(const std::string &s, RenderingAttributes::StereoTypes &val)
{
    val = RenderingAttributes::RedBlue;
    for(int i = 0; i < 3; ++i)
    {
        if(s == StereoTypes_strings[i])
        {
            val = (StereoTypes)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for RenderingAttributes::TriStateMode
//

static const char *TriStateMode_strings[] = {
"Never", "Always", "Auto"
};

std::string
RenderingAttributes::TriStateMode_ToString(RenderingAttributes::TriStateMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return TriStateMode_strings[index];
}

std::string
RenderingAttributes::TriStateMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return TriStateMode_strings[index];
}

bool
RenderingAttributes::TriStateMode_FromString(const std::string &s, RenderingAttributes::TriStateMode &val)
{
    val = RenderingAttributes::Never;
    for(int i = 0; i < 3; ++i)
    {
        if(s == TriStateMode_strings[i])
        {
            val = (TriStateMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: RenderingAttributes::RenderingAttributes
//
// Purpose: 
//   Constructor for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

RenderingAttributes::RenderingAttributes() : AttributeSubject("biibibiibffabd"),
    specularColor(255, 255, 255)
{
    antialiasing = false;
    geometryRepresentation = Surfaces;
    displayListMode = Auto;
    stereoRendering = false;
    stereoType = CrystalEyes;
    notifyForEachRender = false;
    scalableActivationMode = Auto;
    scalableAutoThreshold = 2000000;
    specularFlag = false;
    specularCoeff = 0.6;
    specularPower = 10;
    doShadowing = false;
    shadowStrength = 0.5;
}

// ****************************************************************************
// Method: RenderingAttributes::RenderingAttributes
//
// Purpose: 
//   Copy constructor for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

RenderingAttributes::RenderingAttributes(const RenderingAttributes &obj) : AttributeSubject("biibibiibffabd")
{
    antialiasing = obj.antialiasing;
    geometryRepresentation = obj.geometryRepresentation;
    displayListMode = obj.displayListMode;
    stereoRendering = obj.stereoRendering;
    stereoType = obj.stereoType;
    notifyForEachRender = obj.notifyForEachRender;
    scalableActivationMode = obj.scalableActivationMode;
    scalableAutoThreshold = obj.scalableAutoThreshold;
    specularFlag = obj.specularFlag;
    specularCoeff = obj.specularCoeff;
    specularPower = obj.specularPower;
    specularColor = obj.specularColor;
    doShadowing = obj.doShadowing;
    shadowStrength = obj.shadowStrength;

    SelectAll();
}

// ****************************************************************************
// Method: RenderingAttributes::~RenderingAttributes
//
// Purpose: 
//   Destructor for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

RenderingAttributes::~RenderingAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: RenderingAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
RenderingAttributes::operator = (const RenderingAttributes &obj)
{
    antialiasing = obj.antialiasing;
    geometryRepresentation = obj.geometryRepresentation;
    displayListMode = obj.displayListMode;
    stereoRendering = obj.stereoRendering;
    stereoType = obj.stereoType;
    notifyForEachRender = obj.notifyForEachRender;
    scalableActivationMode = obj.scalableActivationMode;
    scalableAutoThreshold = obj.scalableAutoThreshold;
    specularFlag = obj.specularFlag;
    specularCoeff = obj.specularCoeff;
    specularPower = obj.specularPower;
    specularColor = obj.specularColor;
    doShadowing = obj.doShadowing;
    shadowStrength = obj.shadowStrength;

    SelectAll();
}

// ****************************************************************************
// Method: RenderingAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
RenderingAttributes::operator == (const RenderingAttributes &obj) const
{
    // Create the return value
    return ((antialiasing == obj.antialiasing) &&
            (geometryRepresentation == obj.geometryRepresentation) &&
            (displayListMode == obj.displayListMode) &&
            (stereoRendering == obj.stereoRendering) &&
            (stereoType == obj.stereoType) &&
            (notifyForEachRender == obj.notifyForEachRender) &&
            (scalableActivationMode == obj.scalableActivationMode) &&
            (scalableAutoThreshold == obj.scalableAutoThreshold) &&
            (specularFlag == obj.specularFlag) &&
            (specularCoeff == obj.specularCoeff) &&
            (specularPower == obj.specularPower) &&
            (specularColor == obj.specularColor) &&
            (doShadowing == obj.doShadowing) &&
            (shadowStrength == obj.shadowStrength));
}

// ****************************************************************************
// Method: RenderingAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
RenderingAttributes::operator != (const RenderingAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: RenderingAttributes::TypeName
//
// Purpose: 
//   Type name method for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
RenderingAttributes::TypeName() const
{
    return "RenderingAttributes";
}

// ****************************************************************************
// Method: RenderingAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
RenderingAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const RenderingAttributes *tmp = (const RenderingAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: RenderingAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
RenderingAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new RenderingAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: RenderingAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the RenderingAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
RenderingAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new RenderingAttributes(*this);
    else
        retval = new RenderingAttributes;

    return retval;
}

// ****************************************************************************
// Method: RenderingAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
RenderingAttributes::SelectAll()
{
    Select(0, (void *)&antialiasing);
    Select(1, (void *)&geometryRepresentation);
    Select(2, (void *)&displayListMode);
    Select(3, (void *)&stereoRendering);
    Select(4, (void *)&stereoType);
    Select(5, (void *)&notifyForEachRender);
    Select(6, (void *)&scalableActivationMode);
    Select(7, (void *)&scalableAutoThreshold);
    Select(8, (void *)&specularFlag);
    Select(9, (void *)&specularCoeff);
    Select(10, (void *)&specularPower);
    Select(11, (void *)&specularColor);
    Select(12, (void *)&doShadowing);
    Select(13, (void *)&shadowStrength);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: RenderingAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
RenderingAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    RenderingAttributes defaultObject;
    bool addToParent = false;
    // Create a node for RenderingAttributes.
    DataNode *node = new DataNode("RenderingAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("antialiasing", antialiasing));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("geometryRepresentation", GeometryRepresentation_ToString(geometryRepresentation)));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displayListMode", TriStateMode_ToString(displayListMode)));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stereoRendering", stereoRendering));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stereoType", StereoTypes_ToString(stereoType)));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("notifyForEachRender", notifyForEachRender));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scalableActivationMode", TriStateMode_ToString(scalableActivationMode)));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scalableAutoThreshold", scalableAutoThreshold));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("specularFlag", specularFlag));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("specularCoeff", specularCoeff));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("specularPower", specularPower));
    }

        DataNode *specularColorNode = new DataNode("specularColor");
        if(specularColor.CreateNode(specularColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(specularColorNode);
        }
        else
            delete specularColorNode;
    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("doShadowing", doShadowing));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("shadowStrength", shadowStrength));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: RenderingAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
RenderingAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("RenderingAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("antialiasing")) != 0)
        SetAntialiasing(node->AsBool());
    if((node = searchNode->GetNode("geometryRepresentation")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetGeometryRepresentation(GeometryRepresentation(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            GeometryRepresentation value;
            if(GeometryRepresentation_FromString(node->AsString(), value))
                SetGeometryRepresentation(value);
        }
    }
    if((node = searchNode->GetNode("displayListMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetDisplayListMode(TriStateMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            TriStateMode value;
            if(TriStateMode_FromString(node->AsString(), value))
                SetDisplayListMode(value);
        }
    }
    if((node = searchNode->GetNode("stereoRendering")) != 0)
        SetStereoRendering(node->AsBool());
    if((node = searchNode->GetNode("stereoType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetStereoType(StereoTypes(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            StereoTypes value;
            if(StereoTypes_FromString(node->AsString(), value))
                SetStereoType(value);
        }
    }
    if((node = searchNode->GetNode("notifyForEachRender")) != 0)
        SetNotifyForEachRender(node->AsBool());
    if((node = searchNode->GetNode("scalableActivationMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetScalableActivationMode(TriStateMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            TriStateMode value;
            if(TriStateMode_FromString(node->AsString(), value))
                SetScalableActivationMode(value);
        }
    }
    if((node = searchNode->GetNode("scalableAutoThreshold")) != 0)
        SetScalableAutoThreshold(node->AsInt());
    if((node = searchNode->GetNode("specularFlag")) != 0)
        SetSpecularFlag(node->AsBool());
    if((node = searchNode->GetNode("specularCoeff")) != 0)
        SetSpecularCoeff(node->AsFloat());
    if((node = searchNode->GetNode("specularPower")) != 0)
        SetSpecularPower(node->AsFloat());
    if((node = searchNode->GetNode("specularColor")) != 0)
        specularColor.SetFromNode(node);
    if((node = searchNode->GetNode("doShadowing")) != 0)
        SetDoShadowing(node->AsBool());
    if((node = searchNode->GetNode("shadowStrength")) != 0)
        SetShadowStrength(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
RenderingAttributes::SetAntialiasing(bool antialiasing_)
{
    antialiasing = antialiasing_;
    Select(0, (void *)&antialiasing);
}

void
RenderingAttributes::SetGeometryRepresentation(RenderingAttributes::GeometryRepresentation geometryRepresentation_)
{
    geometryRepresentation = geometryRepresentation_;
    Select(1, (void *)&geometryRepresentation);
}

void
RenderingAttributes::SetDisplayListMode(RenderingAttributes::TriStateMode displayListMode_)
{
    displayListMode = displayListMode_;
    Select(2, (void *)&displayListMode);
}

void
RenderingAttributes::SetStereoRendering(bool stereoRendering_)
{
    stereoRendering = stereoRendering_;
    Select(3, (void *)&stereoRendering);
}

void
RenderingAttributes::SetStereoType(RenderingAttributes::StereoTypes stereoType_)
{
    stereoType = stereoType_;
    Select(4, (void *)&stereoType);
}

void
RenderingAttributes::SetNotifyForEachRender(bool notifyForEachRender_)
{
    notifyForEachRender = notifyForEachRender_;
    Select(5, (void *)&notifyForEachRender);
}

void
RenderingAttributes::SetScalableActivationMode(RenderingAttributes::TriStateMode scalableActivationMode_)
{
    scalableActivationMode = scalableActivationMode_;
    Select(6, (void *)&scalableActivationMode);
}

void
RenderingAttributes::SetScalableAutoThreshold(int scalableAutoThreshold_)
{
    scalableAutoThreshold = scalableAutoThreshold_;
    Select(7, (void *)&scalableAutoThreshold);
}

void
RenderingAttributes::SetSpecularFlag(bool specularFlag_)
{
    specularFlag = specularFlag_;
    Select(8, (void *)&specularFlag);
}

void
RenderingAttributes::SetSpecularCoeff(float specularCoeff_)
{
    specularCoeff = specularCoeff_;
    Select(9, (void *)&specularCoeff);
}

void
RenderingAttributes::SetSpecularPower(float specularPower_)
{
    specularPower = specularPower_;
    Select(10, (void *)&specularPower);
}

void
RenderingAttributes::SetSpecularColor(const ColorAttribute &specularColor_)
{
    specularColor = specularColor_;
    Select(11, (void *)&specularColor);
}

void
RenderingAttributes::SetDoShadowing(bool doShadowing_)
{
    doShadowing = doShadowing_;
    Select(12, (void *)&doShadowing);
}

void
RenderingAttributes::SetShadowStrength(double shadowStrength_)
{
    shadowStrength = shadowStrength_;
    Select(13, (void *)&shadowStrength);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
RenderingAttributes::GetAntialiasing() const
{
    return antialiasing;
}

RenderingAttributes::GeometryRepresentation
RenderingAttributes::GetGeometryRepresentation() const
{
    return GeometryRepresentation(geometryRepresentation);
}

RenderingAttributes::TriStateMode
RenderingAttributes::GetDisplayListMode() const
{
    return TriStateMode(displayListMode);
}

bool
RenderingAttributes::GetStereoRendering() const
{
    return stereoRendering;
}

RenderingAttributes::StereoTypes
RenderingAttributes::GetStereoType() const
{
    return StereoTypes(stereoType);
}

bool
RenderingAttributes::GetNotifyForEachRender() const
{
    return notifyForEachRender;
}

RenderingAttributes::TriStateMode
RenderingAttributes::GetScalableActivationMode() const
{
    return TriStateMode(scalableActivationMode);
}

int
RenderingAttributes::GetScalableAutoThreshold() const
{
    return scalableAutoThreshold;
}

bool
RenderingAttributes::GetSpecularFlag() const
{
    return specularFlag;
}

float
RenderingAttributes::GetSpecularCoeff() const
{
    return specularCoeff;
}

float
RenderingAttributes::GetSpecularPower() const
{
    return specularPower;
}

const ColorAttribute &
RenderingAttributes::GetSpecularColor() const
{
    return specularColor;
}

ColorAttribute &
RenderingAttributes::GetSpecularColor()
{
    return specularColor;
}

bool
RenderingAttributes::GetDoShadowing() const
{
    return doShadowing;
}

double
RenderingAttributes::GetShadowStrength() const
{
    return shadowStrength;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
RenderingAttributes::SelectSpecularColor()
{
    Select(11, (void *)&specularColor);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: RenderingAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
RenderingAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "antialiasing";
        case 1:  return "geometryRepresentation";
        case 2:  return "displayListMode";
        case 3:  return "stereoRendering";
        case 4:  return "stereoType";
        case 5:  return "notifyForEachRender";
        case 6:  return "scalableActivationMode";
        case 7:  return "scalableAutoThreshold";
        case 8:  return "specularFlag";
        case 9:  return "specularCoeff";
        case 10:  return "specularPower";
        case 11:  return "specularColor";
        case 12:  return "Do Shadowing";
        case 13:  return "Shadow Strength";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: RenderingAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
RenderingAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_enum;
        case 2:  return FieldType_enum;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_enum;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_enum;
        case 7:  return FieldType_int;
        case 8:  return FieldType_bool;
        case 9:  return FieldType_float;
        case 10:  return FieldType_float;
        case 11:  return FieldType_color;
        case 12:  return FieldType_bool;
        case 13:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: RenderingAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
RenderingAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "enum";
        case 2:  return "enum";
        case 3:  return "bool";
        case 4:  return "enum";
        case 5:  return "bool";
        case 6:  return "enum";
        case 7:  return "int";
        case 8:  return "bool";
        case 9:  return "float";
        case 10:  return "float";
        case 11:  return "color";
        case 12:  return "bool";
        case 13:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: RenderingAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Sun Oct 24 07:27:47 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
RenderingAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const RenderingAttributes &obj = *((const RenderingAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (antialiasing == obj.antialiasing);
        }
        break;
    case 1:
        {  // new scope
        retval = (geometryRepresentation == obj.geometryRepresentation);
        }
        break;
    case 2:
        {  // new scope
        retval = (displayListMode == obj.displayListMode);
        }
        break;
    case 3:
        {  // new scope
        retval = (stereoRendering == obj.stereoRendering);
        }
        break;
    case 4:
        {  // new scope
        retval = (stereoType == obj.stereoType);
        }
        break;
    case 5:
        {  // new scope
        retval = (notifyForEachRender == obj.notifyForEachRender);
        }
        break;
    case 6:
        {  // new scope
        retval = (scalableActivationMode == obj.scalableActivationMode);
        }
        break;
    case 7:
        {  // new scope
        retval = (scalableAutoThreshold == obj.scalableAutoThreshold);
        }
        break;
    case 8:
        {  // new scope
        retval = (specularFlag == obj.specularFlag);
        }
        break;
    case 9:
        {  // new scope
        retval = (specularCoeff == obj.specularCoeff);
        }
        break;
    case 10:
        {  // new scope
        retval = (specularPower == obj.specularPower);
        }
        break;
    case 11:
        {  // new scope
        retval = (specularColor == obj.specularColor);
        }
        break;
    case 12:
        {  // new scope
        retval = (doShadowing == obj.doShadowing);
        }
        break;
    case 13:
        {  // new scope
        retval = (shadowStrength == obj.shadowStrength);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

int RenderingAttributes::GetEffectiveScalableThreshold(TriStateMode mode, int autoThreshold)
{
    if (mode == Never)
        return INT_MAX;
    else if (mode == Always)
        return 0;
    else if (mode == Auto)
        return autoThreshold;
    else
        return -1;
}

