#include <QueryOverTimeAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for QueryOverTimeAttributes::TimeType
//

static const char *TimeType_strings[] = {
"Cycle", "DTime", "Timestep"
};

std::string
QueryOverTimeAttributes::TimeType_ToString(QueryOverTimeAttributes::TimeType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return TimeType_strings[index];
}

std::string
QueryOverTimeAttributes::TimeType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return TimeType_strings[index];
}

bool
QueryOverTimeAttributes::TimeType_FromString(const std::string &s, QueryOverTimeAttributes::TimeType &val)
{
    val = QueryOverTimeAttributes::Cycle;
    for(int i = 0; i < 3; ++i)
    {
        if(s == TimeType_strings[i])
        {
            val = (TimeType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::QueryOverTimeAttributes
//
// Purpose: 
//   Constructor for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes::QueryOverTimeAttributes() : AttributeSubject("ibibiibia")
{
    timeType = Cycle;
    startTimeFlag = false;
    startTime = 0;
    endTimeFlag = false;
    endTime = 1;
    stride = 1;
    createWindow = true;
    windowId = 2;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::QueryOverTimeAttributes
//
// Purpose: 
//   Copy constructor for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes::QueryOverTimeAttributes(const QueryOverTimeAttributes &obj) : AttributeSubject("ibibiibia")
{
    timeType = obj.timeType;
    startTimeFlag = obj.startTimeFlag;
    startTime = obj.startTime;
    endTimeFlag = obj.endTimeFlag;
    endTime = obj.endTime;
    stride = obj.stride;
    createWindow = obj.createWindow;
    windowId = obj.windowId;
    queryAtts = obj.queryAtts;

    SelectAll();
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::~QueryOverTimeAttributes
//
// Purpose: 
//   Destructor for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

QueryOverTimeAttributes::~QueryOverTimeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
QueryOverTimeAttributes::operator = (const QueryOverTimeAttributes &obj)
{
    timeType = obj.timeType;
    startTimeFlag = obj.startTimeFlag;
    startTime = obj.startTime;
    endTimeFlag = obj.endTimeFlag;
    endTime = obj.endTime;
    stride = obj.stride;
    createWindow = obj.createWindow;
    windowId = obj.windowId;
    queryAtts = obj.queryAtts;

    SelectAll();
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::operator == (const QueryOverTimeAttributes &obj) const
{
    // Create the return value
    return ((timeType == obj.timeType) &&
            (startTimeFlag == obj.startTimeFlag) &&
            (startTime == obj.startTime) &&
            (endTimeFlag == obj.endTimeFlag) &&
            (endTime == obj.endTime) &&
            (stride == obj.stride) &&
            (createWindow == obj.createWindow) &&
            (windowId == obj.windowId) &&
            (queryAtts == obj.queryAtts));
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::operator != (const QueryOverTimeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::TypeName
//
// Purpose: 
//   Type name method for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
QueryOverTimeAttributes::TypeName() const
{
    return "QueryOverTimeAttributes";
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const QueryOverTimeAttributes *tmp = (const QueryOverTimeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
QueryOverTimeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new QueryOverTimeAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the QueryOverTimeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
QueryOverTimeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new QueryOverTimeAttributes(*this);
    else
        retval = new QueryOverTimeAttributes;

    return retval;
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
QueryOverTimeAttributes::SelectAll()
{
    Select(0, (void *)&timeType);
    Select(1, (void *)&startTimeFlag);
    Select(2, (void *)&startTime);
    Select(3, (void *)&endTimeFlag);
    Select(4, (void *)&endTime);
    Select(5, (void *)&stride);
    Select(6, (void *)&createWindow);
    Select(7, (void *)&windowId);
    Select(8, (void *)&queryAtts);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: QueryOverTimeAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be 
//   saved to a config file.
//
// Programmer: Kathleen Bonnell 
// Creation:   May 26, 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    QueryOverTimeAttributes defaultObject;
    bool addToParent = false;
    // Create a node for QueryOverTimeAttributes.
    DataNode *node = new DataNode("QueryOverTimeAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeType", TimeType_ToString(timeType)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startTimeFlag", startTimeFlag));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startTime", startTime));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endTimeFlag", endTimeFlag));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endTime", endTime));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stride", stride));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("createWindow", createWindow));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("windowId", windowId));
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}
// ****************************************************************************
// Method: QueryOverTimeAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode 
//   representation of the object.
//
// Programmer: Kathleen Bonnell 
// Creation:   May 26, 2004
//
// Modifications:
//   
// ****************************************************************************

void
QueryOverTimeAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("QueryOverTimeAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("timeType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetTimeType(TimeType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            TimeType value;
            if(TimeType_FromString(node->AsString(), value))
                SetTimeType(value);
        }
    }
    if((node = searchNode->GetNode("startTimeFlag")) != 0)
        SetStartTimeFlag(node->AsBool());
    if((node = searchNode->GetNode("startTime")) != 0)
        SetStartTime(node->AsInt());
    if((node = searchNode->GetNode("endTimeFlag")) != 0)
        SetEndTimeFlag(node->AsBool());
    if((node = searchNode->GetNode("endTime")) != 0)
        SetEndTime(node->AsInt());
    if((node = searchNode->GetNode("stride")) != 0)
        SetStride(node->AsInt());
    if((node = searchNode->GetNode("createWindow")) != 0)
        SetCreateWindow(node->AsBool());
    if((node = searchNode->GetNode("windowId")) != 0)
        SetWindowId(node->AsInt());
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
QueryOverTimeAttributes::SetTimeType(QueryOverTimeAttributes::TimeType timeType_)
{
    timeType = timeType_;
    Select(0, (void *)&timeType);
}

void
QueryOverTimeAttributes::SetStartTimeFlag(bool startTimeFlag_)
{
    startTimeFlag = startTimeFlag_;
    Select(1, (void *)&startTimeFlag);
}

void
QueryOverTimeAttributes::SetStartTime(int startTime_)
{
    startTime = startTime_;
    Select(2, (void *)&startTime);
}

void
QueryOverTimeAttributes::SetEndTimeFlag(bool endTimeFlag_)
{
    endTimeFlag = endTimeFlag_;
    Select(3, (void *)&endTimeFlag);
}

void
QueryOverTimeAttributes::SetEndTime(int endTime_)
{
    endTime = endTime_;
    Select(4, (void *)&endTime);
}

void
QueryOverTimeAttributes::SetStride(int stride_)
{
    stride = stride_;
    Select(5, (void *)&stride);
}

void
QueryOverTimeAttributes::SetCreateWindow(bool createWindow_)
{
    createWindow = createWindow_;
    Select(6, (void *)&createWindow);
}

void
QueryOverTimeAttributes::SetWindowId(int windowId_)
{
    windowId = windowId_;
    Select(7, (void *)&windowId);
}

void
QueryOverTimeAttributes::SetQueryAtts(const QueryAttributes &queryAtts_)
{
    queryAtts = queryAtts_;
    Select(8, (void *)&queryAtts);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

QueryOverTimeAttributes::TimeType
QueryOverTimeAttributes::GetTimeType() const
{
    return TimeType(timeType);
}

bool
QueryOverTimeAttributes::GetStartTimeFlag() const
{
    return startTimeFlag;
}

int
QueryOverTimeAttributes::GetStartTime() const
{
    return startTime;
}

bool
QueryOverTimeAttributes::GetEndTimeFlag() const
{
    return endTimeFlag;
}

int
QueryOverTimeAttributes::GetEndTime() const
{
    return endTime;
}

int
QueryOverTimeAttributes::GetStride() const
{
    return stride;
}

bool
QueryOverTimeAttributes::GetCreateWindow() const
{
    return createWindow;
}

int
QueryOverTimeAttributes::GetWindowId() const
{
    return windowId;
}

const QueryAttributes &
QueryOverTimeAttributes::GetQueryAtts() const
{
    return queryAtts;
}

QueryAttributes &
QueryOverTimeAttributes::GetQueryAtts()
{
    return queryAtts;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
QueryOverTimeAttributes::SelectQueryAtts()
{
    Select(8, (void *)&queryAtts);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: QueryOverTimeAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
QueryOverTimeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "timeType";
        case 1:  return "startTimeFlag";
        case 2:  return "startTime";
        case 3:  return "endTimeFlag";
        case 4:  return "endTime";
        case 5:  return "stride";
        case 6:  return "createWindow";
        case 7:  return "windowId";
        case 8:  return "queryAtts";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
QueryOverTimeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_int;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_int;
        case 5:  return FieldType_int;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_int;
        case 8:  return FieldType_att;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
QueryOverTimeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "bool";
        case 2:  return "int";
        case 3:  return "bool";
        case 4:  return "int";
        case 5:  return "int";
        case 6:  return "bool";
        case 7:  return "int";
        case 8:  return "att";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: QueryOverTimeAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed May 26 10:23:00 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryOverTimeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const QueryOverTimeAttributes &obj = *((const QueryOverTimeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (timeType == obj.timeType);
        }
        break;
    case 1:
        {  // new scope
        retval = (startTimeFlag == obj.startTimeFlag);
        }
        break;
    case 2:
        {  // new scope
        retval = (startTime == obj.startTime);
        }
        break;
    case 3:
        {  // new scope
        retval = (endTimeFlag == obj.endTimeFlag);
        }
        break;
    case 4:
        {  // new scope
        retval = (endTime == obj.endTime);
        }
        break;
    case 5:
        {  // new scope
        retval = (stride == obj.stride);
        }
        break;
    case 6:
        {  // new scope
        retval = (createWindow == obj.createWindow);
        }
        break;
    case 7:
        {  // new scope
        retval = (windowId == obj.windowId);
        }
        break;
    case 8:
        {  // new scope
        retval = (queryAtts == obj.queryAtts);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

