#include <QueryAttributes.h>
#include <DataNode.h>
#include <stdio.h>

//
// Enum conversion methods for QueryAttributes::ElementType
//

static const char *ElementType_strings[] = {
"Zone", "Node"};

std::string
QueryAttributes::ElementType_ToString(QueryAttributes::ElementType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return ElementType_strings[index];
}

std::string
QueryAttributes::ElementType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return ElementType_strings[index];
}

bool
QueryAttributes::ElementType_FromString(const std::string &s, QueryAttributes::ElementType &val)
{
    val = QueryAttributes::Zone;
    for(int i = 0; i < 2; ++i)
    {
        if(s == ElementType_strings[i])
        {
            val = (ElementType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for QueryAttributes::VarType
//

static const char *VarType_strings[] = {
"Mesh", "Scalar", "Vector", 
"Tensor", "Symmetric_Tensor", "Material", 
"Species", "Curve", "Unknown"
};

std::string
QueryAttributes::VarType_ToString(QueryAttributes::VarType t)
{
    int index = int(t);
    if(index < 0 || index >= 9) index = 0;
    return VarType_strings[index];
}

std::string
QueryAttributes::VarType_ToString(int t)
{
    int index = (t < 0 || t >= 9) ? 0 : t;
    return VarType_strings[index];
}

bool
QueryAttributes::VarType_FromString(const std::string &s, QueryAttributes::VarType &val)
{
    val = QueryAttributes::Mesh;
    for(int i = 0; i < 9; ++i)
    {
        if(s == VarType_strings[i])
        {
            val = (VarType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for QueryAttributes::DataType
//

static const char *DataType_strings[] = {
"ActualData", "OriginalData"};

std::string
QueryAttributes::DataType_ToString(QueryAttributes::DataType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return DataType_strings[index];
}

std::string
QueryAttributes::DataType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return DataType_strings[index];
}

bool
QueryAttributes::DataType_FromString(const std::string &s, QueryAttributes::DataType &val)
{
    val = QueryAttributes::ActualData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == DataType_strings[i])
        {
            val = (DataType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: QueryAttributes::QueryAttributes
//
// Purpose: 
//   Constructor for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes::QueryAttributes() : AttributeSubject("ss*sFiid*iii*iib")
{
    variables.push_back("default");
    worldPoint[0] = 0;
    worldPoint[1] = 0;
    worldPoint[2] = 0;
    domain = -1;
    element = -1;
    resultsValue.push_back(0);
    elementType = Zone;
    timeStep = 0;
    dataType = ActualData;
    pipeIndex = -1;
    useGlobalId = false;
}

// ****************************************************************************
// Method: QueryAttributes::QueryAttributes
//
// Purpose: 
//   Copy constructor for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes::QueryAttributes(const QueryAttributes &obj) : AttributeSubject("ss*sFiid*iii*iib")
{
    name = obj.name;
    variables = obj.variables;
    resultsMessage = obj.resultsMessage;
    worldPoint[0] = obj.worldPoint[0];
    worldPoint[1] = obj.worldPoint[1];
    worldPoint[2] = obj.worldPoint[2];

    domain = obj.domain;
    element = obj.element;
    resultsValue = obj.resultsValue;
    elementType = obj.elementType;
    timeStep = obj.timeStep;
    varTypes = obj.varTypes;
    dataType = obj.dataType;
    pipeIndex = obj.pipeIndex;
    useGlobalId = obj.useGlobalId;

    SelectAll();
}

// ****************************************************************************
// Method: QueryAttributes::~QueryAttributes
//
// Purpose: 
//   Destructor for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes::~QueryAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: QueryAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes& 
QueryAttributes::operator = (const QueryAttributes &obj)
{
    if (this == &obj) return *this;
    name = obj.name;
    variables = obj.variables;
    resultsMessage = obj.resultsMessage;
    worldPoint[0] = obj.worldPoint[0];
    worldPoint[1] = obj.worldPoint[1];
    worldPoint[2] = obj.worldPoint[2];

    domain = obj.domain;
    element = obj.element;
    resultsValue = obj.resultsValue;
    elementType = obj.elementType;
    timeStep = obj.timeStep;
    varTypes = obj.varTypes;
    dataType = obj.dataType;
    pipeIndex = obj.pipeIndex;
    useGlobalId = obj.useGlobalId;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: QueryAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::operator == (const QueryAttributes &obj) const
{
    int i;

    // Compare the worldPoint arrays.
    bool worldPoint_equal = true;
    for(i = 0; i < 3 && worldPoint_equal; ++i)
        worldPoint_equal = (worldPoint[i] == obj.worldPoint[i]);

    // Create the return value
    return ((name == obj.name) &&
            (variables == obj.variables) &&
            (resultsMessage == obj.resultsMessage) &&
            worldPoint_equal &&
            (domain == obj.domain) &&
            (element == obj.element) &&
            (resultsValue == obj.resultsValue) &&
            (elementType == obj.elementType) &&
            (timeStep == obj.timeStep) &&
            (varTypes == obj.varTypes) &&
            (dataType == obj.dataType) &&
            (pipeIndex == obj.pipeIndex) &&
            (useGlobalId == obj.useGlobalId));
}

// ****************************************************************************
// Method: QueryAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::operator != (const QueryAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: QueryAttributes::TypeName
//
// Purpose: 
//   Type name method for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
QueryAttributes::TypeName() const
{
    return "QueryAttributes";
}

// ****************************************************************************
// Method: QueryAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const QueryAttributes *tmp = (const QueryAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: QueryAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
QueryAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new QueryAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: QueryAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
QueryAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new QueryAttributes(*this);
    else
        retval = new QueryAttributes;

    return retval;
}

// ****************************************************************************
// Method: QueryAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
QueryAttributes::SelectAll()
{
    Select(0, (void *)&name);
    Select(1, (void *)&variables);
    Select(2, (void *)&resultsMessage);
    Select(3, (void *)worldPoint, 3);
    Select(4, (void *)&domain);
    Select(5, (void *)&element);
    Select(6, (void *)&resultsValue);
    Select(7, (void *)&elementType);
    Select(8, (void *)&timeStep);
    Select(9, (void *)&varTypes);
    Select(10, (void *)&dataType);
    Select(11, (void *)&pipeIndex);
    Select(12, (void *)&useGlobalId);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: QueryAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    QueryAttributes defaultObject;
    bool addToParent = false;
    // Create a node for QueryAttributes.
    DataNode *node = new DataNode("QueryAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("name", name));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variables", variables));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("resultsMessage", resultsMessage));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("worldPoint", worldPoint, 3));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("domain", domain));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("element", element));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("resultsValue", resultsValue));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("elementType", ElementType_ToString(elementType)));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeStep", timeStep));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("varTypes", varTypes));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("dataType", DataType_ToString(dataType)));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pipeIndex", pipeIndex));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useGlobalId", useGlobalId));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: QueryAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
QueryAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("QueryAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("name")) != 0)
        SetName(node->AsString());
    if((node = searchNode->GetNode("variables")) != 0)
        SetVariables(node->AsStringVector());
    if((node = searchNode->GetNode("resultsMessage")) != 0)
        SetResultsMessage(node->AsString());
    if((node = searchNode->GetNode("worldPoint")) != 0)
        SetWorldPoint(node->AsFloatArray());
    if((node = searchNode->GetNode("domain")) != 0)
        SetDomain(node->AsInt());
    if((node = searchNode->GetNode("element")) != 0)
        SetElement(node->AsInt());
    if((node = searchNode->GetNode("resultsValue")) != 0)
        SetResultsValue(node->AsDoubleVector());
    if((node = searchNode->GetNode("elementType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetElementType(ElementType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ElementType value;
            if(ElementType_FromString(node->AsString(), value))
                SetElementType(value);
        }
    }
    if((node = searchNode->GetNode("timeStep")) != 0)
        SetTimeStep(node->AsInt());
    if((node = searchNode->GetNode("varTypes")) != 0)
        SetVarTypes(node->AsIntVector());
    if((node = searchNode->GetNode("dataType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetDataType(DataType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            DataType value;
            if(DataType_FromString(node->AsString(), value))
                SetDataType(value);
        }
    }
    if((node = searchNode->GetNode("pipeIndex")) != 0)
        SetPipeIndex(node->AsInt());
    if((node = searchNode->GetNode("useGlobalId")) != 0)
        SetUseGlobalId(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
QueryAttributes::SetName(const std::string &name_)
{
    name = name_;
    Select(0, (void *)&name);
}

void
QueryAttributes::SetVariables(const stringVector &variables_)
{
    variables = variables_;
    Select(1, (void *)&variables);
}

void
QueryAttributes::SetResultsMessage(const std::string &resultsMessage_)
{
    resultsMessage = resultsMessage_;
    Select(2, (void *)&resultsMessage);
}

void
QueryAttributes::SetWorldPoint(const float *worldPoint_)
{
    worldPoint[0] = worldPoint_[0];
    worldPoint[1] = worldPoint_[1];
    worldPoint[2] = worldPoint_[2];
    Select(3, (void *)worldPoint, 3);
}

void
QueryAttributes::SetDomain(int domain_)
{
    domain = domain_;
    Select(4, (void *)&domain);
}

void
QueryAttributes::SetElement(int element_)
{
    element = element_;
    Select(5, (void *)&element);
}

void
QueryAttributes::SetResultsValue(const doubleVector &resultsValue_)
{
    resultsValue = resultsValue_;
    Select(6, (void *)&resultsValue);
}

void
QueryAttributes::SetElementType(QueryAttributes::ElementType elementType_)
{
    elementType = elementType_;
    Select(7, (void *)&elementType);
}

void
QueryAttributes::SetTimeStep(int timeStep_)
{
    timeStep = timeStep_;
    Select(8, (void *)&timeStep);
}

void
QueryAttributes::SetVarTypes(const intVector &varTypes_)
{
    varTypes = varTypes_;
    Select(9, (void *)&varTypes);
}

void
QueryAttributes::SetDataType(QueryAttributes::DataType dataType_)
{
    dataType = dataType_;
    Select(10, (void *)&dataType);
}

void
QueryAttributes::SetPipeIndex(int pipeIndex_)
{
    pipeIndex = pipeIndex_;
    Select(11, (void *)&pipeIndex);
}

void
QueryAttributes::SetUseGlobalId(bool useGlobalId_)
{
    useGlobalId = useGlobalId_;
    Select(12, (void *)&useGlobalId);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
QueryAttributes::GetName() const
{
    return name;
}

std::string &
QueryAttributes::GetName()
{
    return name;
}

const stringVector &
QueryAttributes::GetVariables() const
{
    return variables;
}

stringVector &
QueryAttributes::GetVariables()
{
    return variables;
}

const std::string &
QueryAttributes::GetResultsMessage() const
{
    return resultsMessage;
}

std::string &
QueryAttributes::GetResultsMessage()
{
    return resultsMessage;
}

const float *
QueryAttributes::GetWorldPoint() const
{
    return worldPoint;
}

float *
QueryAttributes::GetWorldPoint()
{
    return worldPoint;
}

int
QueryAttributes::GetDomain() const
{
    return domain;
}

int
QueryAttributes::GetElement() const
{
    return element;
}

const doubleVector &
QueryAttributes::GetResultsValue() const
{
    return resultsValue;
}

doubleVector &
QueryAttributes::GetResultsValue()
{
    return resultsValue;
}

QueryAttributes::ElementType
QueryAttributes::GetElementType() const
{
    return ElementType(elementType);
}

int
QueryAttributes::GetTimeStep() const
{
    return timeStep;
}

const intVector &
QueryAttributes::GetVarTypes() const
{
    return varTypes;
}

intVector &
QueryAttributes::GetVarTypes()
{
    return varTypes;
}

QueryAttributes::DataType
QueryAttributes::GetDataType() const
{
    return DataType(dataType);
}

int
QueryAttributes::GetPipeIndex() const
{
    return pipeIndex;
}

bool
QueryAttributes::GetUseGlobalId() const
{
    return useGlobalId;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
QueryAttributes::SelectName()
{
    Select(0, (void *)&name);
}

void
QueryAttributes::SelectVariables()
{
    Select(1, (void *)&variables);
}

void
QueryAttributes::SelectResultsMessage()
{
    Select(2, (void *)&resultsMessage);
}

void
QueryAttributes::SelectWorldPoint()
{
    Select(3, (void *)worldPoint, 3);
}

void
QueryAttributes::SelectResultsValue()
{
    Select(6, (void *)&resultsValue);
}

void
QueryAttributes::SelectVarTypes()
{
    Select(9, (void *)&varTypes);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: QueryAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
QueryAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "name";
        case 1:  return "variables";
        case 2:  return "resultsMessage";
        case 3:  return "worldPoint";
        case 4:  return "domain";
        case 5:  return "element";
        case 6:  return "resultsValue";
        case 7:  return "elementType";
        case 8:  return "timeStep";
        case 9:  return "varTypes";
        case 10:  return "dataType";
        case 11:  return "pipeIndex";
        case 12:  return "useGlobalId";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: QueryAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
QueryAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_string;
        case 1:  return FieldType_stringVector;
        case 2:  return FieldType_string;
        case 3:  return FieldType_floatArray;
        case 4:  return FieldType_int;
        case 5:  return FieldType_int;
        case 6:  return FieldType_doubleVector;
        case 7:  return FieldType_enum;
        case 8:  return FieldType_int;
        case 9:  return FieldType_intVector;
        case 10:  return FieldType_enum;
        case 11:  return FieldType_int;
        case 12:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: QueryAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
QueryAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "string";
        case 1:  return "stringVector";
        case 2:  return "string";
        case 3:  return "floatArray";
        case 4:  return "int";
        case 5:  return "int";
        case 6:  return "doubleVector";
        case 7:  return "enum";
        case 8:  return "int";
        case 9:  return "intVector";
        case 10:  return "enum";
        case 11:  return "int";
        case 12:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: QueryAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 15 17:00:43 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const QueryAttributes &obj = *((const QueryAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (name == obj.name);
        }
        break;
    case 1:
        {  // new scope
        retval = (variables == obj.variables);
        }
        break;
    case 2:
        {  // new scope
        retval = (resultsMessage == obj.resultsMessage);
        }
        break;
    case 3:
        {  // new scope
        // Compare the worldPoint arrays.
        bool worldPoint_equal = true;
        for(i = 0; i < 3 && worldPoint_equal; ++i)
            worldPoint_equal = (worldPoint[i] == obj.worldPoint[i]);

        retval = worldPoint_equal;
        }
        break;
    case 4:
        {  // new scope
        retval = (domain == obj.domain);
        }
        break;
    case 5:
        {  // new scope
        retval = (element == obj.element);
        }
        break;
    case 6:
        {  // new scope
        retval = (resultsValue == obj.resultsValue);
        }
        break;
    case 7:
        {  // new scope
        retval = (elementType == obj.elementType);
        }
        break;
    case 8:
        {  // new scope
        retval = (timeStep == obj.timeStep);
        }
        break;
    case 9:
        {  // new scope
        retval = (varTypes == obj.varTypes);
        }
        break;
    case 10:
        {  // new scope
        retval = (dataType == obj.dataType);
        }
        break;
    case 11:
        {  // new scope
        retval = (pipeIndex == obj.pipeIndex);
        }
        break;
    case 12:
        {  // new scope
        retval = (useGlobalId == obj.useGlobalId);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
QueryAttributes::Reset()
{
    name    = " ";
    resultsMessage  = " ";
    if (!variables.empty())
    {
        variables.clear();
        variables.push_back("default");
    }
    if (!varTypes.empty())
    {
         varTypes.clear();
    }
    worldPoint[0] = worldPoint[1] = worldPoint[2] = 0.;
    domain = -1;
    element = -1;
    elementType = Zone;
    if (!resultsValue.empty())
    {
        resultsValue.clear();
        resultsValue.push_back(0.);
    }
    pipeIndex = -1;
 
    SelectAll();
}

void
QueryAttributes::PrintSelf(ostream &os)
{
    int i;
    os << "\n" << name.c_str() << ":  ";
    os << "selected variables: ";
    for (i = 0; i < variables.size(); i++)
        os << variables[i].c_str() << "  ";
    os << "\n";
    os << "Results: <" << resultsMessage.c_str() << ">\n";
    os << "World point: <" << worldPoint[0] << ", " << worldPoint[1] 
       << ", " << worldPoint[2] << ">\n"; 
    os << "Domain:      " << domain << "\n";
    os << "Element:        " << element << ")\n";
    if (elementType == Zone)
    os << "Element type is Zone " << endl;
    else
    os << "Element type is Node " << endl;
}

void
QueryAttributes::SetResultsValue(const double val)
{
    resultsValue[0] = val;    
}

void
QueryAttributes::SetResultsValues(const double *vals, const int numVals)
{
    int i;
    resultsValue.clear();
    for (i = 0; i < numVals; ++i)
        resultsValue.push_back(vals[i]);
}

