#ifndef POINT_H
#define POINT_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: Point
//
// Purpose:
//    This class contains attributes for a point.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:23 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API Point : public AttributeSubject
{
public:
    enum ValueType
    {
        VT_Tuple,
        VT_Min,
        VT_Max,
        VT_DomainZone,
        VT_Zone,
        VT_DomainNode,
        VT_Node,
        VT_Unknown
    };

    Point();
    Point(const Point &obj);
    virtual ~Point();

    virtual void operator = (const Point &obj);
    virtual bool operator == (const Point &obj) const;
    virtual bool operator != (const Point &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectValue();

    // Property setting methods
    void SetValue(const std::string &value_);

    // Property getting methods
    const std::string &GetValue() const;
          std::string &GetValue();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string ValueType_ToString(ValueType);
    static bool ValueType_FromString(const std::string &, ValueType &);
protected:
    static std::string ValueType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    Point(double,double,double);
    ValueType GetValueType() const;
    bool GetTupleArgs(double&, double&, double&) const;
    bool GetMinArgs(char*) const;
    bool GetMaxArgs(char*) const;
    bool GetDomainZoneArgs(int&, int&) const;
    bool GetZoneArgs(int&) const;
    bool GetDomainNodeArgs(int&, int&) const;
    bool GetNodeArgs(int&) const;
private:
    std::string value;
};

#endif
