#include <PluginManagerAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: PluginManagerAttributes::PluginManagerAttributes
//
// Purpose: 
//   Constructor for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes::PluginManagerAttributes() : AttributeSubject("s*s*s*s*i*")
{
}

// ****************************************************************************
// Method: PluginManagerAttributes::PluginManagerAttributes
//
// Purpose: 
//   Copy constructor for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes::PluginManagerAttributes(const PluginManagerAttributes &obj) : AttributeSubject("s*s*s*s*i*")
{
    name = obj.name;
    type = obj.type;
    version = obj.version;
    id = obj.id;
    enabled = obj.enabled;

    SelectAll();
}

// ****************************************************************************
// Method: PluginManagerAttributes::~PluginManagerAttributes
//
// Purpose: 
//   Destructor for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

PluginManagerAttributes::~PluginManagerAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: PluginManagerAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PluginManagerAttributes::operator = (const PluginManagerAttributes &obj)
{
    name = obj.name;
    type = obj.type;
    version = obj.version;
    id = obj.id;
    enabled = obj.enabled;

    SelectAll();
}

// ****************************************************************************
// Method: PluginManagerAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::operator == (const PluginManagerAttributes &obj) const
{
    // Create the return value
    return ((name == obj.name) &&
            (type == obj.type) &&
            (version == obj.version) &&
            (id == obj.id) &&
            (enabled == obj.enabled));
}

// ****************************************************************************
// Method: PluginManagerAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::operator != (const PluginManagerAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PluginManagerAttributes::TypeName
//
// Purpose: 
//   Type name method for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
PluginManagerAttributes::TypeName() const
{
    return "PluginManagerAttributes";
}

// ****************************************************************************
// Method: PluginManagerAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PluginManagerAttributes *tmp = (const PluginManagerAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PluginManagerAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PluginManagerAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PluginManagerAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PluginManagerAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the PluginManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PluginManagerAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PluginManagerAttributes(*this);
    else
        retval = new PluginManagerAttributes;

    return retval;
}

// ****************************************************************************
// Method: PluginManagerAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PluginManagerAttributes::SelectAll()
{
    Select(0, (void *)&name);
    Select(1, (void *)&type);
    Select(2, (void *)&version);
    Select(3, (void *)&id);
    Select(4, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PluginManagerAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PluginManagerAttributes defaultObject;
    bool addToParent = false;
    // Create a node for PluginManagerAttributes.
    DataNode *node = new DataNode("PluginManagerAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("name", name));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("type", type));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("version", version));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("id", id));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enabled", enabled));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: PluginManagerAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PluginManagerAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PluginManagerAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("name")) != 0)
        SetName(node->AsStringVector());
    if((node = searchNode->GetNode("type")) != 0)
        SetType(node->AsStringVector());
    if((node = searchNode->GetNode("version")) != 0)
        SetVersion(node->AsStringVector());
    if((node = searchNode->GetNode("id")) != 0)
        SetId(node->AsStringVector());
    if((node = searchNode->GetNode("enabled")) != 0)
        SetEnabled(node->AsIntVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PluginManagerAttributes::SetName(const stringVector &name_)
{
    name = name_;
    Select(0, (void *)&name);
}

void
PluginManagerAttributes::SetType(const stringVector &type_)
{
    type = type_;
    Select(1, (void *)&type);
}

void
PluginManagerAttributes::SetVersion(const stringVector &version_)
{
    version = version_;
    Select(2, (void *)&version);
}

void
PluginManagerAttributes::SetId(const stringVector &id_)
{
    id = id_;
    Select(3, (void *)&id);
}

void
PluginManagerAttributes::SetEnabled(const intVector &enabled_)
{
    enabled = enabled_;
    Select(4, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
PluginManagerAttributes::GetName() const
{
    return name;
}

stringVector &
PluginManagerAttributes::GetName()
{
    return name;
}

const stringVector &
PluginManagerAttributes::GetType() const
{
    return type;
}

stringVector &
PluginManagerAttributes::GetType()
{
    return type;
}

const stringVector &
PluginManagerAttributes::GetVersion() const
{
    return version;
}

stringVector &
PluginManagerAttributes::GetVersion()
{
    return version;
}

const stringVector &
PluginManagerAttributes::GetId() const
{
    return id;
}

stringVector &
PluginManagerAttributes::GetId()
{
    return id;
}

const intVector &
PluginManagerAttributes::GetEnabled() const
{
    return enabled;
}

intVector &
PluginManagerAttributes::GetEnabled()
{
    return enabled;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PluginManagerAttributes::SelectName()
{
    Select(0, (void *)&name);
}

void
PluginManagerAttributes::SelectType()
{
    Select(1, (void *)&type);
}

void
PluginManagerAttributes::SelectVersion()
{
    Select(2, (void *)&version);
}

void
PluginManagerAttributes::SelectId()
{
    Select(3, (void *)&id);
}

void
PluginManagerAttributes::SelectEnabled()
{
    Select(4, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PluginManagerAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
PluginManagerAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "name";
        case 1:  return "type";
        case 2:  return "version";
        case 3:  return "id";
        case 4:  return "enabled";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PluginManagerAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PluginManagerAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_stringVector;
        case 1:  return FieldType_stringVector;
        case 2:  return FieldType_stringVector;
        case 3:  return FieldType_stringVector;
        case 4:  return FieldType_intVector;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PluginManagerAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
PluginManagerAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "stringVector";
        case 1:  return "stringVector";
        case 2:  return "stringVector";
        case 3:  return "stringVector";
        case 4:  return "intVector";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PluginManagerAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PluginManagerAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PluginManagerAttributes &obj = *((const PluginManagerAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (name == obj.name);
        }
        break;
    case 1:
        {  // new scope
        retval = (type == obj.type);
        }
        break;
    case 2:
        {  // new scope
        retval = (version == obj.version);
        }
        break;
    case 3:
        {  // new scope
        retval = (id == obj.id);
        }
        break;
    case 4:
        {  // new scope
        retval = (enabled == obj.enabled);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PluginManagerAttributes::GetIndexByID
//
// Purpose: 
//   Find the index of a plugin by its ID, or -1 if it does not exist
//
// Programmer: Jeremy Meredith
// Creation:   September  7, 2001
//
// ****************************************************************************

int
PluginManagerAttributes::GetIndexByID(const std::string &s)
{
    for (int i=0; i<id.size(); i++)
    {
        if (id[i] == s)
            return i;
    }
    // not found -- return -1
    return -1;
}

// ****************************************************************************
// Method: PluginManagerAttributes::AddPlugin
//
// Purpose: 
//   Add a new plugin.
//
// Programmer: Jeremy Meredith
// Creation:   September  7, 2001
//
// Modifications:
//    Jeremy Meredith, Wed Nov  5 12:51:11 PST 2003
//    Added ability to disable plugins by default.
//
// ****************************************************************************

void 
PluginManagerAttributes::AddPlugin(const std::string &n,
                                   const std::string &t,
                                   const std::string &v,
                                   const std::string &i,
                                   bool e)
{
    name.push_back(n);
    type.push_back(t);
    version.push_back(v);
    id.push_back(i);
    enabled.push_back(e);
    SelectAll();
}

// ****************************************************************************
// Method: PluginManagerAttributes::AddPlugin
//
// Purpose: 
//   Add a new plugin.
//
// Programmer: Jeremy Meredith
// Creation:   September 27, 2001
//
// ****************************************************************************

void 
PluginManagerAttributes::RemovePlugin(const std::string &s)
{
    int index = GetIndexByID(s);
    if (index<0)
        return;

    name   .erase(name   .begin() + index);
    type   .erase(type   .begin() + index);
    version.erase(version.begin() + index);
    id     .erase(id     .begin() + index);
    enabled.erase(enabled.begin() + index);
    SelectAll();
}

