#ifndef PLOTLIST_H
#define PLOTLIST_H
#include <state_exports.h>
#include <AttributeSubject.h>
class Plot;

// ****************************************************************************
// Class: PlotList
//
// Purpose:
//    This class contains a list of plots.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API PlotList : public AttributeSubject
{
public:
    PlotList();
    PlotList(const PlotList &obj);
    virtual ~PlotList();

    virtual void operator = (const PlotList &obj);
    virtual bool operator == (const PlotList &obj) const;
    virtual bool operator != (const PlotList &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPlots();

    // Property setting methods
    void SetPlots(const AttributeGroupVector &plots_);

    // Property getting methods
    const AttributeGroupVector &GetPlots() const;
          AttributeGroupVector &GetPlots();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddPlot(const Plot &);
    void ClearPlots();
    void RemovePlot(int i);
    int  GetNumPlots() const;
    Plot &GetPlot(int i);
    const Plot &GetPlot(int i) const;

    Plot &operator [] (int i);
    const Plot &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void AddPlot(const Plot &p, int id);
protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector plots;
};

#endif
