#include <PlotList.h>
#include <DataNode.h>
#include <Plot.h>

// ****************************************************************************
// Method: PlotList::PlotList
//
// Purpose: 
//   Constructor for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

PlotList::PlotList() : AttributeSubject("a*")
{
}

// ****************************************************************************
// Method: PlotList::PlotList
//
// Purpose: 
//   Copy constructor for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

PlotList::PlotList(const PlotList &obj) : AttributeSubject("a*")
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the plots field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = plots.begin(); pos != plots.end(); ++pos)
        delete *pos;
    plots.clear();
    if(obj.plots.size() > 0)
        plots.reserve(obj.plots.size());
    // Duplicate the plots from obj.
    for(pos = obj.plots.begin(); pos != obj.plots.end(); ++pos)
    {
        Plot *oldPlot = (Plot *)(*pos);
        Plot *newPlot = new Plot(*oldPlot);
        plots.push_back(newPlot);
    }


    SelectAll();
}

// ****************************************************************************
// Method: PlotList::~PlotList
//
// Purpose: 
//   Destructor for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

PlotList::~PlotList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the plots field.
    for(pos = plots.begin(); pos != plots.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: PlotList::operator = 
//
// Purpose: 
//   Assignment operator for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::operator = (const PlotList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the plots field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = plots.begin(); pos != plots.end(); ++pos)
        delete *pos;
    plots.clear();
    if(obj.plots.size() > 0)
        plots.reserve(obj.plots.size());
    // Duplicate the plots from obj.
    for(pos = obj.plots.begin(); pos != obj.plots.end(); ++pos)
    {
        Plot *oldPlot = (Plot *)(*pos);
        Plot *newPlot = new Plot(*oldPlot);
        plots.push_back(newPlot);
    }


    SelectAll();
}

// ****************************************************************************
// Method: PlotList::operator == 
//
// Purpose: 
//   Comparison operator == for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::operator == (const PlotList &obj) const
{
    int i;

    bool plots_equal = (obj.plots.size() == plots.size());
    for(i = 0; (i < plots.size()) && plots_equal; ++i)
    {
        // Make references to Plot from AttributeGroup *.
        const Plot &plots1 = *((const Plot *)(plots[i]));
        const Plot &plots2 = *((const Plot *)(obj.plots[i]));
        plots_equal = (plots1 == plots2);
    }

    // Create the return value
    return (plots_equal);
}

// ****************************************************************************
// Method: PlotList::operator != 
//
// Purpose: 
//   Comparison operator != for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::operator != (const PlotList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PlotList::TypeName
//
// Purpose: 
//   Type name method for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
PlotList::TypeName() const
{
    return "PlotList";
}

// ****************************************************************************
// Method: PlotList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PlotList *tmp = (const PlotList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PlotList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PlotList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PlotList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PlotList::NewInstance
//
// Purpose: 
//   NewInstance method for the PlotList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PlotList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PlotList(*this);
    else
        retval = new PlotList;

    return retval;
}

// ****************************************************************************
// Method: PlotList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::SelectAll()
{
    Select(0, (void *)&plots);
}

// ****************************************************************************
// Method: PlotList::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
PlotList::CreateSubAttributeGroup(int)
{
    return new Plot;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PlotList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PlotList defaultObject;
    bool addToParent = false;
    // Create a node for PlotList.
    DataNode *node = new DataNode("PlotList");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        for(int i = 0; i < plots.size(); ++i)
            plots[i]->CreateNode(node, completeSave, true);
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: PlotList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PlotList");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    // Clear all the Plots.
    ClearPlots();

    // Go through all of the children and construct a new
    // Plot for each one of them.
    children = searchNode->GetChildren();
    for(i = 0; i < searchNode->GetNumChildren(); ++i)
    {
        if(children[i]->GetKey() == std::string("Plot"))
        {
            Plot temp;
            temp.SetFromNode(children[i]);
            AddPlot(temp);
        }
    }

}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
PlotList::GetPlots() const
{
    return plots;
}

AttributeGroupVector &
PlotList::GetPlots()
{
    return plots;
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PlotList::AddPlot
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::AddPlot(const Plot &obj)
{
    Plot *newPlot = new Plot(obj);
    plots.push_back(newPlot);

    // Indicate that things have changed by selecting it.
    Select(0, (void *)&plots);
}

// ****************************************************************************
// Method: PlotList::ClearPlots
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::ClearPlots()
{
    AttributeGroupVector::iterator pos;

    for(pos = plots.begin(); pos != plots.end(); ++pos)
        delete *pos;
    plots.clear();

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&plots);
}

// ****************************************************************************
// Method: PlotList::RemovePlot
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
PlotList::RemovePlot(int index)
{
    AttributeGroupVector::iterator pos = plots.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != plots.end())
    {
        delete *pos;
        plots.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&plots);
}

// ****************************************************************************
// Method: PlotList::GetNumPlots
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
PlotList::GetNumPlots() const
{
    return plots.size();
}

// ****************************************************************************
// Method: PlotList::GetPlot
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

Plot &
PlotList::GetPlot(int i)
{
    return *((Plot *)plots[i]);
}

// ****************************************************************************
// Method: PlotList::GetPlot
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const Plot &
PlotList::GetPlot(int i) const
{
    return *((Plot *)plots[i]);
}

// ****************************************************************************
// Method: PlotList::operator []
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

Plot &
PlotList::operator [] (int i)
{
    return *((Plot *)plots[i]);
}

// ****************************************************************************
// Method: PlotList::operator []
//
// Purpose: 
//   This class contains a list of plots.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const Plot &
PlotList::operator [] (int i) const
{
    return *((Plot *)plots[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PlotList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
PlotList::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "plots";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PlotList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PlotList::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_attVector;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PlotList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
PlotList::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "attVector";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PlotList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
PlotList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const PlotList &obj = *((const PlotList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        bool plots_equal = (obj.plots.size() == plots.size());
        for(i = 0; (i < plots.size()) && plots_equal; ++i)
        {
            // Make references to Plot from AttributeGroup *.
            const Plot &plots1 = *((const Plot *)(plots[i]));
            const Plot &plots2 = *((const Plot *)(obj.plots[i]));
            plots_equal = (plots1 == plots2);
        }

        retval = plots_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
PlotList::AddPlot(const Plot &p, int id)
{
    Plot *newPlot = new Plot(p);
    newPlot->SetId(id);
    plots.push_back(newPlot);

    // Indicate that things have changed by selecting the plot list.
    Select(0, (void *)&plots);
}

