#include <Plot.h>
#include <DataNode.h>

//
// Enum conversion methods for Plot::StateType
//

static const char *StateType_strings[] = {
"NewlyCreated", "Pending", "Completed", 
"Error"};

std::string
Plot::StateType_ToString(Plot::StateType t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return StateType_strings[index];
}

std::string
Plot::StateType_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return StateType_strings[index];
}

bool
Plot::StateType_FromString(const std::string &s, Plot::StateType &val)
{
    val = Plot::NewlyCreated;
    for(int i = 0; i < 4; ++i)
    {
        if(s == StateType_strings[i])
        {
            val = (StateType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: Plot::Plot
//
// Purpose: 
//   Constructor for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

Plot::Plot() : AttributeSubject("iibbbssi*iiiii*i*b")
{
    stateType = NewlyCreated;
    plotType = 0;
    activeFlag = false;
    hiddenFlag = false;
    expandedFlag = false;
    plotVar = "notset";
    databaseName = "notset";
    activeOperator = -1;
    id = -1;
    beginFrame = -999;
    endFrame = 999;
    isFromSimulation = false;
}

// ****************************************************************************
// Method: Plot::Plot
//
// Purpose: 
//   Copy constructor for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

Plot::Plot(const Plot &obj) : AttributeSubject("iibbbssi*iiiii*i*b")
{
    stateType = obj.stateType;
    plotType = obj.plotType;
    activeFlag = obj.activeFlag;
    hiddenFlag = obj.hiddenFlag;
    expandedFlag = obj.expandedFlag;
    plotVar = obj.plotVar;
    databaseName = obj.databaseName;
    operators = obj.operators;
    activeOperator = obj.activeOperator;
    id = obj.id;
    beginFrame = obj.beginFrame;
    endFrame = obj.endFrame;
    keyframes = obj.keyframes;
    databaseKeyframes = obj.databaseKeyframes;
    isFromSimulation = obj.isFromSimulation;

    SelectAll();
}

// ****************************************************************************
// Method: Plot::~Plot
//
// Purpose: 
//   Destructor for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

Plot::~Plot()
{
    // nothing here
}

// ****************************************************************************
// Method: Plot::operator = 
//
// Purpose: 
//   Assignment operator for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
Plot::operator = (const Plot &obj)
{
    stateType = obj.stateType;
    plotType = obj.plotType;
    activeFlag = obj.activeFlag;
    hiddenFlag = obj.hiddenFlag;
    expandedFlag = obj.expandedFlag;
    plotVar = obj.plotVar;
    databaseName = obj.databaseName;
    operators = obj.operators;
    activeOperator = obj.activeOperator;
    id = obj.id;
    beginFrame = obj.beginFrame;
    endFrame = obj.endFrame;
    keyframes = obj.keyframes;
    databaseKeyframes = obj.databaseKeyframes;
    isFromSimulation = obj.isFromSimulation;

    SelectAll();
}

// ****************************************************************************
// Method: Plot::operator == 
//
// Purpose: 
//   Comparison operator == for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Plot::operator == (const Plot &obj) const
{
    // Create the return value
    return ((stateType == obj.stateType) &&
            (plotType == obj.plotType) &&
            (activeFlag == obj.activeFlag) &&
            (hiddenFlag == obj.hiddenFlag) &&
            (expandedFlag == obj.expandedFlag) &&
            (plotVar == obj.plotVar) &&
            (databaseName == obj.databaseName) &&
            (operators == obj.operators) &&
            (activeOperator == obj.activeOperator) &&
            (id == obj.id) &&
            (beginFrame == obj.beginFrame) &&
            (endFrame == obj.endFrame) &&
            (keyframes == obj.keyframes) &&
            (databaseKeyframes == obj.databaseKeyframes) &&
            (isFromSimulation == obj.isFromSimulation));
}

// ****************************************************************************
// Method: Plot::operator != 
//
// Purpose: 
//   Comparison operator != for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Plot::operator != (const Plot &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: Plot::TypeName
//
// Purpose: 
//   Type name method for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
Plot::TypeName() const
{
    return "Plot";
}

// ****************************************************************************
// Method: Plot::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Plot::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const Plot *tmp = (const Plot *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: Plot::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Plot::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new Plot(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: Plot::NewInstance
//
// Purpose: 
//   NewInstance method for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Plot::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new Plot(*this);
    else
        retval = new Plot;

    return retval;
}

// ****************************************************************************
// Method: Plot::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
Plot::SelectAll()
{
    Select(0, (void *)&stateType);
    Select(1, (void *)&plotType);
    Select(2, (void *)&activeFlag);
    Select(3, (void *)&hiddenFlag);
    Select(4, (void *)&expandedFlag);
    Select(5, (void *)&plotVar);
    Select(6, (void *)&databaseName);
    Select(7, (void *)&operators);
    Select(8, (void *)&activeOperator);
    Select(9, (void *)&id);
    Select(10, (void *)&beginFrame);
    Select(11, (void *)&endFrame);
    Select(12, (void *)&keyframes);
    Select(13, (void *)&databaseKeyframes);
    Select(14, (void *)&isFromSimulation);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
Plot::SetStateType(Plot::StateType stateType_)
{
    stateType = stateType_;
    Select(0, (void *)&stateType);
}

void
Plot::SetPlotType(int plotType_)
{
    plotType = plotType_;
    Select(1, (void *)&plotType);
}

void
Plot::SetActiveFlag(bool activeFlag_)
{
    activeFlag = activeFlag_;
    Select(2, (void *)&activeFlag);
}

void
Plot::SetHiddenFlag(bool hiddenFlag_)
{
    hiddenFlag = hiddenFlag_;
    Select(3, (void *)&hiddenFlag);
}

void
Plot::SetExpandedFlag(bool expandedFlag_)
{
    expandedFlag = expandedFlag_;
    Select(4, (void *)&expandedFlag);
}

void
Plot::SetPlotVar(const std::string &plotVar_)
{
    plotVar = plotVar_;
    Select(5, (void *)&plotVar);
}

void
Plot::SetDatabaseName(const std::string &databaseName_)
{
    databaseName = databaseName_;
    Select(6, (void *)&databaseName);
}

void
Plot::SetOperators(const intVector &operators_)
{
    operators = operators_;
    Select(7, (void *)&operators);
}

void
Plot::SetActiveOperator(int activeOperator_)
{
    activeOperator = activeOperator_;
    Select(8, (void *)&activeOperator);
}

void
Plot::SetId(int id_)
{
    id = id_;
    Select(9, (void *)&id);
}

void
Plot::SetBeginFrame(int beginFrame_)
{
    beginFrame = beginFrame_;
    Select(10, (void *)&beginFrame);
}

void
Plot::SetEndFrame(int endFrame_)
{
    endFrame = endFrame_;
    Select(11, (void *)&endFrame);
}

void
Plot::SetKeyframes(const intVector &keyframes_)
{
    keyframes = keyframes_;
    Select(12, (void *)&keyframes);
}

void
Plot::SetDatabaseKeyframes(const intVector &databaseKeyframes_)
{
    databaseKeyframes = databaseKeyframes_;
    Select(13, (void *)&databaseKeyframes);
}

void
Plot::SetIsFromSimulation(bool isFromSimulation_)
{
    isFromSimulation = isFromSimulation_;
    Select(14, (void *)&isFromSimulation);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

Plot::StateType
Plot::GetStateType() const
{
    return StateType(stateType);
}

int
Plot::GetPlotType() const
{
    return plotType;
}

bool
Plot::GetActiveFlag() const
{
    return activeFlag;
}

bool
Plot::GetHiddenFlag() const
{
    return hiddenFlag;
}

bool
Plot::GetExpandedFlag() const
{
    return expandedFlag;
}

const std::string &
Plot::GetPlotVar() const
{
    return plotVar;
}

std::string &
Plot::GetPlotVar()
{
    return plotVar;
}

const std::string &
Plot::GetDatabaseName() const
{
    return databaseName;
}

std::string &
Plot::GetDatabaseName()
{
    return databaseName;
}

const intVector &
Plot::GetOperators() const
{
    return operators;
}

intVector &
Plot::GetOperators()
{
    return operators;
}

int
Plot::GetActiveOperator() const
{
    return activeOperator;
}

int
Plot::GetId() const
{
    return id;
}

int
Plot::GetBeginFrame() const
{
    return beginFrame;
}

int
Plot::GetEndFrame() const
{
    return endFrame;
}

const intVector &
Plot::GetKeyframes() const
{
    return keyframes;
}

intVector &
Plot::GetKeyframes()
{
    return keyframes;
}

const intVector &
Plot::GetDatabaseKeyframes() const
{
    return databaseKeyframes;
}

intVector &
Plot::GetDatabaseKeyframes()
{
    return databaseKeyframes;
}

bool
Plot::GetIsFromSimulation() const
{
    return isFromSimulation;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
Plot::SelectPlotVar()
{
    Select(5, (void *)&plotVar);
}

void
Plot::SelectDatabaseName()
{
    Select(6, (void *)&databaseName);
}

void
Plot::SelectOperators()
{
    Select(7, (void *)&operators);
}

void
Plot::SelectKeyframes()
{
    Select(12, (void *)&keyframes);
}

void
Plot::SelectDatabaseKeyframes()
{
    Select(13, (void *)&databaseKeyframes);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Plot::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
Plot::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "stateType";
        case 1:  return "plotType";
        case 2:  return "activeFlag";
        case 3:  return "hiddenFlag";
        case 4:  return "expandedFlag";
        case 5:  return "plotVar";
        case 6:  return "databaseName";
        case 7:  return "operators";
        case 8:  return "activeOperator";
        case 9:  return "id";
        case 10:  return "beginFrame";
        case 11:  return "endFrame";
        case 12:  return "keyframes";
        case 13:  return "databaseKeyframes";
        case 14:  return "isFromSimulation";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Plot::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
Plot::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_int;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_string;
        case 6:  return FieldType_string;
        case 7:  return FieldType_intVector;
        case 8:  return FieldType_int;
        case 9:  return FieldType_int;
        case 10:  return FieldType_int;
        case 11:  return FieldType_int;
        case 12:  return FieldType_intVector;
        case 13:  return FieldType_intVector;
        case 14:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: Plot::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
Plot::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "int";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "bool";
        case 5:  return "string";
        case 6:  return "string";
        case 7:  return "intVector";
        case 8:  return "int";
        case 9:  return "int";
        case 10:  return "int";
        case 11:  return "int";
        case 12:  return "intVector";
        case 13:  return "intVector";
        case 14:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Plot::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 30 12:25:01 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Plot::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const Plot &obj = *((const Plot*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (stateType == obj.stateType);
        }
        break;
    case 1:
        {  // new scope
        retval = (plotType == obj.plotType);
        }
        break;
    case 2:
        {  // new scope
        retval = (activeFlag == obj.activeFlag);
        }
        break;
    case 3:
        {  // new scope
        retval = (hiddenFlag == obj.hiddenFlag);
        }
        break;
    case 4:
        {  // new scope
        retval = (expandedFlag == obj.expandedFlag);
        }
        break;
    case 5:
        {  // new scope
        retval = (plotVar == obj.plotVar);
        }
        break;
    case 6:
        {  // new scope
        retval = (databaseName == obj.databaseName);
        }
        break;
    case 7:
        {  // new scope
        retval = (operators == obj.operators);
        }
        break;
    case 8:
        {  // new scope
        retval = (activeOperator == obj.activeOperator);
        }
        break;
    case 9:
        {  // new scope
        retval = (id == obj.id);
        }
        break;
    case 10:
        {  // new scope
        retval = (beginFrame == obj.beginFrame);
        }
        break;
    case 11:
        {  // new scope
        retval = (endFrame == obj.endFrame);
        }
        break;
    case 12:
        {  // new scope
        retval = (keyframes == obj.keyframes);
        }
        break;
    case 13:
        {  // new scope
        retval = (databaseKeyframes == obj.databaseKeyframes);
        }
        break;
    case 14:
        {  // new scope
        retval = (isFromSimulation == obj.isFromSimulation);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
Plot::AddOperator(int op)
{
    operators.push_back(op);
    Select(6, (void *)&operators);
}

void
Plot::ClearAllOperators()
{
    if(operators.size() > 0)
    {
        operators.clear();
        Select(6, (void *)&operators);
    }
}

int
Plot::GetNumOperators() const
{
    return operators.size();
}

int
Plot::GetOperator(int i) const
{
    return operators[i];
}

void
Plot::RemoveLastOperator()
{
    if(operators.size() > 0)
    {
        operators.pop_back();
        Select(6, (void *)&operators);
    }
}

